/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.acceptance.boot;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.acceptance.boot.AcceptanceRunner;
import net.nemerosa.ontrack.acceptance.boot.AcceptanceTestRunner;
import net.nemerosa.ontrack.acceptance.boot.XMLRunListener;
import net.nemerosa.ontrack.acceptance.config.AcceptanceConfig;
import net.nemerosa.ontrack.acceptance.config.AcceptanceConfigRule;
import net.nemerosa.ontrack.acceptance.support.AcceptanceTest;
import net.nemerosa.ontrack.acceptance.support.AcceptanceTestSuite;
import org.jetbrains.annotations.NotNull;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class JUnitAcceptanceRunner
implements AcceptanceRunner {
    private final Logger logger = LoggerFactory.getLogger(JUnitAcceptanceRunner.class);
    private final ApplicationContext applicationContext;
    private final AcceptanceConfig config;

    @Autowired
    public JUnitAcceptanceRunner(AcceptanceConfig config, ApplicationContext applicationContext) {
        this.config = config;
        this.applicationContext = applicationContext;
    }

    public boolean run() {
        this.logger.info("Starting acceptance tests...");
        this.logger.info("Using Acceptance config...");
        this.config.log(arg_0 -> ((Logger)this.logger).info(arg_0));
        AcceptanceConfigRule.setGlobalConfig((AcceptanceConfig)this.config);
        JUnitCore junit = new JUnitCore();
        XMLRunListener xmlRunListener = new XMLRunListener(System.out);
        junit.addListener((RunListener)xmlRunListener);
        Map suites = this.applicationContext.getBeansWithAnnotation(AcceptanceTestSuite.class);
        List classes = suites.entrySet().stream().filter(entry -> {
            String name = (String)entry.getKey();
            AcceptanceTest acceptanceTest = (AcceptanceTest)this.applicationContext.findAnnotationOnBean(name, AcceptanceTest.class);
            return this.config.acceptTest(acceptanceTest);
        }).map(entry -> entry.getValue().getClass()).collect(Collectors.toList());
        List runners = classes.stream().map(arg_0 -> this.createAcceptanceTestRunner(arg_0)).collect(Collectors.toList());
        boolean ok = runners.stream().map(arg_0 -> ((JUnitCore)junit).run(arg_0)).allMatch(Result::wasSuccessful);
        xmlRunListener.render(new File(this.config.getOutputDir(), this.config.getResultFileName()));
        return ok;
    }

    @NotNull
    private AcceptanceTestRunner createAcceptanceTestRunner(Class<?> it) {
        try {
            return new AcceptanceTestRunner(it, this.config);
        }
        catch (InitializationError initializationError) {
            throw new RuntimeException("Cannot create acceptance runner for " + it);
        }
    }
}

