/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.acceptance.config;

import java.io.File;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import net.nemerosa.ontrack.acceptance.boot.AcceptanceMissingURLException;
import net.nemerosa.ontrack.acceptance.config.AcceptanceConfig;
import net.nemerosa.ontrack.acceptance.support.AcceptanceTest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@ConfigurationProperties(prefix="ontrack.acceptance")
public class AcceptanceConfig {
    private final Logger logger = LoggerFactory.getLogger(AcceptanceConfig.class);
    public static final String CONTEXT_ALL = "all";
    private String url = "http://localhost:8080";
    private String seleniumGridUrl = "";
    private String seleniumTargetUrl = "";
    private String seleniumBrowserName = "firefox";
    private boolean disableSsl = false;
    private String admin = "admin";
    private String context = null;
    private int timeout = 120;
    private int implicitWait = 5;
    private File outputDir = new File("build/acceptance");
    private String resultFileName = "ontrack-acceptance.xml";
    private String influxdbUri = "http://localhost:8086";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void check() throws InterruptedException, ExecutionException, TimeoutException {
        if (StringUtils.isBlank((CharSequence)this.url)) {
            throw new AcceptanceMissingURLException();
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            this.logger.info(String.format("Waiting %d s for %s to be available...", this.timeout, this.url));
            AcceptanceTargetCheck check = new AcceptanceTargetCheck(this, null);
            Future future = executor.submit(check);
            String version = (String)future.get(this.timeout, TimeUnit.SECONDS);
            this.logger.info(String.format("Getting version %s", version));
        }
        finally {
            executor.shutdownNow();
        }
    }

    public boolean acceptTest(AcceptanceTest root, AcceptanceTest member) {
        if (this.acceptTest(root)) {
            if (root != null && root.explicit()) {
                return member == null || this.acceptTest(member);
            }
            return this.acceptTest(member);
        }
        return false;
    }

    public boolean acceptTest(AcceptanceTest acceptanceTest) {
        if (acceptanceTest != null && acceptanceTest.explicit()) {
            return this.context != null && Arrays.asList(acceptanceTest.value()).contains(this.context);
        }
        return StringUtils.isBlank((CharSequence)this.context) || StringUtils.equals((CharSequence)"all", (CharSequence)this.context) || acceptanceTest != null && Arrays.asList(acceptanceTest.value()).contains(this.context);
    }

    public void log(Consumer<String> logger) {
        logger.accept(String.format(">>> Ontrack URL:         %s", this.url));
        logger.accept(String.format(">>> Selenium grid URL:   %s", this.seleniumGridUrl));
        logger.accept(String.format(">>> Selenium browser:    %s", this.seleniumBrowserName));
        logger.accept(String.format(">>> Selenium target URL: %s", this.seleniumTargetUrl));
        logger.accept(String.format(">>> Disable SSL:         %s", this.disableSsl));
        logger.accept(String.format(">>> Admin password:      %s", "admin".equals(this.admin) ? "admin" : "****"));
        logger.accept(String.format(">>> Context:             %s", this.context));
        logger.accept(String.format(">>> Timeout:             %s", this.timeout));
        logger.accept(String.format(">>> Implicit wait:       %s", this.implicitWait));
        logger.accept(String.format(">>> Output directory:    %s", this.outputDir));
        logger.accept(String.format(">>> Result file name:    %s", this.resultFileName));
        logger.accept(String.format(">>> InfluxDB URI:        %s", this.influxdbUri));
    }

    public static AcceptanceConfig fromEnv() {
        AcceptanceConfig c = new AcceptanceConfig();
        c.setUrl(AcceptanceConfig.env((String)"ontrack.acceptance.url", (String)c.getUrl(), (String)"Ontrack URL"));
        c.setSeleniumGridUrl(AcceptanceConfig.env((String)"ontrack.acceptance.selenium-grid-url", (String)c.getSeleniumGridUrl(), (String)"Selenium Grid URL"));
        c.setSeleniumBrowserName(AcceptanceConfig.env((String)"ontrack.acceptance.selenium-browser-name", (String)c.getSeleniumBrowserName(), (String)"Selenium Browser Name"));
        c.setSeleniumGridUrl(AcceptanceConfig.env((String)"ontrack.acceptance.selenium-target-url", (String)c.getSeleniumTargetUrl(), (String)"Selenium Target URL"));
        c.setDisableSsl(AcceptanceConfig.envAsBoolean((String)"ontrack.acceptance.disable-ssl", (boolean)c.isDisableSsl(), (String)"Disabling SSL"));
        c.setAdmin(AcceptanceConfig.env((String)"ontrack.acceptance.admin", (String)c.getAdmin(), (String)"Admin password"));
        c.setContext(AcceptanceConfig.env((String)"ontrack.acceptance.context", (String)c.getContext(), (String)"Test context"));
        c.setTimeout(AcceptanceConfig.envAsInt((String)"ontrack.acceptance.timeout", (int)c.getTimeout(), (String)"Timeout for Ontrack (s)"));
        c.setImplicitWait(AcceptanceConfig.envAsInt((String)"ontrack.acceptance.implicit-wait", (int)c.getImplicitWait(), (String)"GUI element wait (s)"));
        c.setOutputDir(AcceptanceConfig.envAsFile((String)"ontrack.acceptance.output-dir", (File)c.getOutputDir(), (String)"Output directory"));
        c.setResultFileName(AcceptanceConfig.env((String)"ontrack.acceptance.result-file-name", (String)"ontrack-acceptance.xml", (String)"Output directory"));
        c.setInfluxdbUri(AcceptanceConfig.env((String)"ontrack.acceptance.influxdb-uri", (String)"http://localhost:8086", (String)"URI to the InfluxDB database"));
        return c;
    }

    private static String env(String property, String defaultValue, String name) {
        String sys = System.getProperty(property);
        if (StringUtils.isNotBlank((CharSequence)sys)) {
            return sys;
        }
        String envName = property.toUpperCase().replace(".", "_");
        String env = System.getenv(envName);
        if (StringUtils.isNotBlank((CharSequence)env)) {
            return env;
        }
        return defaultValue;
    }

    private static boolean envAsBoolean(String property, boolean defaultValue, String name) {
        String value = AcceptanceConfig.env((String)property, null, (String)name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    private static int envAsInt(String property, int defaultValue, String name) {
        String value = AcceptanceConfig.env((String)property, null, (String)name);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value, 10);
    }

    private static File envAsFile(String property, File defaultValue, String name) {
        String value = AcceptanceConfig.env((String)property, null, (String)name);
        if (value == null) {
            return defaultValue;
        }
        return new File(value);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSeleniumGridUrl() {
        return this.seleniumGridUrl;
    }

    public String getSeleniumTargetUrl() {
        return this.seleniumTargetUrl;
    }

    public String getSeleniumBrowserName() {
        return this.seleniumBrowserName;
    }

    public boolean isDisableSsl() {
        return this.disableSsl;
    }

    public String getAdmin() {
        return this.admin;
    }

    public String getContext() {
        return this.context;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getImplicitWait() {
        return this.implicitWait;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public String getResultFileName() {
        return this.resultFileName;
    }

    public String getInfluxdbUri() {
        return this.influxdbUri;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSeleniumGridUrl(String seleniumGridUrl) {
        this.seleniumGridUrl = seleniumGridUrl;
    }

    public void setSeleniumTargetUrl(String seleniumTargetUrl) {
        this.seleniumTargetUrl = seleniumTargetUrl;
    }

    public void setSeleniumBrowserName(String seleniumBrowserName) {
        this.seleniumBrowserName = seleniumBrowserName;
    }

    public void setDisableSsl(boolean disableSsl) {
        this.disableSsl = disableSsl;
    }

    public void setAdmin(String admin) {
        this.admin = admin;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setImplicitWait(int implicitWait) {
        this.implicitWait = implicitWait;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void setResultFileName(String resultFileName) {
        this.resultFileName = resultFileName;
    }

    public void setInfluxdbUri(String influxdbUri) {
        this.influxdbUri = influxdbUri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcceptanceConfig)) {
            return false;
        }
        AcceptanceConfig other = (AcceptanceConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$seleniumGridUrl = this.getSeleniumGridUrl();
        String other$seleniumGridUrl = other.getSeleniumGridUrl();
        if (this$seleniumGridUrl == null ? other$seleniumGridUrl != null : !this$seleniumGridUrl.equals(other$seleniumGridUrl)) {
            return false;
        }
        String this$seleniumTargetUrl = this.getSeleniumTargetUrl();
        String other$seleniumTargetUrl = other.getSeleniumTargetUrl();
        if (this$seleniumTargetUrl == null ? other$seleniumTargetUrl != null : !this$seleniumTargetUrl.equals(other$seleniumTargetUrl)) {
            return false;
        }
        String this$seleniumBrowserName = this.getSeleniumBrowserName();
        String other$seleniumBrowserName = other.getSeleniumBrowserName();
        if (this$seleniumBrowserName == null ? other$seleniumBrowserName != null : !this$seleniumBrowserName.equals(other$seleniumBrowserName)) {
            return false;
        }
        if (this.isDisableSsl() != other.isDisableSsl()) {
            return false;
        }
        String this$admin = this.getAdmin();
        String other$admin = other.getAdmin();
        if (this$admin == null ? other$admin != null : !this$admin.equals(other$admin)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.getImplicitWait() != other.getImplicitWait()) {
            return false;
        }
        File this$outputDir = this.getOutputDir();
        File other$outputDir = other.getOutputDir();
        if (this$outputDir == null ? other$outputDir != null : !((Object)this$outputDir).equals(other$outputDir)) {
            return false;
        }
        String this$resultFileName = this.getResultFileName();
        String other$resultFileName = other.getResultFileName();
        if (this$resultFileName == null ? other$resultFileName != null : !this$resultFileName.equals(other$resultFileName)) {
            return false;
        }
        String this$influxdbUri = this.getInfluxdbUri();
        String other$influxdbUri = other.getInfluxdbUri();
        return !(this$influxdbUri == null ? other$influxdbUri != null : !this$influxdbUri.equals(other$influxdbUri));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AcceptanceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $seleniumGridUrl = this.getSeleniumGridUrl();
        result = result * 59 + ($seleniumGridUrl == null ? 43 : $seleniumGridUrl.hashCode());
        String $seleniumTargetUrl = this.getSeleniumTargetUrl();
        result = result * 59 + ($seleniumTargetUrl == null ? 43 : $seleniumTargetUrl.hashCode());
        String $seleniumBrowserName = this.getSeleniumBrowserName();
        result = result * 59 + ($seleniumBrowserName == null ? 43 : $seleniumBrowserName.hashCode());
        result = result * 59 + (this.isDisableSsl() ? 79 : 97);
        String $admin = this.getAdmin();
        result = result * 59 + ($admin == null ? 43 : $admin.hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        result = result * 59 + this.getTimeout();
        result = result * 59 + this.getImplicitWait();
        File $outputDir = this.getOutputDir();
        result = result * 59 + ($outputDir == null ? 43 : ((Object)$outputDir).hashCode());
        String $resultFileName = this.getResultFileName();
        result = result * 59 + ($resultFileName == null ? 43 : $resultFileName.hashCode());
        String $influxdbUri = this.getInfluxdbUri();
        result = result * 59 + ($influxdbUri == null ? 43 : $influxdbUri.hashCode());
        return result;
    }

    public String toString() {
        return "AcceptanceConfig(logger=" + this.getLogger() + ", url=" + this.getUrl() + ", seleniumGridUrl=" + this.getSeleniumGridUrl() + ", seleniumTargetUrl=" + this.getSeleniumTargetUrl() + ", seleniumBrowserName=" + this.getSeleniumBrowserName() + ", disableSsl=" + this.isDisableSsl() + ", admin=" + this.getAdmin() + ", context=" + this.getContext() + ", timeout=" + this.getTimeout() + ", implicitWait=" + this.getImplicitWait() + ", outputDir=" + this.getOutputDir() + ", resultFileName=" + this.getResultFileName() + ", influxdbUri=" + this.getInfluxdbUri() + ")";
    }

    static /* synthetic */ String access$100(AcceptanceConfig x0) {
        return x0.url;
    }

    static /* synthetic */ boolean access$200(AcceptanceConfig x0) {
        return x0.disableSsl;
    }

    static /* synthetic */ Logger access$300(AcceptanceConfig x0) {
        return x0.logger;
    }
}

