/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.git;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import net.nemerosa.ontrack.extension.git.AbstractGitTestSupport;
import net.nemerosa.ontrack.extension.git.mocking.GitMockingConfigurator;
import net.nemerosa.ontrack.extension.git.model.GitBranchConfiguration;
import net.nemerosa.ontrack.extension.git.model.GitPullRequest;
import net.nemerosa.ontrack.git.support.GitRepo;
import net.nemerosa.ontrack.it.AbstractDSLTestJUnit4Support;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Project;
import org.jetbrains.annotations.NotNull;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\u0006H\u0017J\b\u0010\b\u001a\u00020\u0006H\u0017J\b\u0010\t\u001a\u00020\u0006H\u0017J\b\u0010\n\u001a\u00020\u0006H\u0017J\b\u0010\u000b\u001a\u00020\u0006H\u0017R\u0012\u0010\u0003\u001a\u00020\u00048\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/nemerosa/ontrack/extension/git/GitPullRequestIT;", "Lnet/nemerosa/ontrack/extension/git/AbstractGitTestSupport;", "()V", "gitMockingConfigurator", "Lnet/nemerosa/ontrack/extension/git/mocking/GitMockingConfigurator;", "Branch configuration for a PR is marked as pull request", "", "Branch configuration for a normal branch is not marked as pull request", "No PR information when not enabled", "PR information as the PR is deleted", "PR status changing", "init", "ontrack-extension-git"})
public class GitPullRequestIT
extends AbstractGitTestSupport {
    @Autowired
    private GitMockingConfigurator gitMockingConfigurator;

    @Before
    public void init() {
        GitMockingConfigurator gitMockingConfigurator = this.gitMockingConfigurator;
        if (gitMockingConfigurator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
            gitMockingConfigurator = null;
        }
        gitMockingConfigurator.clearPullRequests();
    }

    @Test
    public void Branch configuration for a normal branch is not marked as pull request() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ GitPullRequestIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ GitPullRequestIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ GitPullRequestIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ GitPullRequestIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Branch $this$branch) {
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                AbstractGitTestSupport.gitBranch$default(this.this$0, $this$branch, "release/1.0", null, 2, null);
                                GitBranchConfiguration branchConfiguration = this.this$0.getGitService().getBranchConfiguration($this$branch);
                                GitBranchConfiguration it = (GitBranchConfiguration)AssertionsKt.assertNotNull((Object)branchConfiguration, null);
                                boolean bl = false;
                                AssertionsKt.assertEquals$default((Object)"release/1.0", (Object)it.getBranch(), null, (int)4, null);
                                AssertionsKt.assertNull$default((Object)it.getPullRequest(), null, (int)2, null);
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void Branch configuration for a PR is marked as pull request() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ GitPullRequestIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ GitPullRequestIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                GitMockingConfigurator gitMockingConfigurator = GitPullRequestIT.access$getGitMockingConfigurator$p(this.this$0);
                if (gitMockingConfigurator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                    gitMockingConfigurator = null;
                }
                GitMockingConfigurator.registerPullRequest$default(gitMockingConfigurator, 1, null, null, "Useful feature", null, false, 54, null);
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ GitPullRequestIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ GitPullRequestIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Branch $this$branch) {
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                AbstractGitTestSupport.gitBranch$default(this.this$0, $this$branch, "PR-1", null, 2, null);
                                GitBranchConfiguration branchConfiguration = this.this$0.getGitService().getBranchConfiguration($this$branch);
                                GitBranchConfiguration it = (GitBranchConfiguration)AssertionsKt.assertNotNull((Object)branchConfiguration, null);
                                boolean bl = false;
                                AssertionsKt.assertEquals$default((Object)"PR-1", (Object)it.getBranch(), null, (int)4, null);
                                GitPullRequest gitPullRequest = it.getPullRequest();
                                GitPullRequest pr = (GitPullRequest)AssertionsKt.assertNotNull((Object)gitPullRequest, null);
                                boolean bl2 = false;
                                AssertionsKt.assertEquals$default((Object)1, (Object)pr.getId(), null, (int)4, null);
                                AssertionsKt.assertEquals$default((Object)true, (Object)pr.isValid(), null, (int)4, null);
                                AssertionsKt.assertEquals$default((Object)"#1", (Object)pr.getKey(), null, (int)4, null);
                                AssertionsKt.assertEquals$default((Object)"feature/TK-1-feature", (Object)pr.getSource(), null, (int)4, null);
                                AssertionsKt.assertEquals$default((Object)"release/1.0", (Object)pr.getTarget(), null, (int)4, null);
                                AssertionsKt.assertEquals$default((Object)"Useful feature", (Object)pr.getTitle(), null, (int)4, null);
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void No PR information when not enabled() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ GitPullRequestIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ GitPullRequestIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                GitMockingConfigurator gitMockingConfigurator = GitPullRequestIT.access$getGitMockingConfigurator$p(this.this$0);
                if (gitMockingConfigurator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                    gitMockingConfigurator = null;
                }
                GitMockingConfigurator.registerPullRequest$default(gitMockingConfigurator, 1, null, null, "Useful feature", null, false, 54, null);
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ GitPullRequestIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ GitPullRequestIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final void invoke(@NotNull Branch $this$branch) {
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                AbstractGitTestSupport.gitBranch$default(this.this$0, $this$branch, "PR-1", null, 2, null);
                                this.this$0.getGitConfigProperties().getPullRequests().setEnabled(false);
                                try {
                                    GitBranchConfiguration branchConfiguration = this.this$0.getGitService().getBranchConfiguration($this$branch);
                                    GitBranchConfiguration it = (GitBranchConfiguration)AssertionsKt.assertNotNull((Object)branchConfiguration, null);
                                    boolean bl = false;
                                    AssertionsKt.assertEquals$default((Object)"PR-1", (Object)it.getBranch(), null, (int)4, null);
                                    AssertionsKt.assertNull((Object)it.getPullRequest(), (String)"PR is not reported since it's deactivated");
                                }
                                finally {
                                    this.this$0.getGitConfigProperties().getPullRequests().setEnabled(true);
                                }
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void PR status changing() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ GitPullRequestIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ GitPullRequestIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                GitMockingConfigurator gitMockingConfigurator = GitPullRequestIT.access$getGitMockingConfigurator$p(this.this$0);
                if (gitMockingConfigurator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                    gitMockingConfigurator = null;
                }
                GitMockingConfigurator.registerPullRequest$default(gitMockingConfigurator, 1, null, null, null, "open", false, 46, null);
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ GitPullRequestIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ GitPullRequestIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Branch $this$branch) {
                                GitPullRequest gitPullRequest;
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                AbstractGitTestSupport.gitBranch$default(this.this$0, $this$branch, "PR-1", null, 2, null);
                                GitBranchConfiguration gitBranchConfiguration = this.this$0.getGitService().getBranchConfiguration($this$branch);
                                AssertionsKt.assertEquals$default((Object)"open", gitBranchConfiguration != null && (gitPullRequest = gitBranchConfiguration.getPullRequest()) != null ? gitPullRequest.getStatus() : null, null, (int)4, null);
                                this.this$0.withPRCacheDisabled((Function0)new Function0<Unit>(this.this$0, $this$branch){
                                    final /* synthetic */ GitPullRequestIT this$0;
                                    final /* synthetic */ Branch $this_branch;
                                    {
                                        this.this$0 = $receiver;
                                        this.$this_branch = $this_branch;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        GitPullRequest gitPullRequest;
                                        GitMockingConfigurator gitMockingConfigurator = GitPullRequestIT.access$getGitMockingConfigurator$p(this.this$0);
                                        if (gitMockingConfigurator == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                                            gitMockingConfigurator = null;
                                        }
                                        GitMockingConfigurator.registerPullRequest$default(gitMockingConfigurator, 1, null, null, null, "closed", false, 46, null);
                                        GitBranchConfiguration gitBranchConfiguration = this.this$0.getGitService().getBranchConfiguration(this.$this_branch);
                                        AssertionsKt.assertEquals$default((Object)"closed", gitBranchConfiguration != null && (gitPullRequest = gitBranchConfiguration.getPullRequest()) != null ? gitPullRequest.getStatus() : null, null, (int)4, null);
                                    }
                                });
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void PR information as the PR is deleted() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ GitPullRequestIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ GitPullRequestIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                GitMockingConfigurator gitMockingConfigurator = GitPullRequestIT.access$getGitMockingConfigurator$p(this.this$0);
                if (gitMockingConfigurator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                    gitMockingConfigurator = null;
                }
                GitMockingConfigurator.registerPullRequest$default(gitMockingConfigurator, 1, null, null, null, null, false, 62, null);
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ GitPullRequestIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ GitPullRequestIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Branch $this$branch) {
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                AbstractGitTestSupport.gitBranch$default(this.this$0, $this$branch, "PR-1", null, 2, null);
                                GitBranchConfiguration gitBranchConfiguration = this.this$0.getGitService().getBranchConfiguration($this$branch);
                                GitBranchConfiguration config = (GitBranchConfiguration)AssertionsKt.assertNotNull((Object)gitBranchConfiguration, null);
                                boolean bl = false;
                                GitPullRequest gitPullRequest = config.getPullRequest();
                                GitPullRequest pr = (GitPullRequest)AssertionsKt.assertNotNull((Object)gitPullRequest, null);
                                boolean bl2 = false;
                                AssertionsKt.assertEquals$default((Object)1, (Object)pr.getId(), null, (int)4, null);
                                AssertionsKt.assertEquals$default((Object)true, (Object)pr.isValid(), null, (int)4, null);
                                AssertionsKt.assertEquals$default((Object)"#1", (Object)pr.getKey(), null, (int)4, null);
                                AssertionsKt.assertEquals$default((Object)"feature/TK-1-feature", (Object)pr.getSource(), null, (int)4, null);
                                AssertionsKt.assertEquals$default((Object)"release/1.0", (Object)pr.getTarget(), null, (int)4, null);
                                AssertionsKt.assertEquals$default((Object)"PR n\u00b01", (Object)pr.getTitle(), null, (int)4, null);
                                this.this$0.withPRCacheDisabled((Function0)new Function0<Unit>(this.this$0, $this$branch){
                                    final /* synthetic */ GitPullRequestIT this$0;
                                    final /* synthetic */ Branch $this_branch;
                                    {
                                        this.this$0 = $receiver;
                                        this.$this_branch = $this_branch;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        GitMockingConfigurator gitMockingConfigurator = GitPullRequestIT.access$getGitMockingConfigurator$p(this.this$0);
                                        if (gitMockingConfigurator == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                                            gitMockingConfigurator = null;
                                        }
                                        gitMockingConfigurator.unregisterPullRequest(1);
                                        GitBranchConfiguration gitBranchConfiguration = this.this$0.getGitService().getBranchConfiguration(this.$this_branch);
                                        GitBranchConfiguration config = (GitBranchConfiguration)AssertionsKt.assertNotNull((Object)gitBranchConfiguration, null);
                                        boolean bl = false;
                                        GitPullRequest gitPullRequest = config.getPullRequest();
                                        GitPullRequest pr = (GitPullRequest)AssertionsKt.assertNotNull((Object)gitPullRequest, (String)"Branch still identified as a pull request");
                                        boolean bl2 = false;
                                        AssertionsKt.assertEquals$default((Object)1, (Object)pr.getId(), null, (int)4, null);
                                        AssertionsKt.assertEquals$default((Object)false, (Object)pr.isValid(), null, (int)4, null);
                                        AssertionsKt.assertEquals$default((Object)"#1", (Object)pr.getKey(), null, (int)4, null);
                                        AssertionsKt.assertEquals$default((Object)"", (Object)pr.getSource(), null, (int)4, null);
                                        AssertionsKt.assertEquals$default((Object)"", (Object)pr.getTarget(), null, (int)4, null);
                                        AssertionsKt.assertEquals$default((Object)"", (Object)pr.getTitle(), null, (int)4, null);
                                    }
                                });
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    public static final /* synthetic */ GitMockingConfigurator access$getGitMockingConfigurator$p(GitPullRequestIT $this) {
        return $this.gitMockingConfigurator;
    }
}

