/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.git;

import java.time.LocalDateTime;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.extension.git.AbstractGitTestSupport;
import net.nemerosa.ontrack.extension.git.PullRequestStaleBranchCheck;
import net.nemerosa.ontrack.extension.git.mocking.GitMockingConfigurator;
import net.nemerosa.ontrack.extension.git.model.ConfiguredBuildGitCommitLink;
import net.nemerosa.ontrack.extension.stale.StaleBranchStatus;
import net.nemerosa.ontrack.git.support.GitRepo;
import net.nemerosa.ontrack.it.AbstractDSLTestJUnit4Support;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.Signature;
import org.jetbrains.annotations.NotNull;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\bH\u0017J\b\u0010\n\u001a\u00020\bH\u0017J\b\u0010\u000b\u001a\u00020\bH\u0017J\b\u0010\f\u001a\u00020\bH\u0017J\b\u0010\r\u001a\u00020\bH\u0017J\b\u0010\u000e\u001a\u00020\bH\u0017J\b\u0010\u000f\u001a\u00020\bH\u0017J\b\u0010\u0010\u001a\u00020\bH\u0017J\b\u0010\u0011\u001a\u00020\bH\u0017J\b\u0010\u0012\u001a\u00020\bH\u0017J\b\u0010\u0013\u001a\u00020\bH\u0017J\b\u0010\u0014\u001a\u00020\bH\u0017J\b\u0010\u0015\u001a\u00020\bH\u0017J\b\u0010\u0016\u001a\u00020\bH\u0017J\b\u0010\u0017\u001a\u00020\bH\u0017R\u0012\u0010\u0003\u001a\u00020\u00048\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCheckIT;", "Lnet/nemerosa/ontrack/extension/git/AbstractGitTestSupport;", "()V", "check", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCheck;", "gitMockingConfigurator", "Lnet/nemerosa/ontrack/extension/git/mocking/GitMockingConfigurator;", "Branch not eligible if PR are not enabled", "", "Branch not eligible if PR cleanup is not enabled", "Branch not eligible if not a PR", "Branch not eligible if not configured for Git", "Invalid PR on build to delete", "Invalid PR on build to disable", "Invalid PR on recent build", "Missing PR on build to delete", "Missing PR on build to disable", "Missing PR on recent build", "Project not eligible if PR are not enabled", "Project not eligible if PR cleanup is not enabled", "Project not eligible if not configured for Git", "Valid PR on old build", "Valid PR on recent build", "init", "ontrack-extension-git"})
public class PullRequestStaleBranchCheckIT
extends AbstractGitTestSupport {
    @Autowired
    private PullRequestStaleBranchCheck check;
    @Autowired
    private GitMockingConfigurator gitMockingConfigurator;

    @Before
    public void init() {
        GitMockingConfigurator gitMockingConfigurator = this.gitMockingConfigurator;
        if (gitMockingConfigurator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
            gitMockingConfigurator = null;
        }
        gitMockingConfigurator.clearPullRequests();
    }

    @Test
    public void Project not eligible if not configured for Git() {
        AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this), null, (Function1)((Function1)new Function1<Project, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Project $this$project) {
                Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                if (pullRequestStaleBranchCheck == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                    pullRequestStaleBranchCheck = null;
                }
                AssertionsKt.assertFalse((boolean)pullRequestStaleBranchCheck.isProjectEligible($this$project), (String)"Project is not eligible for PR branch check because not on Git");
            }
        }), (int)1, null);
    }

    @Test
    public void Project not eligible if PR are not enabled() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        this.this$0.withPRDisabled((Function0)new Function0<Unit>(this.this$0, $this$project){
                            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                            final /* synthetic */ Project $this_project;
                            {
                                this.this$0 = $receiver;
                                this.$this_project = $this_project;
                                super(0);
                            }

                            public final void invoke() {
                                PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                                if (pullRequestStaleBranchCheck == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                    pullRequestStaleBranchCheck = null;
                                }
                                AssertionsKt.assertFalse((boolean)pullRequestStaleBranchCheck.isProjectEligible(this.$this_project), (String)"Project is not eligible for PR branch check because PR are not enabled");
                            }
                        });
                        PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                        if (pullRequestStaleBranchCheck == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                            pullRequestStaleBranchCheck = null;
                        }
                        AssertionsKt.assertTrue((boolean)pullRequestStaleBranchCheck.isProjectEligible($this$project), (String)"Project is eligible for PR branch check because PR are enabled");
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void Project not eligible if PR cleanup is not enabled() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        this.this$0.withPRCleanupDisabled((Function0)new Function0<Unit>(this.this$0, $this$project){
                            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                            final /* synthetic */ Project $this_project;
                            {
                                this.this$0 = $receiver;
                                this.$this_project = $this_project;
                                super(0);
                            }

                            public final void invoke() {
                                PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                                if (pullRequestStaleBranchCheck == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                    pullRequestStaleBranchCheck = null;
                                }
                                AssertionsKt.assertFalse((boolean)pullRequestStaleBranchCheck.isProjectEligible(this.$this_project), (String)"Project is not eligible for PR branch check because PR cleanup is not enabled");
                            }
                        });
                        PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                        if (pullRequestStaleBranchCheck == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                            pullRequestStaleBranchCheck = null;
                        }
                        AssertionsKt.assertTrue((boolean)pullRequestStaleBranchCheck.isProjectEligible($this$project), (String)"Project is eligible for PR branch check because PR cleanup is enabled");
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void Branch not eligible if not configured for Git() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Branch $this$branch) {
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                                if (pullRequestStaleBranchCheck == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                    pullRequestStaleBranchCheck = null;
                                }
                                AssertionsKt.assertFalse((boolean)pullRequestStaleBranchCheck.isBranchEligible($this$branch), (String)"Branch is not eligible for PR branch check because not on Git");
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void Branch not eligible if not a PR() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Branch $this$branch) {
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                AbstractGitTestSupport.gitBranch$default(this.this$0, $this$branch, "main", null, 2, null);
                                PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                                if (pullRequestStaleBranchCheck == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                    pullRequestStaleBranchCheck = null;
                                }
                                AssertionsKt.assertFalse((boolean)pullRequestStaleBranchCheck.isBranchEligible($this$branch), (String)"Branch is not eligible for PR branch check because not a PR");
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void Branch not eligible if PR are not enabled() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Branch $this$branch) {
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                AbstractGitTestSupport.gitBranch$default(this.this$0, $this$branch, "PR-1", null, 2, null);
                                this.this$0.withPRDisabled((Function0)new Function0<Unit>(this.this$0, $this$branch){
                                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                                    final /* synthetic */ Branch $this_branch;
                                    {
                                        this.this$0 = $receiver;
                                        this.$this_branch = $this_branch;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                                        if (pullRequestStaleBranchCheck == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                            pullRequestStaleBranchCheck = null;
                                        }
                                        AssertionsKt.assertFalse((boolean)pullRequestStaleBranchCheck.isBranchEligible(this.$this_branch), (String)"Branch is not eligible for PR branch check because PR are not enabled");
                                    }
                                });
                                PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                                if (pullRequestStaleBranchCheck == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                    pullRequestStaleBranchCheck = null;
                                }
                                AssertionsKt.assertTrue((boolean)pullRequestStaleBranchCheck.isBranchEligible($this$branch), (String)"Branch is eligible for PR branch check because PR are enabled");
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void Branch not eligible if PR cleanup is not enabled() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Branch $this$branch) {
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                AbstractGitTestSupport.gitBranch$default(this.this$0, $this$branch, "PR-1", null, 2, null);
                                this.this$0.withPRCleanupDisabled((Function0)new Function0<Unit>(this.this$0, $this$branch){
                                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                                    final /* synthetic */ Branch $this_branch;
                                    {
                                        this.this$0 = $receiver;
                                        this.$this_branch = $this_branch;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                                        if (pullRequestStaleBranchCheck == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                            pullRequestStaleBranchCheck = null;
                                        }
                                        AssertionsKt.assertFalse((boolean)pullRequestStaleBranchCheck.isBranchEligible(this.$this_branch), (String)"Branch is not eligible for PR branch check because PR cleanup is not enabled");
                                    }
                                });
                                PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                                if (pullRequestStaleBranchCheck == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                    pullRequestStaleBranchCheck = null;
                                }
                                AssertionsKt.assertTrue((boolean)pullRequestStaleBranchCheck.isBranchEligible($this$branch), (String)"Branch is eligible for PR branch check because PR cleanup is enabled");
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void Valid PR on recent build() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Branch $this$branch) {
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                GitMockingConfigurator gitMockingConfigurator = PullRequestStaleBranchCheckIT.access$getGitMockingConfigurator$p(this.this$0);
                                if (gitMockingConfigurator == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                                    gitMockingConfigurator = null;
                                }
                                GitMockingConfigurator.registerPullRequest$default(gitMockingConfigurator, 1, null, null, null, null, false, 62, null);
                                this.this$0.gitBranch($this$branch, "PR-1", (Function0)new Function0<ConfiguredBuildGitCommitLink<?>>(this.this$0){
                                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @NotNull
                                    public final ConfiguredBuildGitCommitLink<?> invoke() {
                                        return this.this$0.commitAsProperty();
                                    }
                                });
                                Build build2 = AbstractDSLTestJUnit4Support.build$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Branch)$this$branch, null, null, (int)3, null);
                                PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                                if (pullRequestStaleBranchCheck == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                    pullRequestStaleBranchCheck = null;
                                }
                                AssertionsKt.assertEquals(null, (Object)pullRequestStaleBranchCheck.getBranchStaleness($this$branch, build2), (String)"No decision, keeping the branch");
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void Valid PR on old build() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Branch $this$branch) {
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                GitMockingConfigurator gitMockingConfigurator = PullRequestStaleBranchCheckIT.access$getGitMockingConfigurator$p(this.this$0);
                                if (gitMockingConfigurator == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                                    gitMockingConfigurator = null;
                                }
                                GitMockingConfigurator.registerPullRequest$default(gitMockingConfigurator, 1, null, null, null, null, false, 62, null);
                                this.this$0.gitBranch($this$branch, "PR-1", (Function0)new Function0<ConfiguredBuildGitCommitLink<?>>(this.this$0){
                                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @NotNull
                                    public final ConfiguredBuildGitCommitLink<?> invoke() {
                                        return this.this$0.commitAsProperty();
                                    }
                                });
                                Build build2 = AbstractDSLTestJUnit4Support.build$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Branch)$this$branch, null, null, (int)3, null);
                                LocalDateTime localDateTime = Time.now().minusDays(10L);
                                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now().minusDays(10)");
                                Build build3 = build2.withSignature(Signature.Companion.of(localDateTime, "test"));
                                PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                                if (pullRequestStaleBranchCheck == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                    pullRequestStaleBranchCheck = null;
                                }
                                AssertionsKt.assertEquals(null, (Object)pullRequestStaleBranchCheck.getBranchStaleness($this$branch, build3), (String)"No decision, keeping the branch");
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void Missing PR on recent build() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Branch $this$branch) {
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                this.this$0.gitBranch($this$branch, "PR-1", (Function0)new Function0<ConfiguredBuildGitCommitLink<?>>(this.this$0){
                                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @NotNull
                                    public final ConfiguredBuildGitCommitLink<?> invoke() {
                                        return this.this$0.commitAsProperty();
                                    }
                                });
                                Build build2 = AbstractDSLTestJUnit4Support.build$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Branch)$this$branch, null, null, (int)3, null);
                                PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                                if (pullRequestStaleBranchCheck == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                    pullRequestStaleBranchCheck = null;
                                }
                                AssertionsKt.assertEquals(null, (Object)pullRequestStaleBranchCheck.getBranchStaleness($this$branch, build2), (String)"No decision, keeping the branch");
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void Missing PR on build to disable() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Branch $this$branch) {
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                this.this$0.gitBranch($this$branch, "PR-1", (Function0)new Function0<ConfiguredBuildGitCommitLink<?>>(this.this$0){
                                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @NotNull
                                    public final ConfiguredBuildGitCommitLink<?> invoke() {
                                        return this.this$0.commitAsProperty();
                                    }
                                });
                                Build build2 = AbstractDSLTestJUnit4Support.build$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Branch)$this$branch, null, null, (int)3, null);
                                LocalDateTime localDateTime = Time.now().minusDays(6L);
                                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now().minusDays(6)");
                                Build build3 = build2.withSignature(Signature.Companion.of(localDateTime, "test"));
                                PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                                if (pullRequestStaleBranchCheck == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                    pullRequestStaleBranchCheck = null;
                                }
                                AssertionsKt.assertEquals((Object)StaleBranchStatus.DISABLE, (Object)pullRequestStaleBranchCheck.getBranchStaleness($this$branch, build3), (String)"Branch must be disabled");
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void Missing PR on build to delete() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Branch $this$branch) {
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                this.this$0.gitBranch($this$branch, "PR-1", (Function0)new Function0<ConfiguredBuildGitCommitLink<?>>(this.this$0){
                                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @NotNull
                                    public final ConfiguredBuildGitCommitLink<?> invoke() {
                                        return this.this$0.commitAsProperty();
                                    }
                                });
                                Build build2 = AbstractDSLTestJUnit4Support.build$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Branch)$this$branch, null, null, (int)3, null);
                                LocalDateTime localDateTime = Time.now().minusDays(10L);
                                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now().minusDays(10)");
                                Build build3 = build2.withSignature(Signature.Companion.of(localDateTime, "test"));
                                PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                                if (pullRequestStaleBranchCheck == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                    pullRequestStaleBranchCheck = null;
                                }
                                AssertionsKt.assertEquals((Object)StaleBranchStatus.DELETE, (Object)pullRequestStaleBranchCheck.getBranchStaleness($this$branch, build3), (String)"Branch must be deleted");
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void Invalid PR on recent build() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Branch $this$branch) {
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                GitMockingConfigurator gitMockingConfigurator = PullRequestStaleBranchCheckIT.access$getGitMockingConfigurator$p(this.this$0);
                                if (gitMockingConfigurator == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                                    gitMockingConfigurator = null;
                                }
                                GitMockingConfigurator.registerPullRequest$default(gitMockingConfigurator, 1, null, null, null, null, true, 30, null);
                                this.this$0.gitBranch($this$branch, "PR-1", (Function0)new Function0<ConfiguredBuildGitCommitLink<?>>(this.this$0){
                                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @NotNull
                                    public final ConfiguredBuildGitCommitLink<?> invoke() {
                                        return this.this$0.commitAsProperty();
                                    }
                                });
                                Build build2 = AbstractDSLTestJUnit4Support.build$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Branch)$this$branch, null, null, (int)3, null);
                                PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                                if (pullRequestStaleBranchCheck == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                    pullRequestStaleBranchCheck = null;
                                }
                                AssertionsKt.assertEquals(null, (Object)pullRequestStaleBranchCheck.getBranchStaleness($this$branch, build2), (String)"No decision, keeping the branch");
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void Invalid PR on build to disable() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Branch $this$branch) {
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                GitMockingConfigurator gitMockingConfigurator = PullRequestStaleBranchCheckIT.access$getGitMockingConfigurator$p(this.this$0);
                                if (gitMockingConfigurator == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                                    gitMockingConfigurator = null;
                                }
                                GitMockingConfigurator.registerPullRequest$default(gitMockingConfigurator, 1, null, null, null, null, true, 30, null);
                                this.this$0.gitBranch($this$branch, "PR-1", (Function0)new Function0<ConfiguredBuildGitCommitLink<?>>(this.this$0){
                                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @NotNull
                                    public final ConfiguredBuildGitCommitLink<?> invoke() {
                                        return this.this$0.commitAsProperty();
                                    }
                                });
                                Build build2 = AbstractDSLTestJUnit4Support.build$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Branch)$this$branch, null, null, (int)3, null);
                                LocalDateTime localDateTime = Time.now().minusDays(6L);
                                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now().minusDays(6)");
                                Build build3 = build2.withSignature(Signature.Companion.of(localDateTime, "test"));
                                PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                                if (pullRequestStaleBranchCheck == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                    pullRequestStaleBranchCheck = null;
                                }
                                AssertionsKt.assertEquals((Object)StaleBranchStatus.DISABLE, (Object)pullRequestStaleBranchCheck.getBranchStaleness($this$branch, build3), (String)"Branch must be disabled");
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void Invalid PR on build to delete() {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo){
                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0){
                            final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Branch $this$branch) {
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                GitMockingConfigurator gitMockingConfigurator = PullRequestStaleBranchCheckIT.access$getGitMockingConfigurator$p(this.this$0);
                                if (gitMockingConfigurator == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                                    gitMockingConfigurator = null;
                                }
                                GitMockingConfigurator.registerPullRequest$default(gitMockingConfigurator, 1, null, null, null, null, true, 30, null);
                                this.this$0.gitBranch($this$branch, "PR-1", (Function0)new Function0<ConfiguredBuildGitCommitLink<?>>(this.this$0){
                                    final /* synthetic */ PullRequestStaleBranchCheckIT this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @NotNull
                                    public final ConfiguredBuildGitCommitLink<?> invoke() {
                                        return this.this$0.commitAsProperty();
                                    }
                                });
                                Build build2 = AbstractDSLTestJUnit4Support.build$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Branch)$this$branch, null, null, (int)3, null);
                                LocalDateTime localDateTime = Time.now().minusDays(10L);
                                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now().minusDays(10)");
                                Build build3 = build2.withSignature(Signature.Companion.of(localDateTime, "test"));
                                PullRequestStaleBranchCheck pullRequestStaleBranchCheck = PullRequestStaleBranchCheckIT.access$getCheck$p(this.this$0);
                                if (pullRequestStaleBranchCheck == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                    pullRequestStaleBranchCheck = null;
                                }
                                AssertionsKt.assertEquals((Object)StaleBranchStatus.DELETE, (Object)pullRequestStaleBranchCheck.getBranchStaleness($this$branch, build3), (String)"Branch must be deleted");
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    public static final /* synthetic */ PullRequestStaleBranchCheck access$getCheck$p(PullRequestStaleBranchCheckIT $this) {
        return $this.check;
    }

    public static final /* synthetic */ GitMockingConfigurator access$getGitMockingConfigurator$p(PullRequestStaleBranchCheckIT $this) {
        return $this.gitMockingConfigurator;
    }
}

