/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.git;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.common._KTUtilsKt;
import net.nemerosa.ontrack.extension.git.AbstractGitTestSupport;
import net.nemerosa.ontrack.extension.git.PullRequestStaleBranchCompleteCheckIT;
import net.nemerosa.ontrack.extension.git.mocking.GitMockingConfigurator;
import net.nemerosa.ontrack.extension.git.model.ConfiguredBuildGitCommitLink;
import net.nemerosa.ontrack.extension.stale.StaleJobService;
import net.nemerosa.ontrack.extension.stale.StaleProperty;
import net.nemerosa.ontrack.extension.stale.StalePropertyType;
import net.nemerosa.ontrack.git.support.GitRepo;
import net.nemerosa.ontrack.it.AbstractDSLTestJUnit4Support;
import net.nemerosa.ontrack.job.JobRunListener;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0016\u0018\u00002\u00020\u0001:\u0006!\"#$%&B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0017J\f\u0010\u000b\u001a\u00060\fR\u00020\u0000H\u0012J\f\u0010\r\u001a\u00060\fR\u00020\u0000H\u0012J\b\u0010\u000e\u001a\u00020\nH\u0017J\f\u0010\u000f\u001a\u00060\u0010R\u00020\u0000H\u0012J\f\u0010\u0011\u001a\u00060\fR\u00020\u0000H\u0012J\f\u0010\u0012\u001a\u00060\u0013R\u00020\u0000H\u0012J\f\u0010\u0014\u001a\u00060\u0010R\u00020\u0000H\u0012J\f\u0010\u0015\u001a\u00060\u0016R\u00020\u0000H\u0012J\f\u0010\u0017\u001a\u00060\u0010R\u00020\u0000H\u0012J\f\u0010\u0018\u001a\u00060\u0013R\u00020\u0000H\u0012J\f\u0010\u0019\u001a\u00060\u0016R\u00020\u0000H\u0012J\f\u0010\u001a\u001a\u00060\u0016R\u00020\u0000H\u0012J\f\u0010\u001b\u001a\u00060\u0016R\u00020\u0000H\u0012J\f\u0010\u001c\u001a\u00060\u0016R\u00020\u0000H\u0012J\f\u0010\u001d\u001a\u00060\u0016R\u00020\u0000H\u0012J\f\u0010\u001e\u001a\u00060\u0016R\u00020\u0000H\u0012J\f\u0010\u001f\u001a\u00060\u0013R\u00020\u0000H\u0012J\f\u0010 \u001a\u00060\u0010R\u00020\u0000H\u0012R\u0012\u0010\u0003\u001a\u00020\u00048\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092D\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT;", "Lnet/nemerosa/ontrack/extension/git/AbstractGitTestSupport;", "()V", "gitMockingConfigurator", "Lnet/nemerosa/ontrack/extension/git/mocking/GitMockingConfigurator;", "promotionName", "", "staleJobService", "Lnet/nemerosa/ontrack/extension/stale/StaleJobService;", "All tests", "", "deleted", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$ExpectedResult;", "disabled", "init", "invalidPR", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$BranchPRConfiguration;", "kept", "medium", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$BuildConfiguration;", "missingPR", "none", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$PropertyConfiguration;", "notAPR", "old", "propertyWithMatchingIncludesAndMatchingExcludes", "propertyWithMatchingIncludesAndNoExcludes", "propertyWithMatchingIncludesAndNotMatchingExcludes", "propertyWithPromotionAndNotPromoted", "propertyWithPromotionAndPromoted", "propertyWithoutPromotion", "recent", "validPR", "BranchAndBuildConfiguration", "BranchConfiguration", "BranchPRConfiguration", "BuildConfiguration", "ExpectedResult", "PropertyConfiguration", "ontrack-extension-git"})
public class PullRequestStaleBranchCompleteCheckIT
extends AbstractGitTestSupport {
    @Autowired
    private GitMockingConfigurator gitMockingConfigurator;
    @Autowired
    private StaleJobService staleJobService;
    @NotNull
    private final String promotionName;

    public PullRequestStaleBranchCompleteCheckIT() {
        this.promotionName = "PL";
    }

    @Before
    public void init() {
        GitMockingConfigurator gitMockingConfigurator = this.gitMockingConfigurator;
        if (gitMockingConfigurator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
            gitMockingConfigurator = null;
        }
        gitMockingConfigurator.clearPullRequests();
    }

    @Test
    public void All tests() {
        this.notAPR().withProperty(this.none()).withBuild(this.recent()).returns(this.kept());
        this.notAPR().withProperty(this.none()).withBuild(this.medium()).returns(this.kept());
        this.notAPR().withProperty(this.none()).withBuild(this.old()).returns(this.kept());
        this.notAPR().withProperty(this.propertyWithoutPromotion()).withBuild(this.recent()).returns(this.kept());
        this.notAPR().withProperty(this.propertyWithoutPromotion()).withBuild(this.medium()).returns(this.disabled());
        this.notAPR().withProperty(this.propertyWithoutPromotion()).withBuild(this.old()).returns(this.deleted());
        this.notAPR().withProperty(this.propertyWithPromotionAndNotPromoted()).withBuild(this.recent()).returns(this.kept());
        this.notAPR().withProperty(this.propertyWithPromotionAndNotPromoted()).withBuild(this.medium()).returns(this.disabled());
        this.notAPR().withProperty(this.propertyWithPromotionAndNotPromoted()).withBuild(this.old()).returns(this.deleted());
        this.notAPR().withProperty(this.propertyWithPromotionAndPromoted()).withBuild(this.recent()).returns(this.kept());
        this.notAPR().withProperty(this.propertyWithPromotionAndPromoted()).withBuild(this.medium()).returns(this.kept());
        this.notAPR().withProperty(this.propertyWithPromotionAndPromoted()).withBuild(this.old()).returns(this.kept());
        this.notAPR().withProperty(this.propertyWithMatchingIncludesAndNoExcludes()).withBuild(this.recent()).returns(this.kept());
        this.notAPR().withProperty(this.propertyWithMatchingIncludesAndNoExcludes()).withBuild(this.medium()).returns(this.kept());
        this.notAPR().withProperty(this.propertyWithMatchingIncludesAndNoExcludes()).withBuild(this.old()).returns(this.kept());
        this.notAPR().withProperty(this.propertyWithMatchingIncludesAndNotMatchingExcludes()).withBuild(this.recent()).returns(this.kept());
        this.notAPR().withProperty(this.propertyWithMatchingIncludesAndNotMatchingExcludes()).withBuild(this.medium()).returns(this.kept());
        this.notAPR().withProperty(this.propertyWithMatchingIncludesAndNotMatchingExcludes()).withBuild(this.old()).returns(this.kept());
        this.notAPR().withProperty(this.propertyWithMatchingIncludesAndMatchingExcludes()).withBuild(this.recent()).returns(this.kept());
        this.notAPR().withProperty(this.propertyWithMatchingIncludesAndMatchingExcludes()).withBuild(this.medium()).returns(this.disabled());
        this.notAPR().withProperty(this.propertyWithMatchingIncludesAndMatchingExcludes()).withBuild(this.old()).returns(this.deleted());
        this.validPR().withProperty(this.none()).withBuild(this.recent()).returns(this.kept());
        this.validPR().withProperty(this.none()).withBuild(this.medium()).returns(this.kept());
        this.validPR().withProperty(this.none()).withBuild(this.old()).returns(this.kept());
        this.validPR().withProperty(this.propertyWithoutPromotion()).withBuild(this.recent()).returns(this.kept());
        this.validPR().withProperty(this.propertyWithoutPromotion()).withBuild(this.medium()).returns(this.disabled());
        this.validPR().withProperty(this.propertyWithoutPromotion()).withBuild(this.old()).returns(this.deleted());
        this.validPR().withProperty(this.propertyWithPromotionAndNotPromoted()).withBuild(this.recent()).returns(this.kept());
        this.validPR().withProperty(this.propertyWithPromotionAndNotPromoted()).withBuild(this.medium()).returns(this.disabled());
        this.validPR().withProperty(this.propertyWithPromotionAndNotPromoted()).withBuild(this.old()).returns(this.deleted());
        this.validPR().withProperty(this.propertyWithPromotionAndPromoted()).withBuild(this.recent()).returns(this.kept());
        this.validPR().withProperty(this.propertyWithPromotionAndPromoted()).withBuild(this.medium()).returns(this.kept());
        this.validPR().withProperty(this.propertyWithPromotionAndPromoted()).withBuild(this.old()).returns(this.kept());
        this.missingPR().withProperty(this.none()).withBuild(this.recent()).returns(this.kept());
        this.missingPR().withProperty(this.none()).withBuild(this.medium()).returns(this.disabled());
        this.missingPR().withProperty(this.none()).withBuild(this.old()).returns(this.deleted());
        this.missingPR().withProperty(this.propertyWithoutPromotion()).withBuild(this.recent()).returns(this.kept());
        this.missingPR().withProperty(this.propertyWithoutPromotion()).withBuild(this.medium()).returns(this.disabled());
        this.missingPR().withProperty(this.propertyWithoutPromotion()).withBuild(this.old()).returns(this.deleted());
        this.missingPR().withProperty(this.propertyWithPromotionAndNotPromoted()).withBuild(this.recent()).returns(this.kept());
        this.missingPR().withProperty(this.propertyWithPromotionAndNotPromoted()).withBuild(this.medium()).returns(this.disabled());
        this.missingPR().withProperty(this.propertyWithPromotionAndNotPromoted()).withBuild(this.old()).returns(this.deleted());
        this.missingPR().withProperty(this.propertyWithPromotionAndPromoted()).withBuild(this.recent()).returns(this.kept());
        this.missingPR().withProperty(this.propertyWithPromotionAndPromoted()).withBuild(this.medium()).returns(this.kept());
        this.missingPR().withProperty(this.propertyWithPromotionAndPromoted()).withBuild(this.old()).returns(this.kept());
        this.invalidPR().withProperty(this.none()).withBuild(this.recent()).returns(this.kept());
        this.invalidPR().withProperty(this.none()).withBuild(this.medium()).returns(this.disabled());
        this.invalidPR().withProperty(this.none()).withBuild(this.old()).returns(this.deleted());
        this.invalidPR().withProperty(this.propertyWithoutPromotion()).withBuild(this.recent()).returns(this.kept());
        this.invalidPR().withProperty(this.propertyWithoutPromotion()).withBuild(this.medium()).returns(this.disabled());
        this.invalidPR().withProperty(this.propertyWithoutPromotion()).withBuild(this.old()).returns(this.deleted());
        this.invalidPR().withProperty(this.propertyWithPromotionAndNotPromoted()).withBuild(this.recent()).returns(this.kept());
        this.invalidPR().withProperty(this.propertyWithPromotionAndNotPromoted()).withBuild(this.medium()).returns(this.disabled());
        this.invalidPR().withProperty(this.propertyWithPromotionAndNotPromoted()).withBuild(this.old()).returns(this.deleted());
        this.invalidPR().withProperty(this.propertyWithPromotionAndPromoted()).withBuild(this.recent()).returns(this.kept());
        this.invalidPR().withProperty(this.propertyWithPromotionAndPromoted()).withBuild(this.medium()).returns(this.kept());
        this.invalidPR().withProperty(this.propertyWithPromotionAndPromoted()).withBuild(this.old()).returns(this.kept());
    }

    private ExpectedResult kept() {
        return new ExpectedResult("kept", (Function2<? super String, ? super Branch, Unit>)((Function2)kept.1.INSTANCE));
    }

    private ExpectedResult disabled() {
        return new ExpectedResult("disabled", (Function2<? super String, ? super Branch, Unit>)((Function2)disabled.1.INSTANCE));
    }

    private ExpectedResult deleted() {
        return new ExpectedResult("deleted", (Function2<? super String, ? super Branch, Unit>)((Function2)deleted.1.INSTANCE));
    }

    private BuildConfiguration recent() {
        return new BuildConfiguration(0L);
    }

    private BuildConfiguration medium() {
        return new BuildConfiguration(6L);
    }

    private BuildConfiguration old() {
        return new BuildConfiguration(15L);
    }

    private PropertyConfiguration none() {
        return new PropertyConfiguration("no stale property", (Function1<? super Project, Unit>)((Function1)none.1.INSTANCE), (Function1<? super Branch, Unit>)((Function1)none.2.INSTANCE), (Function1<? super Build, Unit>)((Function1)none.3.INSTANCE));
    }

    private PropertyConfiguration propertyWithoutPromotion() {
        return new PropertyConfiguration("stale property", (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PullRequestStaleBranchCompleteCheckIT.access$setProperty(this.this$0, (ProjectEntity)it, StalePropertyType.class, new StaleProperty(5, Integer.valueOf(10), null, null, null));
            }
        }), (Function1<? super Branch, Unit>)((Function1)propertyWithoutPromotion.2.INSTANCE), (Function1<? super Build, Unit>)((Function1)propertyWithoutPromotion.3.INSTANCE));
    }

    private PropertyConfiguration propertyWithPromotionAndNotPromoted() {
        return new PropertyConfiguration("stale property with promotion protection and no build being promoted", (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PullRequestStaleBranchCompleteCheckIT.access$setProperty(this.this$0, (ProjectEntity)it, StalePropertyType.class, new StaleProperty(5, Integer.valueOf(10), CollectionsKt.listOf((Object)PullRequestStaleBranchCompleteCheckIT.access$getPromotionName$p(this.this$0)), null, null));
            }
        }), (Function1<? super Branch, Unit>)((Function1)new Function1<Branch, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Branch it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AbstractDSLTestJUnit4Support.promotionLevel$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Branch)it, (String)PullRequestStaleBranchCompleteCheckIT.access$getPromotionName$p(this.this$0), null, null, (int)6, null);
            }
        }), (Function1<? super Build, Unit>)((Function1)propertyWithPromotionAndNotPromoted.3.INSTANCE));
    }

    private PropertyConfiguration propertyWithPromotionAndPromoted() {
        return new PropertyConfiguration("stale property with promotion protection and no build being promoted", (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PullRequestStaleBranchCompleteCheckIT.access$setProperty(this.this$0, (ProjectEntity)it, StalePropertyType.class, new StaleProperty(5, Integer.valueOf(10), CollectionsKt.listOf((Object)PullRequestStaleBranchCompleteCheckIT.access$getPromotionName$p(this.this$0)), null, null));
            }
        }), (Function1<? super Branch, Unit>)((Function1)new Function1<Branch, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Branch it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AbstractDSLTestJUnit4Support.promotionLevel$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Branch)it, (String)PullRequestStaleBranchCompleteCheckIT.access$getPromotionName$p(this.this$0), null, null, (int)6, null);
            }
        }), (Function1<? super Build, Unit>)((Function1)new Function1<Build, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Build it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PromotionLevel promotionLevel = (PromotionLevel)_KTUtilsKt.getOrNull((Optional)PullRequestStaleBranchCompleteCheckIT.access$getStructureService(this.this$0).findPromotionLevelByName(it.getProject().getName(), it.getBranch().getName(), PullRequestStaleBranchCompleteCheckIT.access$getPromotionName$p(this.this$0)));
                if (promotionLevel == null) {
                    throw new IllegalStateException("Cannot find promotion level".toString());
                }
                PromotionLevel promotion = promotionLevel;
                AbstractDSLTestJUnit4Support.promote$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Build)it, (PromotionLevel)promotion, null, null, (int)6, null);
            }
        }));
    }

    private PropertyConfiguration propertyWithMatchingIncludesAndNoExcludes() {
        return new PropertyConfiguration("stale property with include protection matching", (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PullRequestStaleBranchCompleteCheckIT.access$setProperty(this.this$0, (ProjectEntity)it, StalePropertyType.class, new StaleProperty(5, Integer.valueOf(10), CollectionsKt.listOf((Object)PullRequestStaleBranchCompleteCheckIT.access$getPromotionName$p(this.this$0)), "release-.*", null));
            }
        }), (Function1<? super Branch, Unit>)((Function1)new Function1<Branch, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Branch it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ID iD = it.getId();
                String string = it.getDescription();
                boolean bl = it.isDisabled();
                Signature signature = it.getSignature();
                Project project2 = it.getProject();
                PullRequestStaleBranchCompleteCheckIT.access$getStructureService(this.this$0).saveBranch(new Branch(iD, "release-2.0", string, bl, project2, signature));
                AbstractDSLTestJUnit4Support.promotionLevel$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Branch)it, (String)PullRequestStaleBranchCompleteCheckIT.access$getPromotionName$p(this.this$0), null, null, (int)6, null);
            }
        }), (Function1<? super Build, Unit>)((Function1)propertyWithMatchingIncludesAndNoExcludes.3.INSTANCE));
    }

    private PropertyConfiguration propertyWithMatchingIncludesAndNotMatchingExcludes() {
        return new PropertyConfiguration("stale property with include protection matching and no exclude protection matching", (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PullRequestStaleBranchCompleteCheckIT.access$setProperty(this.this$0, (ProjectEntity)it, StalePropertyType.class, new StaleProperty(5, Integer.valueOf(10), CollectionsKt.listOf((Object)PullRequestStaleBranchCompleteCheckIT.access$getPromotionName$p(this.this$0)), "release-.*", "release-1.*"));
            }
        }), (Function1<? super Branch, Unit>)((Function1)new Function1<Branch, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Branch it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ID iD = it.getId();
                String string = it.getDescription();
                boolean bl = it.isDisabled();
                Signature signature = it.getSignature();
                Project project2 = it.getProject();
                PullRequestStaleBranchCompleteCheckIT.access$getStructureService(this.this$0).saveBranch(new Branch(iD, "release-2.0", string, bl, project2, signature));
                AbstractDSLTestJUnit4Support.promotionLevel$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Branch)it, (String)PullRequestStaleBranchCompleteCheckIT.access$getPromotionName$p(this.this$0), null, null, (int)6, null);
            }
        }), (Function1<? super Build, Unit>)((Function1)propertyWithMatchingIncludesAndNotMatchingExcludes.3.INSTANCE));
    }

    private PropertyConfiguration propertyWithMatchingIncludesAndMatchingExcludes() {
        return new PropertyConfiguration("stale property with include protection matching and exclude protection matching", (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PullRequestStaleBranchCompleteCheckIT.access$setProperty(this.this$0, (ProjectEntity)it, StalePropertyType.class, new StaleProperty(5, Integer.valueOf(10), CollectionsKt.listOf((Object)PullRequestStaleBranchCompleteCheckIT.access$getPromotionName$p(this.this$0)), "release-.*", "release-1.*"));
            }
        }), (Function1<? super Branch, Unit>)((Function1)new Function1<Branch, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Branch it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ID iD = it.getId();
                String string = it.getDescription();
                boolean bl = it.isDisabled();
                Signature signature = it.getSignature();
                Project project2 = it.getProject();
                PullRequestStaleBranchCompleteCheckIT.access$getStructureService(this.this$0).saveBranch(new Branch(iD, "release-1.0", string, bl, project2, signature));
                AbstractDSLTestJUnit4Support.promotionLevel$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Branch)it, (String)PullRequestStaleBranchCompleteCheckIT.access$getPromotionName$p(this.this$0), null, null, (int)6, null);
            }
        }), (Function1<? super Build, Unit>)((Function1)propertyWithMatchingIncludesAndMatchingExcludes.3.INSTANCE));
    }

    private BranchPRConfiguration notAPR() {
        return new BranchPRConfiguration("Branch which is not a PR", (Function1<? super Branch, Unit>)((Function1)new Function1<Branch, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Branch it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GitMockingConfigurator gitMockingConfigurator = PullRequestStaleBranchCompleteCheckIT.access$getGitMockingConfigurator$p(this.this$0);
                if (gitMockingConfigurator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                    gitMockingConfigurator = null;
                }
                gitMockingConfigurator.clearPullRequests();
                this.this$0.gitBranch(it, "main", (Function0)new Function0<ConfiguredBuildGitCommitLink<?>>(this.this$0){
                    final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final ConfiguredBuildGitCommitLink<?> invoke() {
                        return this.this$0.commitAsProperty();
                    }
                });
            }
        }));
    }

    private BranchPRConfiguration validPR() {
        return new BranchPRConfiguration("Branch which is a valid PR", (Function1<? super Branch, Unit>)((Function1)new Function1<Branch, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Branch it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GitMockingConfigurator gitMockingConfigurator = PullRequestStaleBranchCompleteCheckIT.access$getGitMockingConfigurator$p(this.this$0);
                if (gitMockingConfigurator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                    gitMockingConfigurator = null;
                }
                gitMockingConfigurator.clearPullRequests();
                GitMockingConfigurator gitMockingConfigurator2 = PullRequestStaleBranchCompleteCheckIT.access$getGitMockingConfigurator$p(this.this$0);
                if (gitMockingConfigurator2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                    gitMockingConfigurator2 = null;
                }
                GitMockingConfigurator.registerPullRequest$default(gitMockingConfigurator2, 1, null, null, null, null, false, 62, null);
                this.this$0.gitBranch(it, "PR-1", (Function0)new Function0<ConfiguredBuildGitCommitLink<?>>(this.this$0){
                    final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final ConfiguredBuildGitCommitLink<?> invoke() {
                        return this.this$0.commitAsProperty();
                    }
                });
            }
        }));
    }

    private BranchPRConfiguration missingPR() {
        return new BranchPRConfiguration("Branch which is a missing PR", (Function1<? super Branch, Unit>)((Function1)new Function1<Branch, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Branch it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GitMockingConfigurator gitMockingConfigurator = PullRequestStaleBranchCompleteCheckIT.access$getGitMockingConfigurator$p(this.this$0);
                if (gitMockingConfigurator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                    gitMockingConfigurator = null;
                }
                gitMockingConfigurator.clearPullRequests();
                this.this$0.gitBranch(it, "PR-1", (Function0)new Function0<ConfiguredBuildGitCommitLink<?>>(this.this$0){
                    final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final ConfiguredBuildGitCommitLink<?> invoke() {
                        return this.this$0.commitAsProperty();
                    }
                });
            }
        }));
    }

    private BranchPRConfiguration invalidPR() {
        return new BranchPRConfiguration("Branch which is an invalid PR", (Function1<? super Branch, Unit>)((Function1)new Function1<Branch, Unit>(this){
            final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Branch it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GitMockingConfigurator gitMockingConfigurator = PullRequestStaleBranchCompleteCheckIT.access$getGitMockingConfigurator$p(this.this$0);
                if (gitMockingConfigurator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                    gitMockingConfigurator = null;
                }
                gitMockingConfigurator.clearPullRequests();
                GitMockingConfigurator gitMockingConfigurator2 = PullRequestStaleBranchCompleteCheckIT.access$getGitMockingConfigurator$p(this.this$0);
                if (gitMockingConfigurator2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gitMockingConfigurator");
                    gitMockingConfigurator2 = null;
                }
                GitMockingConfigurator.registerPullRequest$default(gitMockingConfigurator2, 1, null, null, null, null, true, 30, null);
                this.this$0.gitBranch(it, "PR-1", (Function0)new Function0<ConfiguredBuildGitCommitLink<?>>(this.this$0){
                    final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final ConfiguredBuildGitCommitLink<?> invoke() {
                        return this.this$0.commitAsProperty();
                    }
                });
            }
        }));
    }

    public static final /* synthetic */ StaleJobService access$getStaleJobService$p(PullRequestStaleBranchCompleteCheckIT $this) {
        return $this.staleJobService;
    }

    public static final /* synthetic */ StructureService access$getStructureService(PullRequestStaleBranchCompleteCheckIT $this) {
        return $this.getStructureService();
    }

    public static final /* synthetic */ void access$setProperty(PullRequestStaleBranchCompleteCheckIT $this, ProjectEntity projectEntity, Class propertyTypeClass, Object data2) {
        $this.setProperty(projectEntity, propertyTypeClass, data2);
    }

    public static final /* synthetic */ String access$getPromotionName$p(PullRequestStaleBranchCompleteCheckIT $this) {
        return $this.promotionName;
    }

    public static final /* synthetic */ GitMockingConfigurator access$getGitMockingConfigurator$p(PullRequestStaleBranchCompleteCheckIT $this) {
        return $this.gitMockingConfigurator;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B8\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012)\u0010\u0004\u001a%\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0002\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\bR4\u0010\u0004\u001a%\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0002\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$ExpectedResult;", "", "description", "", "checkFn", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "Lnet/nemerosa/ontrack/model/structure/Branch;", "", "(Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getCheckFn", "()Lkotlin/jvm/functions/Function2;", "getDescription", "()Ljava/lang/String;", "check", "branch", "ontrack-extension-git"})
    private final class ExpectedResult {
        @NotNull
        private final String description;
        @NotNull
        private final Function2<String, Branch, Unit> checkFn;

        public ExpectedResult(@NotNull String description, Function2<? super String, ? super Branch, Unit> checkFn) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(checkFn, (String)"checkFn");
            this.description = description;
            this.checkFn = checkFn;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final Function2<String, Branch, Unit> getCheckFn() {
            return this.checkFn;
        }

        public final void check(@NotNull String description, @Nullable Branch branch2) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            this.checkFn.invoke((Object)description, (Object)branch2);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bR\u00020\u0004H\u0086\u0004R\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$BranchAndBuildConfiguration;", "", "branchConfiguration", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$BranchConfiguration;", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT;", "buildConfiguration", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$BuildConfiguration;", "(Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT;Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$BranchConfiguration;Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$BuildConfiguration;)V", "returns", "", "expectedResult", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$ExpectedResult;", "ontrack-extension-git"})
    private final class BranchAndBuildConfiguration {
        @NotNull
        private final BranchConfiguration branchConfiguration;
        @NotNull
        private final BuildConfiguration buildConfiguration;

        public BranchAndBuildConfiguration(@NotNull BranchConfiguration branchConfiguration, BuildConfiguration buildConfiguration) {
            Intrinsics.checkNotNullParameter((Object)branchConfiguration, (String)"branchConfiguration");
            Intrinsics.checkNotNullParameter((Object)buildConfiguration, (String)"buildConfiguration");
            this.branchConfiguration = branchConfiguration;
            this.buildConfiguration = buildConfiguration;
        }

        public final void returns(@NotNull ExpectedResult expectedResult) {
            Intrinsics.checkNotNullParameter((Object)expectedResult, (String)"expectedResult");
            String description = this.branchConfiguration.getDescription() + " with " + this.buildConfiguration.getDescription() + " expects to be " + expectedResult.getDescription();
            PullRequestStaleBranchCompleteCheckIT.this.logger.info((Object)("TEST " + description));
            PullRequestStaleBranchCompleteCheckIT.this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(PullRequestStaleBranchCompleteCheckIT.this){
                final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                    Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                    return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 1, false, false, 6, null);
                }
            }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(PullRequestStaleBranchCompleteCheckIT.this, this, expectedResult, description){
                final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
                final /* synthetic */ BranchAndBuildConfiguration this$1;
                final /* synthetic */ ExpectedResult $expectedResult;
                final /* synthetic */ String $description;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$expectedResult = $expectedResult;
                    this.$description = $description;
                    super(2);
                }

                public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> map) {
                    Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                    Intrinsics.checkNotNullParameter(map, (String)"<anonymous parameter 1>");
                    AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo, this.this$1, this.$expectedResult, this.$description){
                        final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$0;
                        final /* synthetic */ GitRepo $repo;
                        final /* synthetic */ BranchAndBuildConfiguration this$1;
                        final /* synthetic */ ExpectedResult $expectedResult;
                        final /* synthetic */ String $description;
                        {
                            this.this$0 = $receiver;
                            this.$repo = $repo;
                            this.this$1 = $receiver2;
                            this.$expectedResult = $expectedResult;
                            this.$description = $description;
                            super(1);
                        }

                        public final void invoke(@NotNull Project $this$project) {
                            Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                            AbstractGitTestSupport.prGitProject$default(this.this$0, $this$project, this.$repo, false, 2, null);
                            BranchAndBuildConfiguration.access$getBranchConfiguration$p(this.this$1).configureProject($this$project);
                            AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$1, this.this$0, this.$expectedResult, this.$description){
                                final /* synthetic */ BranchAndBuildConfiguration this$0;
                                final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$1;
                                final /* synthetic */ ExpectedResult $expectedResult;
                                final /* synthetic */ String $description;
                                {
                                    this.this$0 = $receiver;
                                    this.this$1 = $receiver2;
                                    this.$expectedResult = $expectedResult;
                                    this.$description = $description;
                                    super(1);
                                }

                                public final void invoke(@NotNull Branch $this$branch) {
                                    Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                    BranchAndBuildConfiguration.access$getBranchConfiguration$p(this.this$0).configureBranch($this$branch);
                                    AbstractDSLTestJUnit4Support.build$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$1), (Branch)$this$branch, null, (Function1)((Function1)new Function1<Build, Unit>(this.this$0, this.this$1, this.$expectedResult, this.$description){
                                        final /* synthetic */ BranchAndBuildConfiguration this$0;
                                        final /* synthetic */ PullRequestStaleBranchCompleteCheckIT this$1;
                                        final /* synthetic */ ExpectedResult $expectedResult;
                                        final /* synthetic */ String $description;
                                        {
                                            this.this$0 = $receiver;
                                            this.this$1 = $receiver2;
                                            this.$expectedResult = $expectedResult;
                                            this.$description = $description;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull Build $this$build) {
                                            Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                                            BranchAndBuildConfiguration.access$getBranchConfiguration$p(this.this$0).configureBuild($this$build);
                                            BranchAndBuildConfiguration.access$getBuildConfiguration$p(this.this$0).configure($this$build);
                                            StaleJobService staleJobService = PullRequestStaleBranchCompleteCheckIT.access$getStaleJobService$p(this.this$1);
                                            if (staleJobService == null) {
                                                Intrinsics.throwUninitializedPropertyAccessException((String)"staleJobService");
                                                staleJobService = null;
                                            }
                                            JobRunListener jobRunListener = JobRunListener.out();
                                            Intrinsics.checkNotNullExpressionValue((Object)jobRunListener, (String)"out()");
                                            staleJobService.detectAndManageStaleBranches(jobRunListener, $this$build.getProject());
                                            Branch actualBranch = PullRequestStaleBranchCompleteCheckIT.access$getStructureService(this.this$1).findBranchByID($this$build.getBranch().getId());
                                            this.$expectedResult.check(this.$description, actualBranch);
                                        }
                                    }), (int)1, null);
                                }
                            }), (int)1, null);
                        }
                    }), (int)1, null);
                }
            });
        }

        public static final /* synthetic */ BranchConfiguration access$getBranchConfiguration$p(BranchAndBuildConfiguration $this) {
            return $this.branchConfiguration;
        }

        public static final /* synthetic */ BuildConfiguration access$getBuildConfiguration$p(BranchAndBuildConfiguration $this) {
            return $this.buildConfiguration;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$BuildConfiguration;", "", "age", "", "(Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT;J)V", "description", "", "getDescription", "()Ljava/lang/String;", "configure", "", "build", "Lnet/nemerosa/ontrack/model/structure/Build;", "ontrack-extension-git"})
    private final class BuildConfiguration {
        private final long age;
        @NotNull
        private final String description;

        public BuildConfiguration(long age) {
            this.age = age;
            this.description = "build " + this.age + " days old";
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public final void configure(@NotNull Build build2) {
            Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
            if (this.age > 0L) {
                AbstractDSLTestJUnit4Support.updateBuildSignature$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)PullRequestStaleBranchCompleteCheckIT.this), (Build)build2, null, (LocalDateTime)Time.now().minusDays(this.age), (int)1, null);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015J\u0019\u0010\u0016\u001a\u00060\u0017R\u00020\u00042\n\u0010\u0018\u001a\u00060\u0019R\u00020\u0004H\u0086\u0004R\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$BranchConfiguration;", "", "branchPRConfiguration", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$BranchPRConfiguration;", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT;", "propertyConfiguration", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$PropertyConfiguration;", "(Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT;Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$BranchPRConfiguration;Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$PropertyConfiguration;)V", "description", "", "getDescription", "()Ljava/lang/String;", "configureBranch", "", "branch", "Lnet/nemerosa/ontrack/model/structure/Branch;", "configureBuild", "build", "Lnet/nemerosa/ontrack/model/structure/Build;", "configureProject", "project", "Lnet/nemerosa/ontrack/model/structure/Project;", "withBuild", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$BranchAndBuildConfiguration;", "buildConfiguration", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$BuildConfiguration;", "ontrack-extension-git"})
    private final class BranchConfiguration {
        @NotNull
        private final BranchPRConfiguration branchPRConfiguration;
        @NotNull
        private final PropertyConfiguration propertyConfiguration;
        @NotNull
        private final String description;

        public BranchConfiguration(@NotNull BranchPRConfiguration branchPRConfiguration, PropertyConfiguration propertyConfiguration) {
            Intrinsics.checkNotNullParameter((Object)branchPRConfiguration, (String)"branchPRConfiguration");
            Intrinsics.checkNotNullParameter((Object)propertyConfiguration, (String)"propertyConfiguration");
            this.branchPRConfiguration = branchPRConfiguration;
            this.propertyConfiguration = propertyConfiguration;
            this.description = this.branchPRConfiguration.getDescription() + " with " + this.propertyConfiguration.getDescription();
        }

        @NotNull
        public final BranchAndBuildConfiguration withBuild(@NotNull BuildConfiguration buildConfiguration) {
            Intrinsics.checkNotNullParameter((Object)buildConfiguration, (String)"buildConfiguration");
            return new BranchAndBuildConfiguration(this, buildConfiguration);
        }

        public final void configureBranch(@NotNull Branch branch2) {
            Intrinsics.checkNotNullParameter((Object)branch2, (String)"branch");
            this.branchPRConfiguration.configure(branch2);
            this.propertyConfiguration.configureBranch(branch2);
        }

        public final void configureProject(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.propertyConfiguration.configureProject(project2);
        }

        public final void configureBuild(@NotNull Build build2) {
            Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
            this.propertyConfiguration.configureBuild(build2);
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0082\u0004\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0006R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$PropertyConfiguration;", "", "description", "", "projectConfiguration", "Lkotlin/Function1;", "Lnet/nemerosa/ontrack/model/structure/Project;", "", "branchConfiguration", "Lnet/nemerosa/ontrack/model/structure/Branch;", "buildConfiguration", "Lnet/nemerosa/ontrack/model/structure/Build;", "(Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getDescription", "()Ljava/lang/String;", "configureBranch", "branch", "configureBuild", "build", "configureProject", "project", "ontrack-extension-git"})
    private final class PropertyConfiguration {
        @NotNull
        private final String description;
        @NotNull
        private final Function1<Project, Unit> projectConfiguration;
        @NotNull
        private final Function1<Branch, Unit> branchConfiguration;
        @NotNull
        private final Function1<Build, Unit> buildConfiguration;

        public PropertyConfiguration(@NotNull String description, @NotNull Function1<? super Project, Unit> projectConfiguration, @NotNull Function1<? super Branch, Unit> branchConfiguration, Function1<? super Build, Unit> buildConfiguration) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(projectConfiguration, (String)"projectConfiguration");
            Intrinsics.checkNotNullParameter(branchConfiguration, (String)"branchConfiguration");
            Intrinsics.checkNotNullParameter(buildConfiguration, (String)"buildConfiguration");
            this.description = description;
            this.projectConfiguration = projectConfiguration;
            this.branchConfiguration = branchConfiguration;
            this.buildConfiguration = buildConfiguration;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public final void configureProject(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.projectConfiguration.invoke((Object)project2);
        }

        public final void configureBranch(@NotNull Branch branch2) {
            Intrinsics.checkNotNullParameter((Object)branch2, (String)"branch");
            this.branchConfiguration.invoke((Object)branch2);
        }

        public final void configureBuild(@NotNull Build build2) {
            Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
            this.buildConfiguration.invoke((Object)build2);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0006J\u0019\u0010\r\u001a\u00060\u000eR\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011R\u00020\u000fH\u0086\u0004R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$BranchPRConfiguration;", "", "description", "", "configuration", "Lkotlin/Function1;", "Lnet/nemerosa/ontrack/model/structure/Branch;", "", "(Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getDescription", "()Ljava/lang/String;", "configure", "branch", "withProperty", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$BranchConfiguration;", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT;", "propertyConfiguration", "Lnet/nemerosa/ontrack/extension/git/PullRequestStaleBranchCompleteCheckIT$PropertyConfiguration;", "ontrack-extension-git"})
    private final class BranchPRConfiguration {
        @NotNull
        private final String description;
        @NotNull
        private final Function1<Branch, Unit> configuration;

        public BranchPRConfiguration(@NotNull String description, Function1<? super Branch, Unit> configuration) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
            this.description = description;
            this.configuration = configuration;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final BranchConfiguration withProperty(@NotNull PropertyConfiguration propertyConfiguration) {
            Intrinsics.checkNotNullParameter((Object)propertyConfiguration, (String)"propertyConfiguration");
            return new BranchConfiguration(this, propertyConfiguration);
        }

        public final void configure(@NotNull Branch branch2) {
            Intrinsics.checkNotNullParameter((Object)branch2, (String)"branch");
            this.configuration.invoke((Object)branch2);
        }
    }
}

