/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.git.mocking;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.extension.git.mocking.GitMockingConfiguration;
import net.nemerosa.ontrack.extension.git.mocking.GitMockingConfigurationProperty;
import net.nemerosa.ontrack.extension.git.mocking.GitMockingConfigurationPropertyType;
import net.nemerosa.ontrack.extension.git.model.GitConfiguration;
import net.nemerosa.ontrack.extension.git.model.GitConfigurator;
import net.nemerosa.ontrack.extension.git.model.GitPullRequest;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PropertyService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016JB\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00072\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u00162\b\b\u0002\u0010\u001a\u001a\u00020\u0013H\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/nemerosa/ontrack/extension/git/mocking/GitMockingConfigurator;", "Lnet/nemerosa/ontrack/extension/git/model/GitConfigurator;", "propertyService", "Lnet/nemerosa/ontrack/model/structure/PropertyService;", "(Lnet/nemerosa/ontrack/model/structure/PropertyService;)V", "pullRequests", "", "", "Lnet/nemerosa/ontrack/extension/git/model/GitPullRequest;", "clearPullRequests", "", "getConfiguration", "Lnet/nemerosa/ontrack/extension/git/model/GitConfiguration;", "project", "Lnet/nemerosa/ontrack/model/structure/Project;", "getPullRequest", "configuration", "id", "isProjectConfigured", "", "registerPullRequest", "source", "", "target", "title", "status", "invalid", "unregisterPullRequest", "ontrack-extension-git"})
public class GitMockingConfigurator
implements GitConfigurator {
    @NotNull
    private final PropertyService propertyService;
    @NotNull
    private final Map<Integer, GitPullRequest> pullRequests;

    public GitMockingConfigurator(@NotNull PropertyService propertyService) {
        Intrinsics.checkNotNullParameter((Object)propertyService, (String)"propertyService");
        this.propertyService = propertyService;
        this.pullRequests = new LinkedHashMap();
    }

    public boolean isProjectConfigured(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return this.propertyService.hasProperty((ProjectEntity)project2, GitMockingConfigurationPropertyType.class);
    }

    @Nullable
    public GitConfiguration getConfiguration(@NotNull Project project2) {
        GitMockingConfiguration gitMockingConfiguration;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        GitMockingConfigurationProperty gitMockingConfigurationProperty = (GitMockingConfigurationProperty)this.propertyService.getProperty((ProjectEntity)project2, GitMockingConfigurationPropertyType.class).getValue();
        if (gitMockingConfigurationProperty != null) {
            GitMockingConfigurationProperty it = gitMockingConfigurationProperty;
            boolean bl = false;
            gitMockingConfiguration = new GitMockingConfiguration();
        } else {
            gitMockingConfiguration = null;
        }
        return gitMockingConfiguration;
    }

    @Nullable
    public GitPullRequest getPullRequest(@NotNull GitConfiguration configuration, int id) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return configuration instanceof GitMockingConfiguration ? this.pullRequests.get(id) : (GitPullRequest)null;
    }

    public void clearPullRequests() {
        this.pullRequests.clear();
    }

    public void registerPullRequest(int id, @NotNull String source2, @NotNull String target2, @NotNull String title, @NotNull String status, boolean invalid) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        GitPullRequest pr = invalid ? GitPullRequest.Companion.invalidPR(id, "#" + id) : new GitPullRequest(id, "#" + id, source2, target2, title, status, "uri:testing:web:git:pr:" + id);
        Integer n = id;
        this.pullRequests.put(n, pr);
    }

    public static /* synthetic */ void registerPullRequest$default(GitMockingConfigurator gitMockingConfigurator, int n, String object, String string, String object2, String string2, boolean bl, int n2, Object object3) {
        if (object3 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerPullRequest");
        }
        if ((n2 & 2) != 0) {
            object = "feature/TK-" + n + "-feature";
        }
        if ((n2 & 4) != 0) {
            string = "release/1.0";
        }
        if ((n2 & 8) != 0) {
            object2 = "PR n\u00b0" + n;
        }
        if ((n2 & 0x10) != 0) {
            string2 = "open";
        }
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        gitMockingConfigurator.registerPullRequest(n, (String)object, string, (String)object2, string2, bl);
    }

    public void unregisterPullRequest(int id) {
        this.pullRequests.remove(id);
    }

    @Nullable
    public Integer toPullRequestID(@NotNull String key) {
        return GitConfigurator.DefaultImpls.toPullRequestID((GitConfigurator)this, (String)key);
    }

    @NotNull
    public String toPullRequestKey(int prId) {
        return GitConfigurator.DefaultImpls.toPullRequestKey((GitConfigurator)this, (int)prId);
    }
}

