/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.git.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.nemerosa.ontrack.extension.git.model.BasicGitActualConfiguration;
import net.nemerosa.ontrack.extension.git.model.BasicGitConfiguration;
import net.nemerosa.ontrack.extension.git.model.GitBuildInfo;
import net.nemerosa.ontrack.extension.git.model.GitChangeLog;
import net.nemerosa.ontrack.extension.git.resource.GitChangeLogResourceDecorator;
import net.nemerosa.ontrack.extension.git.service.GitService;
import net.nemerosa.ontrack.extension.issues.support.MockIssueServiceConfiguration;
import net.nemerosa.ontrack.extension.scm.model.SCMBuildView;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.BuildView;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.ui.controller.MockURIBuilder;
import net.nemerosa.ontrack.ui.controller.URIBuilder;
import net.nemerosa.ontrack.ui.resource.DefaultResourceContext;
import net.nemerosa.ontrack.ui.resource.ResourceContext;
import net.nemerosa.ontrack.ui.resource.ResourceDecorator;
import net.nemerosa.ontrack.ui.resource.ResourceObjectMapper;
import net.nemerosa.ontrack.ui.resource.ResourceObjectMapperFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class GitChangeLogResourceDecoratorTest {
    private ResourceObjectMapper mapper;
    private GitService gitService;

    @Before
    public void before() {
        SecurityService securityService = (SecurityService)Mockito.mock(SecurityService.class);
        this.gitService = (GitService)Mockito.mock(GitService.class);
        this.mapper = new ResourceObjectMapperFactory().resourceObjectMapper((ResourceContext)new DefaultResourceContext((URIBuilder)new MockURIBuilder(), securityService), new ResourceDecorator[]{new GitChangeLogResourceDecorator(this.gitService)});
    }

    @Test
    public void gitChangeLogWithIssues() throws JsonProcessingException {
        Signature signature = Signature.of((LocalDateTime)LocalDateTime.of(2014, 12, 5, 21, 53), (String)"user");
        Project project2 = Project.of((NameDescription)NameDescription.nd((String)"P", (String)"Project")).withId(ID.of((int)1)).withSignature(signature);
        Branch branch2 = Branch.of((Project)project2, (NameDescription)NameDescription.nd((String)"B", (String)"Branch")).withId(ID.of((int)10)).withSignature(signature);
        List buildView = Stream.of(1, 2).map(it -> BuildView.of((Build)Build.of((Branch)branch2, (NameDescription)NameDescription.nd((String)String.valueOf(it), (String)("Build " + it)), (Signature)signature).withId(ID.of((int)it)))).collect(Collectors.toList());
        GitChangeLog changeLog2 = new GitChangeLog("uuid", project2, new SCMBuildView((BuildView)buildView.get(0), (Object)GitBuildInfo.INSTANCE), new SCMBuildView((BuildView)buildView.get(1), (Object)GitBuildInfo.INSTANCE), false);
        Mockito.when((Object)this.gitService.getProjectConfiguration(project2)).thenReturn((Object)new BasicGitActualConfiguration(BasicGitConfiguration.empty().withName("MyConfig").withIssueServiceConfigurationIdentifier("mock:MyTest"), MockIssueServiceConfiguration.configuredIssueService((String)"MyTest")));
        ObjectNode signatureObject = JsonUtils.object().with("time", "2014-12-05T21:53:00Z").with("user", (JsonNode)JsonUtils.object().with("name", "user").end()).end();
        GitChangeLogResourceDecoratorTest.assertResourceJson(this.mapper, (JsonNode)JsonUtils.object().with("project", (JsonNode)JsonUtils.object().with("id", 1).with("name", "P").with("description", "Project").with("disabled", false).with("signature", (JsonNode)signatureObject).end()).with("scmBuildFrom", (JsonNode)JsonUtils.object().with("buildView", (JsonNode)JsonUtils.object().with("build", (JsonNode)JsonUtils.object().with("id", 1).with("name", "1").with("description", "Build 1").with("signature", (JsonNode)signatureObject).with("branch", (JsonNode)JsonUtils.object().with("id", 10).with("name", "B").with("description", "Branch").with("disabled", false).with("signature", (JsonNode)signatureObject).end()).end()).with("decorations", (JsonNode)JsonUtils.array().end()).with("promotionRuns", (JsonNode)JsonUtils.array().end()).with("validationStampRunViews", (JsonNode)JsonUtils.array().end()).end()).with("scm", (JsonNode)JsonUtils.object().with("placeholder", "").end()).end()).with("scmBuildTo", (JsonNode)JsonUtils.object().with("buildView", (JsonNode)JsonUtils.object().with("build", (JsonNode)JsonUtils.object().with("id", 2).with("name", "2").with("description", "Build 2").with("signature", (JsonNode)signatureObject).with("branch", (JsonNode)JsonUtils.object().with("id", 10).with("name", "B").with("description", "Branch").with("disabled", false).with("signature", (JsonNode)signatureObject).end()).end()).with("decorations", (JsonNode)JsonUtils.array().end()).with("promotionRuns", (JsonNode)JsonUtils.array().end()).with("validationStampRunViews", (JsonNode)JsonUtils.array().end()).end()).with("scm", (JsonNode)JsonUtils.object().with("placeholder", "").end()).end()).with("syncError", false).with("uuid", "uuid").with("_commits", "urn:test:net.nemerosa.ontrack.extension.git.GitController#changeLogCommits:uuid").with("_issues", "urn:test:net.nemerosa.ontrack.extension.git.GitController#changeLogIssues:uuid").with("_issuesIds", "urn:test:net.nemerosa.ontrack.extension.git.GitController#changeLogIssuesIds:uuid").with("_files", "urn:test:net.nemerosa.ontrack.extension.git.GitController#changeLogFiles:uuid").with("_changeLogFileFilters", "urn:test:net.nemerosa.ontrack.extension.scm.SCMController#getChangeLogFileFilters:1").with("_diff", "urn:test:net.nemerosa.ontrack.extension.git.GitController#diff:").with("_exportFormats", "urn:test:net.nemerosa.ontrack.extension.git.GitController#changeLogExportFormats:1").with("_exportIssues", "urn:test:net.nemerosa.ontrack.extension.git.GitController#changeLog:IssueChangeLogExportRequest%28format%3D%27text%27%2C+grouping%3D%27%27%2C+exclude%3D%27%27%2C+altGroup%3D%27Other%27%29").with("_page", "urn:test:#:extension/git/changelog?from=1&to=2").end(), changeLog2);
    }

    @Test
    public void gitChangeLogWithoutIssues() throws JsonProcessingException {
        Signature signature = Signature.of((LocalDateTime)LocalDateTime.of(2014, 12, 5, 21, 53), (String)"user");
        Project project2 = Project.of((NameDescription)NameDescription.nd((String)"P", (String)"Project")).withId(ID.of((int)1)).withSignature(signature);
        Branch branch2 = Branch.of((Project)project2, (NameDescription)NameDescription.nd((String)"B", (String)"Branch")).withId(ID.of((int)10)).withSignature(signature);
        List buildView = Stream.of(1, 2).map(it -> BuildView.of((Build)Build.of((Branch)branch2, (NameDescription)NameDescription.nd((String)String.valueOf(it), (String)("Build " + it)), (Signature)signature).withId(ID.of((int)it)))).collect(Collectors.toList());
        GitChangeLog changeLog2 = new GitChangeLog("uuid", project2, new SCMBuildView((BuildView)buildView.get(0), (Object)GitBuildInfo.INSTANCE), new SCMBuildView((BuildView)buildView.get(1), (Object)GitBuildInfo.INSTANCE), false);
        Mockito.when((Object)this.gitService.getProjectConfiguration(project2)).thenReturn((Object)new BasicGitActualConfiguration(BasicGitConfiguration.empty().withName("MyConfig").withIssueServiceConfigurationIdentifier("mock:MyTest"), null));
        ObjectNode signatureObject = JsonUtils.object().with("time", "2014-12-05T21:53:00Z").with("user", (JsonNode)JsonUtils.object().with("name", "user").end()).end();
        GitChangeLogResourceDecoratorTest.assertResourceJson(this.mapper, (JsonNode)JsonUtils.object().with("project", (JsonNode)JsonUtils.object().with("id", 1).with("name", "P").with("description", "Project").with("disabled", false).with("signature", (JsonNode)signatureObject).end()).with("scmBuildFrom", (JsonNode)JsonUtils.object().with("buildView", (JsonNode)JsonUtils.object().with("build", (JsonNode)JsonUtils.object().with("id", 1).with("name", "1").with("description", "Build 1").with("signature", (JsonNode)signatureObject).with("branch", (JsonNode)JsonUtils.object().with("id", 10).with("name", "B").with("description", "Branch").with("disabled", false).with("signature", (JsonNode)signatureObject).end()).end()).with("decorations", (JsonNode)JsonUtils.array().end()).with("promotionRuns", (JsonNode)JsonUtils.array().end()).with("validationStampRunViews", (JsonNode)JsonUtils.array().end()).end()).with("scm", (JsonNode)JsonUtils.object().with("placeholder", "").end()).end()).with("scmBuildTo", (JsonNode)JsonUtils.object().with("buildView", (JsonNode)JsonUtils.object().with("build", (JsonNode)JsonUtils.object().with("id", 2).with("name", "2").with("description", "Build 2").with("signature", (JsonNode)signatureObject).with("branch", (JsonNode)JsonUtils.object().with("id", 10).with("name", "B").with("description", "Branch").with("disabled", false).with("signature", (JsonNode)signatureObject).end()).end()).with("decorations", (JsonNode)JsonUtils.array().end()).with("promotionRuns", (JsonNode)JsonUtils.array().end()).with("validationStampRunViews", (JsonNode)JsonUtils.array().end()).end()).with("scm", (JsonNode)JsonUtils.object().with("placeholder", "").end()).end()).with("syncError", false).with("uuid", "uuid").with("_commits", "urn:test:net.nemerosa.ontrack.extension.git.GitController#changeLogCommits:uuid").with("_issues", "urn:test:net.nemerosa.ontrack.extension.git.GitController#changeLogIssues:uuid").with("_issuesIds", "urn:test:net.nemerosa.ontrack.extension.git.GitController#changeLogIssuesIds:uuid").with("_files", "urn:test:net.nemerosa.ontrack.extension.git.GitController#changeLogFiles:uuid").with("_changeLogFileFilters", "urn:test:net.nemerosa.ontrack.extension.scm.SCMController#getChangeLogFileFilters:1").with("_diff", "urn:test:net.nemerosa.ontrack.extension.git.GitController#diff:").with("_exportFormats", "urn:test:net.nemerosa.ontrack.extension.git.GitController#changeLogExportFormats:1").with("_exportIssues", "urn:test:net.nemerosa.ontrack.extension.git.GitController#changeLog:IssueChangeLogExportRequest%28format%3D%27text%27%2C+grouping%3D%27%27%2C+exclude%3D%27%27%2C+altGroup%3D%27Other%27%29").with("_page", "urn:test:#:extension/git/changelog?from=1&to=2").end(), changeLog2);
    }

    private static void assertResourceJson(ResourceObjectMapper mapper, JsonNode expectedJson, Object o) throws JsonProcessingException {
        Assert.assertEquals((Object)mapper.getObjectMapper().writeValueAsString((Object)expectedJson), (Object)mapper.write(o));
    }
}

