/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.git.service;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.test.AssertionsKt;
import kotlin.text.StringsKt;
import net.nemerosa.ontrack.extension.git.AbstractGitTestSupport;
import net.nemerosa.ontrack.extension.git.model.ConfiguredBuildGitCommitLink;
import net.nemerosa.ontrack.extension.git.service.GitChangeLogGraphQLIT;
import net.nemerosa.ontrack.extension.issues.support.MockIssue;
import net.nemerosa.ontrack.extension.issues.support.MockIssueServiceExtension;
import net.nemerosa.ontrack.extension.issues.support.MockIssueStatus;
import net.nemerosa.ontrack.git.support.GitRepo;
import net.nemerosa.ontrack.graphql.AbstractQLKTITJUnit4Support;
import net.nemerosa.ontrack.it.AbstractDSLTestJUnit4Support;
import net.nemerosa.ontrack.it.AbstractServiceTestJUnit4Support;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.test.KTTestUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\u0006H\u0017J\b\u0010\b\u001a\u00020\u0006H\u0017J\b\u0010\t\u001a\u00020\u0006H\u0017J\b\u0010\n\u001a\u00020\u0006H\u0017J\b\u0010\u000b\u001a\u00020\u0006H\u0017J\b\u0010\f\u001a\u00020\u0006H\u0017J\b\u0010\r\u001a\u00020\u0006H\u0017J\b\u0010\u000e\u001a\u00020\u0006H\u0017J\b\u0010\u000f\u001a\u00020\u0006H\u0017J\u001c\u0010\u0010\u001a\u00020\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\u0012H\u0012J@\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0016H\u0012R\u0012\u0010\u0003\u001a\u00020\u00048\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lnet/nemerosa/ontrack/extension/git/service/GitChangeLogGraphQLIT;", "Lnet/nemerosa/ontrack/extension/git/AbstractGitTestSupport;", "()V", "mockIssueServiceExtension", "Lnet/nemerosa/ontrack/extension/issues/support/MockIssueServiceExtension;", "Change log based on Git property", "", "Change log based on Git property using root query", "Change log export of issues with default format", "Change log export of issues with grouping", "Change log export of issues with grouping and default alt group", "Change log export of issues with grouping and specific alt group", "Change log export of issues with markdown format", "Change log export of issues without grouping and with exclusions", "Change log of issues based on Git property", "before", "doTest", "testCode", "Lkotlin/Function1;", "Lnet/nemerosa/ontrack/model/structure/Branch;", "doTestChangeLogExport", "expected", "", "format", "grouping", "altGroup", "exclude", "ontrack-extension-git"})
public class GitChangeLogGraphQLIT
extends AbstractGitTestSupport {
    @Autowired
    private MockIssueServiceExtension mockIssueServiceExtension;

    @Before
    public void before() {
        MockIssueServiceExtension mockIssueServiceExtension = this.mockIssueServiceExtension;
        if (mockIssueServiceExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mockIssueServiceExtension");
            mockIssueServiceExtension = null;
        }
        mockIssueServiceExtension.resetIssues();
    }

    private void doTest(Function1<? super Branch, Unit> testCode) {
        this.createRepo((Function1)new Function1<GitRepo, Map<Integer, ? extends String>>(this){
            final /* synthetic */ GitChangeLogGraphQLIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Map<Integer, String> invoke(@NotNull GitRepo $this$createRepo) {
                Intrinsics.checkNotNullParameter((Object)$this$createRepo, (String)"$this$createRepo");
                return AbstractGitTestSupport.commits$default(this.this$0, $this$createRepo, 10, true, false, 4, null);
            }
        }).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this, testCode){
            final /* synthetic */ GitChangeLogGraphQLIT this$0;
            final /* synthetic */ Function1<Branch, Unit> $testCode;
            {
                this.this$0 = $receiver;
                this.$testCode = $testCode;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> commits) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(commits, (String)"commits");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo, commits, this.$testCode){
                    final /* synthetic */ GitChangeLogGraphQLIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    final /* synthetic */ Map<Integer, String> $commits;
                    final /* synthetic */ Function1<Branch, Unit> $testCode;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        this.$commits = $commits;
                        this.$testCode = $testCode;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        GitChangeLogGraphQLIT.access$gitProject(this.this$0, $this$project, this.$repo, true);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0, this.$commits, this.$testCode){
                            final /* synthetic */ GitChangeLogGraphQLIT this$0;
                            final /* synthetic */ Map<Integer, String> $commits;
                            final /* synthetic */ Function1<Branch, Unit> $testCode;
                            {
                                this.this$0 = $receiver;
                                this.$commits = $commits;
                                this.$testCode = $testCode;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull Branch $this$branch) {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                GitChangeLogGraphQLIT.access$gitBranch(this.this$0, $this$branch, "main", (Function0)new Function0<ConfiguredBuildGitCommitLink<?>>(this.this$0){
                                    final /* synthetic */ GitChangeLogGraphQLIT this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @NotNull
                                    public final ConfiguredBuildGitCommitLink<?> invoke() {
                                        return GitChangeLogGraphQLIT.access$commitAsProperty(this.this$0);
                                    }
                                });
                                Object object = new Integer[]{2, 5, 7, 8};
                                object = CollectionsKt.listOf((Object[])object);
                                GitChangeLogGraphQLIT gitChangeLogGraphQLIT = this.this$0;
                                Map<Integer, String> map = this.$commits;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    int no = ((Number)element$iv).intValue();
                                    boolean bl = false;
                                    gitChangeLogGraphQLIT.build($this$branch, String.valueOf(no), (Function1)new Function1<Build, Unit>(gitChangeLogGraphQLIT, map, no){
                                        final /* synthetic */ GitChangeLogGraphQLIT this$0;
                                        final /* synthetic */ Map<Integer, String> $commits;
                                        final /* synthetic */ int $no;
                                        {
                                            this.this$0 = $receiver;
                                            this.$commits = $commits;
                                            this.$no = $no;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull Build $this$build) {
                                            Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                                            GitChangeLogGraphQLIT.access$gitCommitProperty(this.this$0, $this$build, (String)MapsKt.getValue(this.$commits, (Object)this.$no));
                                        }
                                    });
                                }
                                object = new ProjectEntity[]{(ProjectEntity)$this$branch};
                                GitChangeLogGraphQLIT.access$asUserWithView(this.this$0, (ProjectEntity[])object).execute((Function0)new Function0<Unit>(this.$testCode, $this$branch){
                                    final /* synthetic */ Function1<Branch, Unit> $testCode;
                                    final /* synthetic */ Branch $this_branch;
                                    {
                                        this.$testCode = $testCode;
                                        this.$this_branch = $this_branch;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        this.$testCode.invoke((Object)this.$this_branch);
                                    }
                                });
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    @Test
    public void Change log based on Git property() {
        this.doTest((Function1<? super Branch, Unit>)((Function1)new Function1<Branch, Unit>(this){
            final /* synthetic */ GitChangeLogGraphQLIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Branch branch2) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)branch2, (String)"branch");
                JsonNode data2 = AbstractQLKTITJUnit4Support.run$default((AbstractQLKTITJUnit4Support)this.this$0, (String)("{\n                branches(id: " + branch2.getId() + ") {\n                    gitChangeLog(from: \"5\", to: \"7\") {\n                        commits {\n                            commit {\n                                shortMessage\n                            }\n                        }\n                    }\n                }\n            }"), null, (int)2, null);
                JsonNode jsonNode = data2.get("branches").get(0).get("gitChangeLog").get("commits");
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"data[\"branches\"][0][\"gitChangeLog\"][\"commits\"]");
                Iterable $this$map$iv = (Iterable)jsonNode;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsonNode jsonNode2 = (JsonNode)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.get("commit").get("shortMessage").asText());
                }
                List messages = (List)destination$iv$iv;
                Object[] objectArray = new String[]{"Commit 7", "Commit 6"};
                AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])objectArray), (Object)messages, null, (int)4, null);
            }
        }));
    }

    @Test
    public void Change log of issues based on Git property() {
        this.createRepo(Change log of issues based on Git property.1.INSTANCE).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this){
            final /* synthetic */ GitChangeLogGraphQLIT this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> commits) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(commits, (String)"commits");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo, commits){
                    final /* synthetic */ GitChangeLogGraphQLIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    final /* synthetic */ Map<Integer, String> $commits;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        this.$commits = $commits;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        GitChangeLogGraphQLIT.access$gitProject(this.this$0, $this$project, this.$repo, true);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0, this.$commits){
                            final /* synthetic */ GitChangeLogGraphQLIT this$0;
                            final /* synthetic */ Map<Integer, String> $commits;
                            {
                                this.this$0 = $receiver;
                                this.$commits = $commits;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull Branch $this$branch) {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                GitChangeLogGraphQLIT.access$gitBranch(this.this$0, $this$branch, "main", (Function0)new Function0<ConfiguredBuildGitCommitLink<?>>(this.this$0){
                                    final /* synthetic */ GitChangeLogGraphQLIT this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @NotNull
                                    public final ConfiguredBuildGitCommitLink<?> invoke() {
                                        return GitChangeLogGraphQLIT.access$commitAsProperty(this.this$0);
                                    }
                                });
                                ProjectEntity[] projectEntityArray = (ProjectEntity[])new IntRange(1, 5);
                                GitChangeLogGraphQLIT gitChangeLogGraphQLIT = this.this$0;
                                Map<Integer, String> map = this.$commits;
                                boolean $i$f$forEach = false;
                                Iterator<T> iterator = $this$forEach$iv.iterator();
                                while (iterator.hasNext()) {
                                    int element$iv;
                                    int no = element$iv = ((IntIterator)iterator).nextInt();
                                    boolean bl = false;
                                    gitChangeLogGraphQLIT.build($this$branch, String.valueOf(no), (Function1)new Function1<Build, Unit>(gitChangeLogGraphQLIT, map, no){
                                        final /* synthetic */ GitChangeLogGraphQLIT this$0;
                                        final /* synthetic */ Map<Integer, String> $commits;
                                        final /* synthetic */ int $no;
                                        {
                                            this.this$0 = $receiver;
                                            this.$commits = $commits;
                                            this.$no = $no;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull Build $this$build) {
                                            Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                                            GitChangeLogGraphQLIT.access$gitCommitProperty(this.this$0, $this$build, (String)MapsKt.getValue(this.$commits, (Object)this.$no));
                                        }
                                    });
                                }
                                projectEntityArray = new ProjectEntity[]{(ProjectEntity)$this$branch};
                                GitChangeLogGraphQLIT.access$asUserWithView(this.this$0, projectEntityArray).execute((Function0)new Function0<Unit>(this.this$0, $this$branch){
                                    final /* synthetic */ GitChangeLogGraphQLIT this$0;
                                    final /* synthetic */ Branch $this_branch;
                                    {
                                        this.this$0 = $receiver;
                                        this.$this_branch = $this_branch;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        JsonNode data2 = AbstractQLKTITJUnit4Support.run$default((AbstractQLKTITJUnit4Support)this.this$0, (String)("{\n                            branches(id: " + this.$this_branch.getId() + ") {\n                                gitChangeLog(from: \"1\", to: \"5\") {\n                                    issues {\n                                        issueServiceConfiguration {\n                                            id\n                                            name\n                                            serviceId\n                                        }\n                                        list {\n                                            issue {\n                                                key\n                                                displayKey\n                                                summary\n                                                url\n                                                status {\n                                                    name\n                                                }\n                                                updateTime\n                                            }\n                                        }\n                                    }\n                                }\n                            }\n                        }"), null, (int)2, null);
                                        boolean bl = false;
                                        JsonNode issues = data2.path("branches").path(0).path("gitChangeLog").path("issues");
                                        KTTestUtilsKt.assertJsonNotNull$default((JsonNode)issues, null, (Function1)Change log of issues based on Git property.1.1.INSTANCE, (int)2, null);
                                    }
                                });
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    private void doTestChangeLogExport(String expected, String format, String grouping, String altGroup, String exclude) {
        Object object;
        MockIssueServiceExtension mockIssueServiceExtension = this.mockIssueServiceExtension;
        if (mockIssueServiceExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mockIssueServiceExtension");
            mockIssueServiceExtension = null;
        }
        MockIssue[] mockIssueArray = new MockIssue[]{new MockIssue(1, MockIssueStatus.CLOSED, "bug"), new MockIssue(2, MockIssueStatus.CLOSED, "feature"), new MockIssue(3, MockIssueStatus.OPEN, "feature")};
        mockIssueServiceExtension.register(mockIssueArray);
        if (format != null || grouping != null || altGroup != null || exclude != null) {
            String it;
            List args = new ArrayList();
            String string = format;
            if (string != null) {
                it = string;
                boolean bl = false;
                ((Collection)args).add("format: \"" + it + "\"");
            }
            String string2 = grouping;
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                ((Collection)args).add("grouping: \"" + it + "\"");
            }
            String string3 = altGroup;
            if (string3 != null) {
                it = string3;
                boolean bl = false;
                ((Collection)args).add("altGroup: \"" + it + "\"");
            }
            String string4 = exclude;
            if (string4 != null) {
                it = string4;
                boolean bl = false;
                ((Collection)args).add("exclude: \"" + it + "\"");
            }
            object = "(request: {" + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "})";
        } else {
            object = "";
        }
        String input = object;
        this.createRepo(doTestChangeLogExport.1.INSTANCE).and((Function2)new Function2<GitRepo, Map<Integer, ? extends String>, Unit>(this, input, expected){
            final /* synthetic */ GitChangeLogGraphQLIT this$0;
            final /* synthetic */ String $input;
            final /* synthetic */ String $expected;
            {
                this.this$0 = $receiver;
                this.$input = $input;
                this.$expected = $expected;
                super(2);
            }

            public final void invoke(@NotNull GitRepo repo, @NotNull Map<Integer, String> commits) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter(commits, (String)"commits");
                AbstractDSLTestJUnit4Support.project$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), null, (Function1)((Function1)new Function1<Project, Unit>(this.this$0, repo, commits, this.$input, this.$expected){
                    final /* synthetic */ GitChangeLogGraphQLIT this$0;
                    final /* synthetic */ GitRepo $repo;
                    final /* synthetic */ Map<Integer, String> $commits;
                    final /* synthetic */ String $input;
                    final /* synthetic */ String $expected;
                    {
                        this.this$0 = $receiver;
                        this.$repo = $repo;
                        this.$commits = $commits;
                        this.$input = $input;
                        this.$expected = $expected;
                        super(1);
                    }

                    public final void invoke(@NotNull Project $this$project) {
                        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
                        GitChangeLogGraphQLIT.access$gitProject(this.this$0, $this$project, this.$repo, true);
                        AbstractDSLTestJUnit4Support.branch$default((AbstractDSLTestJUnit4Support)((AbstractDSLTestJUnit4Support)this.this$0), (Project)$this$project, null, (Function1)((Function1)new Function1<Branch, Unit>(this.this$0, this.$commits, this.$input, this.$expected){
                            final /* synthetic */ GitChangeLogGraphQLIT this$0;
                            final /* synthetic */ Map<Integer, String> $commits;
                            final /* synthetic */ String $input;
                            final /* synthetic */ String $expected;
                            {
                                this.this$0 = $receiver;
                                this.$commits = $commits;
                                this.$input = $input;
                                this.$expected = $expected;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull Branch $this$branch) {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$branch, (String)"$this$branch");
                                GitChangeLogGraphQLIT.access$gitBranch(this.this$0, $this$branch, "main", (Function0)new Function0<ConfiguredBuildGitCommitLink<?>>(this.this$0){
                                    final /* synthetic */ GitChangeLogGraphQLIT this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @NotNull
                                    public final ConfiguredBuildGitCommitLink<?> invoke() {
                                        return GitChangeLogGraphQLIT.access$commitAsProperty(this.this$0);
                                    }
                                });
                                ProjectEntity[] projectEntityArray = (ProjectEntity[])new IntRange(1, 6);
                                GitChangeLogGraphQLIT gitChangeLogGraphQLIT = this.this$0;
                                Map<Integer, String> map = this.$commits;
                                boolean $i$f$forEach = false;
                                Iterator<T> iterator = $this$forEach$iv.iterator();
                                while (iterator.hasNext()) {
                                    int element$iv;
                                    int no = element$iv = ((IntIterator)iterator).nextInt();
                                    boolean bl = false;
                                    gitChangeLogGraphQLIT.build($this$branch, String.valueOf(no), (Function1)new Function1<Build, Unit>(gitChangeLogGraphQLIT, map, no){
                                        final /* synthetic */ GitChangeLogGraphQLIT this$0;
                                        final /* synthetic */ Map<Integer, String> $commits;
                                        final /* synthetic */ int $no;
                                        {
                                            this.this$0 = $receiver;
                                            this.$commits = $commits;
                                            this.$no = $no;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull Build $this$build) {
                                            Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                                            GitChangeLogGraphQLIT.access$gitCommitProperty(this.this$0, $this$build, (String)MapsKt.getValue(this.$commits, (Object)this.$no));
                                        }
                                    });
                                }
                                projectEntityArray = new ProjectEntity[]{(ProjectEntity)$this$branch};
                                GitChangeLogGraphQLIT.access$asUserWithView(this.this$0, projectEntityArray).execute((Function0)new Function0<Unit>(this.this$0, $this$branch, this.$input, this.$expected){
                                    final /* synthetic */ GitChangeLogGraphQLIT this$0;
                                    final /* synthetic */ Branch $this_branch;
                                    final /* synthetic */ String $input;
                                    final /* synthetic */ String $expected;
                                    {
                                        this.this$0 = $receiver;
                                        this.$this_branch = $this_branch;
                                        this.$input = $input;
                                        this.$expected = $expected;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        JsonNode jsonNode = AbstractQLKTITJUnit4Support.run$default((AbstractQLKTITJUnit4Support)this.this$0, (String)("{\n                            branches(id: " + this.$this_branch.getId() + ") {\n                                gitChangeLog(from: \"1\", to: \"6\") {\n                                    export" + this.$input + "\n                                }\n                            }\n                        }"), null, (int)2, null);
                                        String string = this.$expected;
                                        JsonNode data2 = jsonNode;
                                        boolean bl = false;
                                        String export = data2.path("branches").path(0).path("gitChangeLog").path("export").asText();
                                        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                                        Intrinsics.checkNotNullExpressionValue((Object)export, (String)"export");
                                        AssertionsKt.assertEquals$default((Object)string2, (Object)((Object)StringsKt.trim((CharSequence)export)).toString(), null, (int)4, null);
                                    }
                                });
                            }
                        }), (int)1, null);
                    }
                }), (int)1, null);
            }
        });
    }

    static /* synthetic */ void doTestChangeLogExport$default(GitChangeLogGraphQLIT gitChangeLogGraphQLIT, String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doTestChangeLogExport");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        gitChangeLogGraphQLIT.doTestChangeLogExport(string, string2, string3, string4, string5);
    }

    @Test
    public void Change log export of issues with default format() {
        GitChangeLogGraphQLIT.doTestChangeLogExport$default(this, "* #1 Issue #1\n* #2 Issue #2\n* #3 Issue #3", null, null, null, null, 30, null);
    }

    @Test
    public void Change log export of issues with markdown format() {
        GitChangeLogGraphQLIT.doTestChangeLogExport$default(this, "* [#1](uri:issue/1) Issue #1\n* [#2](uri:issue/2) Issue #2\n* [#3](uri:issue/3) Issue #3", "markdown", null, null, null, 28, null);
    }

    @Test
    public void Change log export of issues with grouping() {
        GitChangeLogGraphQLIT.doTestChangeLogExport$default(this, "Bugs\n\n* #1 Issue #1\n\nFeatures\n\n* #2 Issue #2\n* #3 Issue #3", null, "Bugs=bug|Features=feature", null, null, 26, null);
    }

    @Test
    public void Change log export of issues with grouping and default alt group() {
        GitChangeLogGraphQLIT.doTestChangeLogExport$default(this, "\nFeatures\n\n* #2 Issue #2\n* #3 Issue #3\n\nOther\n\n* #1 Issue #1", null, "Features=feature", null, null, 26, null);
    }

    @Test
    public void Change log export of issues with grouping and specific alt group() {
        GitChangeLogGraphQLIT.doTestChangeLogExport$default(this, "\nFeatures\n\n* #2 Issue #2\n* #3 Issue #3\n\nMisc\n\n* #1 Issue #1", null, "Features=feature", "Misc", null, 18, null);
    }

    @Test
    @Ignore(value="flaky")
    public void Change log export of issues without grouping and with exclusions() {
        GitChangeLogGraphQLIT.doTestChangeLogExport$default(this, "\n* #2 Issue #2\n* #3 Issue #3", null, null, null, "bug", 14, null);
    }

    @Test
    public void Change log based on Git property using root query() {
        this.doTest((Function1<? super Branch, Unit>)((Function1)new Function1<Branch, Unit>(this){
            final /* synthetic */ GitChangeLogGraphQLIT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Branch branch2) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)branch2, (String)"branch");
                int build5 = ((Build)GitChangeLogGraphQLIT.access$getStructureService(this.this$0).findBuildByName(branch2.getProject().getName(), branch2.getName(), "5").orElse(null)).id();
                int build7 = ((Build)GitChangeLogGraphQLIT.access$getStructureService(this.this$0).findBuildByName(branch2.getProject().getName(), branch2.getName(), "7").orElse(null)).id();
                JsonNode data2 = AbstractQLKTITJUnit4Support.run$default((AbstractQLKTITJUnit4Support)this.this$0, (String)("{\n                gitChangeLog(from: " + build5 + ", to: " + build7 + ") {\n                    commits {\n                        commit {\n                            shortMessage\n                        }\n                    }\n                }\n            }"), null, (int)2, null);
                JsonNode jsonNode = data2.get("gitChangeLog").get("commits");
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"data[\"gitChangeLog\"][\"commits\"]");
                Iterable $this$map$iv = (Iterable)jsonNode;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsonNode jsonNode2 = (JsonNode)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.get("commit").get("shortMessage").asText());
                }
                List messages = (List)destination$iv$iv;
                Object[] objectArray = new String[]{"Commit 7", "Commit 6"};
                AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])objectArray), (Object)messages, null, (int)4, null);
            }
        }));
    }

    public static final /* synthetic */ void access$gitProject(GitChangeLogGraphQLIT $this, Project $receiver, GitRepo repo, boolean sync) {
        $this.gitProject($receiver, repo, sync);
    }

    public static final /* synthetic */ void access$gitBranch(GitChangeLogGraphQLIT $this, Branch $receiver, String branchName, Function0 commitLinkConfiguration) {
        $this.gitBranch($receiver, branchName, commitLinkConfiguration);
    }

    public static final /* synthetic */ ConfiguredBuildGitCommitLink access$commitAsProperty(GitChangeLogGraphQLIT $this) {
        return $this.commitAsProperty();
    }

    public static final /* synthetic */ AbstractServiceTestJUnit4Support.ConfigurableAccountCall access$asUserWithView(GitChangeLogGraphQLIT $this, ProjectEntity ... entities) {
        return $this.asUserWithView(entities);
    }

    public static final /* synthetic */ void access$gitCommitProperty(GitChangeLogGraphQLIT $this, Build $receiver, String commit) {
        $this.gitCommitProperty($receiver, commit);
    }

    public static final /* synthetic */ StructureService access$getStructureService(GitChangeLogGraphQLIT $this) {
        return $this.getStructureService();
    }
}

