/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm;

import java.net.URI;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.scm.SCMFileChangeFilterNotFound;
import net.nemerosa.ontrack.extension.scm.model.SCMFileChangeFilter;
import net.nemerosa.ontrack.extension.scm.model.SCMFileChangeFilters;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Memo;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.EntityDataService;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resource;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"extension/scm"})
public class SCMController
extends AbstractResourceController {
    private final EntityDataService entityDataService;
    private final StructureService structureService;
    private final SecurityService securityService;

    @Autowired
    public SCMController(EntityDataService entityDataService, StructureService structureService, SecurityService securityService) {
        this.entityDataService = entityDataService;
        this.structureService = structureService;
        this.securityService = securityService;
    }

    @RequestMapping(value={"changeLog/fileFilter/{projectId}"}, method={RequestMethod.GET})
    public Resources<Resource<SCMFileChangeFilter>> getChangeLogFileFilters(@PathVariable ID projectId) {
        SCMFileChangeFilters config = this.loadStore(projectId);
        return (Resources)Resources.of(config.getFilters().stream().map(f -> this.toResource(projectId, (SCMFileChangeFilter)f)), (URI)this.uri(((SCMController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getChangeLogFileFilters(projectId))).with("_create", this.uri(((SCMController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).createChangeLogFileFilterForm(projectId)), this.securityService.isProjectFunctionGranted(projectId.get(), ProjectConfig.class));
    }

    @RequestMapping(value={"changeLog/fileFilter/{projectId}/create"}, method={RequestMethod.GET})
    public Form createChangeLogFileFilterForm(@PathVariable ID projectId) {
        return Form.create().with((Field)((Text)Text.of((String)"name").label("Name")).help("Name to use to save the filter.")).with((Field)((Memo)Memo.of((String)"patterns").label("Filter(s)")).help("List of ANT-like patterns (one per line)."));
    }

    @RequestMapping(value={"changeLog/fileFilter/{projectId}/create"}, method={RequestMethod.POST})
    public Resource<SCMFileChangeFilter> createChangeLogFileFilter(@PathVariable ID projectId, @RequestBody SCMFileChangeFilter filter) {
        this.securityService.checkProjectFunction(projectId.get(), ProjectConfig.class);
        return (Resource)this.securityService.asAdmin(() -> {
            Project project = this.structureService.getProject(projectId);
            SCMFileChangeFilters config = (SCMFileChangeFilters)this.entityDataService.retrieve((ProjectEntity)project, SCMFileChangeFilters.class.getName(), SCMFileChangeFilters.class);
            if (config == null) {
                config = SCMFileChangeFilters.create();
            }
            config = config.save(filter);
            this.entityDataService.store((ProjectEntity)project, SCMFileChangeFilters.class.getName(), (Object)config);
            return this.getChangeLogFileFilter(projectId, filter.getName());
        });
    }

    @RequestMapping(value={"changeLog/fileFilter/{projectId}/{name}/update"}, method={RequestMethod.GET})
    public Form saveChangeLogFileFilterForm(@PathVariable ID projectId, @PathVariable String name) {
        Resource<SCMFileChangeFilter> filter = this.getChangeLogFileFilter(projectId, name);
        return Form.create().with((Field)((Text)((Text)((Text)Text.of((String)"name").label("Name")).help("Name to use to save the filter.")).readOnly()).value((Object)((SCMFileChangeFilter)filter.getData()).getName())).with((Field)((Memo)((Memo)Memo.of((String)"patterns").label("Filter(s)")).help("List of ANT-like patterns (one per line).")).value((Object)((SCMFileChangeFilter)filter.getData()).getPatterns().stream().collect(Collectors.joining("\n"))));
    }

    @RequestMapping(value={"changeLog/fileFilter/{projectId}/{name}/update"}, method={RequestMethod.PUT})
    public Resource<SCMFileChangeFilter> saveChangeLogFileFilter(@PathVariable ID projectId, @PathVariable String name, @RequestBody SCMFileChangeFilter filter) {
        if (!StringUtils.equals((CharSequence)name, (CharSequence)filter.getName())) {
            throw new IllegalStateException("The name of the filter in the request body must match the one in the URL");
        }
        return this.createChangeLogFileFilter(projectId, filter);
    }

    @RequestMapping(value={"changeLog/fileFilter/{projectId}/{name}"}, method={RequestMethod.GET})
    public Resource<SCMFileChangeFilter> getChangeLogFileFilter(@PathVariable ID projectId, @PathVariable String name) {
        SCMFileChangeFilters config = this.loadStore(projectId);
        return config.getFilters().stream().filter(filter -> StringUtils.equals((CharSequence)name, (CharSequence)filter.getName())).findFirst().map(filter -> this.toResource(projectId, (SCMFileChangeFilter)filter)).orElseThrow(() -> new SCMFileChangeFilterNotFound(name));
    }

    private Resource<SCMFileChangeFilter> toResource(ID projectId, SCMFileChangeFilter filter) {
        boolean granted = this.securityService.isProjectFunctionGranted(projectId.get(), ProjectConfig.class);
        return (Resource)((Resource)Resource.of((Object)filter, (URI)this.uri(((SCMController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getChangeLogFileFilter(projectId, filter.getName()))).with("_delete", this.uri(((SCMController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).deleteChangeLogFileFilter(projectId, filter.getName())), granted)).with("_update", this.uri(((SCMController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).saveChangeLogFileFilterForm(projectId, filter.getName())), granted);
    }

    private SCMFileChangeFilters loadStore(ID projectId) {
        return (SCMFileChangeFilters)this.securityService.asAdmin(() -> {
            Project project = this.structureService.getProject(projectId);
            SCMFileChangeFilters config = (SCMFileChangeFilters)this.entityDataService.retrieve((ProjectEntity)project, SCMFileChangeFilters.class.getName(), SCMFileChangeFilters.class);
            if (config == null) {
                config = SCMFileChangeFilters.create();
            }
            return config;
        });
    }

    @RequestMapping(value={"changeLog/fileFilter/{projectId}/{name}/delete"}, method={RequestMethod.DELETE})
    public Ack deleteChangeLogFileFilter(@PathVariable ID projectId, @PathVariable String name) {
        this.securityService.checkProjectFunction(projectId.get(), ProjectConfig.class);
        this.securityService.asAdmin(() -> this.entityDataService.withData((ProjectEntity)this.structureService.getProject(projectId), SCMFileChangeFilters.class.getName(), SCMFileChangeFilters.class, filters -> filters.remove(name)));
        return Ack.OK;
    }
}

