/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm.catalog;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.nemerosa.ontrack.extension.scm.catalog.CatalogLinkService;
import net.nemerosa.ontrack.extension.scm.catalog.CatalogLinkServiceImpl;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalog;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogEntry;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogProvider;
import net.nemerosa.ontrack.json.KTJsonUtilsKt;
import net.nemerosa.ontrack.model.structure.EntityDataService;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityID;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00060\u0015H\u0012J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/nemerosa/ontrack/extension/scm/catalog/CatalogLinkServiceImpl;", "Lnet/nemerosa/ontrack/extension/scm/catalog/CatalogLinkService;", "scmCatalog", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalog;", "scmCatalogProviders", "", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogProvider;", "structureService", "Lnet/nemerosa/ontrack/model/structure/StructureService;", "entityDataService", "Lnet/nemerosa/ontrack/model/structure/EntityDataService;", "(Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalog;Ljava/util/List;Lnet/nemerosa/ontrack/model/structure/StructureService;Lnet/nemerosa/ontrack/model/structure/EntityDataService;)V", "logger", "Lorg/slf4j/Logger;", "computeCatalogLink", "", "entry", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogEntry;", "projects", "Lnet/nemerosa/ontrack/model/structure/Project;", "providers", "", "", "computeCatalogLinks", "", "getLinkedProject", "getSCMCatalogEntry", "project", "isLinked", "isOrphan", "storeLink", "ontrack-extension-scm"})
public class CatalogLinkServiceImpl
implements CatalogLinkService {
    @NotNull
    private final SCMCatalog scmCatalog;
    @NotNull
    private final List<SCMCatalogProvider> scmCatalogProviders;
    @NotNull
    private final StructureService structureService;
    @NotNull
    private final EntityDataService entityDataService;
    @NotNull
    private final Logger logger;

    public CatalogLinkServiceImpl(@NotNull SCMCatalog scmCatalog, @NotNull List<? extends SCMCatalogProvider> scmCatalogProviders, @NotNull StructureService structureService, @NotNull EntityDataService entityDataService) {
        Intrinsics.checkNotNullParameter((Object)scmCatalog, (String)"scmCatalog");
        Intrinsics.checkNotNullParameter(scmCatalogProviders, (String)"scmCatalogProviders");
        Intrinsics.checkNotNullParameter((Object)structureService, (String)"structureService");
        Intrinsics.checkNotNullParameter((Object)entityDataService, (String)"entityDataService");
        this.scmCatalog = scmCatalog;
        this.scmCatalogProviders = scmCatalogProviders;
        this.structureService = structureService;
        this.entityDataService = entityDataService;
        Logger logger = LoggerFactory.getLogger(CatalogLinkService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(CatalogLinkService::class.java)");
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void computeCatalogLinks() {
        Object element$iv;
        void $this$associateByTo$iv$iv;
        List projects = this.structureService.getProjectList();
        Iterable $this$associateBy$iv = this.scmCatalogProviders;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            SCMCatalogProvider sCMCatalogProvider = (SCMCatalogProvider)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv);
        }
        Map providers = destination$iv$iv;
        Sequence<SCMCatalogEntry> catalogEntries = this.scmCatalog.getCatalogEntries();
        Set allCatalogKeys2 = SequencesKt.toSet((Sequence)SequencesKt.map(catalogEntries, (Function1)computeCatalogLinks.allCatalogKeys.1.INSTANCE));
        Set leftOverKeys2 = SequencesKt.toMutableSet((Sequence)SequencesKt.map(catalogEntries, (Function1)computeCatalogLinks.leftOverKeys.1.INSTANCE));
        Object $this$forEach$iv = catalogEntries;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            SCMCatalogEntry it = (SCMCatalogEntry)element$iv;
            boolean bl = false;
            if (!this.computeCatalogLink(it, projects, providers)) continue;
            leftOverKeys2.remove(it.getKey());
        }
        $this$forEach$iv = projects;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            Project project = (Project)element$iv;
            boolean bl = false;
            ProjectEntity projectEntity = (ProjectEntity)project;
            String string = CatalogLinkService.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CatalogLinkService::class.java.name");
            String value = this.entityDataService.retrieve(projectEntity, string);
            CharSequence charSequence = value;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || !leftOverKeys2.contains(value) && allCatalogKeys2.contains(value)) continue;
            this.logger.debug("Catalog entry " + value + " --> " + project.getName() + " is obsolete.");
            ProjectEntity projectEntity2 = (ProjectEntity)project;
            String string2 = CatalogLinkService.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CatalogLinkService::class.java.name");
            this.entityDataService.delete(projectEntity2, string2);
        }
    }

    @Override
    @Nullable
    public SCMCatalogEntry getSCMCatalogEntry(@NotNull Project project) {
        SCMCatalogEntry sCMCatalogEntry;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectEntity projectEntity = (ProjectEntity)project;
        String string = CatalogLinkService.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CatalogLinkService::class.java.name");
        String string2 = this.entityDataService.retrieve(projectEntity, string);
        if (string2 != null) {
            String $this$getSCMCatalogEntry_u24lambda_u2d3 = string2;
            boolean bl = false;
            sCMCatalogEntry = this.scmCatalog.getCatalogEntry($this$getSCMCatalogEntry_u24lambda_u2d3);
        } else {
            sCMCatalogEntry = null;
        }
        return sCMCatalogEntry;
    }

    @Override
    @Nullable
    public Project getLinkedProject(@NotNull SCMCatalogEntry entry) {
        Project project;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        String string = CatalogLinkService.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CatalogLinkService::class.java.name");
        ProjectEntityID projectEntityID = this.entityDataService.findEntityByValue(ProjectEntityType.PROJECT, string, KTJsonUtilsKt.asJson((Object)entry.getKey()));
        if (projectEntityID != null) {
            boolean bl;
            ProjectEntityID $this$getLinkedProject_u24lambda_u2d4 = projectEntityID;
            boolean bl2 = false;
            boolean bl3 = bl = $this$getLinkedProject_u24lambda_u2d4.getType() == ProjectEntityType.PROJECT;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            project = this.structureService.getProject(ID.Companion.of($this$getLinkedProject_u24lambda_u2d4.getId()));
        } else {
            project = null;
        }
        return project;
    }

    @Override
    public boolean isLinked(@NotNull SCMCatalogEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        String string = CatalogLinkService.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CatalogLinkService::class.java.name");
        return this.entityDataService.findEntityByValue(ProjectEntityType.PROJECT, string, KTJsonUtilsKt.asJson((Object)entry.getKey())) != null;
    }

    @Override
    public boolean isOrphan(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectEntity projectEntity = (ProjectEntity)project;
        String string = CatalogLinkService.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CatalogLinkService::class.java.name");
        return !this.entityDataService.hasEntityValue(projectEntity, string);
    }

    private boolean computeCatalogLink(SCMCatalogEntry entry, List<? extends Project> projects, Map<String, ? extends SCMCatalogProvider> providers) {
        this.logger.debug("Catalog entry " + entry.getKey());
        SCMCatalogProvider provider = providers.get(entry.getScm());
        if (provider != null) {
            Iterable $this$forEach$iv = projects;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Project project = (Project)element$iv;
                boolean bl = false;
                if (!provider.matches(entry, project)) continue;
                this.logger.debug("Catalog entry " + entry.getKey() + " --> " + project.getName());
                this.storeLink(project, entry);
                return true;
            }
        }
        return false;
    }

    @Override
    public void storeLink(@NotNull Project project, @NotNull SCMCatalogEntry entry) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        ProjectEntity projectEntity = (ProjectEntity)project;
        String string = CatalogLinkService.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CatalogLinkService::class.java.name");
        this.entityDataService.store(projectEntity, string, entry.getKey());
    }
}

