/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm.catalog;

import com.opencsv.CSVWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.nemerosa.ontrack.common.Document;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogEntry;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogExportService;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogExportServiceImpl;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogTeam;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0012J\u0018\u0010\f\u001a\u00020\t2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0006H\u0012\u00a8\u0006\u000f"}, d2={"Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogExportServiceImpl;", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogExportService;", "()V", "exportCatalogAsCSV", "Lnet/nemerosa/ontrack/common/Document;", "entries", "", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogEntry;", "formatDateTime", "", "localDateTime", "Ljava/time/LocalDateTime;", "formatTeams", "teams", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogTeam;", "ontrack-extension-scm"})
public class SCMCatalogExportServiceImpl
implements SCMCatalogExportService {
    @Override
    @NotNull
    public Document exportCatalogAsCSV(@NotNull List<SCMCatalogEntry> entries2) {
        Intrinsics.checkNotNullParameter(entries2, (String)"entries");
        StringWriter output = new StringWriter();
        CSVWriter csvWriter = new CSVWriter((Writer)output);
        Object object = new String[]{"scm", "config", "repository", "lastActivity", "createdAt", "timestamp", "teams"};
        csvWriter.writeNext((String[])object);
        Iterable $this$forEach$iv = entries2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SCMCatalogEntry entry = (SCMCatalogEntry)element$iv;
            boolean bl = false;
            String[] stringArray = new String[]{entry.getScm(), entry.getConfig(), entry.getRepository(), this.formatDateTime(entry.getLastActivity()), this.formatDateTime(entry.getCreatedAt()), this.formatDateTime(entry.getTimestamp()), this.formatTeams(entry.getTeams())};
            csvWriter.writeNext(stringArray);
        }
        csvWriter.close();
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.toString()");
        object = string;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return new Document("text/plain", byArray);
    }

    private String formatTeams(List<SCMCatalogTeam> teams) {
        List<SCMCatalogTeam> list = teams;
        if (list == null || (list = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, (Function1)formatTeams.1.INSTANCE, (int)30, null)) == null) {
            list = "";
        }
        return list;
    }

    private String formatDateTime(LocalDateTime localDateTime) {
        LocalDateTime localDateTime2 = localDateTime;
        String string = localDateTime2 != null ? localDateTime2.format(DateTimeFormatter.ISO_DATE_TIME) : null;
        if (string == null) {
            string = "";
        }
        return string;
    }
}

