/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm.catalog;

import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.nemerosa.ontrack.common._KTUtilsKt;
import net.nemerosa.ontrack.extension.scm.catalog.CatalogLinkService;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalog;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogAccessFunction;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogEntry;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogEntryOrProject;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogFilterService;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogFilterServiceImpl;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogProjectFilter;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogProjectFilterLink;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogProjectFilterSort;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogTeam;
import net.nemerosa.ontrack.model.security.ProjectView;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0012J$\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0012J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001a0\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogFilterServiceImpl;", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogFilterService;", "scmCatalog", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalog;", "catalogLinkService", "Lnet/nemerosa/ontrack/extension/scm/catalog/CatalogLinkService;", "structureService", "Lnet/nemerosa/ontrack/model/structure/StructureService;", "securityService", "Lnet/nemerosa/ontrack/model/security/SecurityService;", "(Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalog;Lnet/nemerosa/ontrack/extension/scm/catalog/CatalogLinkService;Lnet/nemerosa/ontrack/model/structure/StructureService;Lnet/nemerosa/ontrack/model/security/SecurityService;)V", "findCatalogProjectEntries", "", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogEntryOrProject;", "filter", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogProjectFilter;", "getEntryLinkFilter", "Lkotlin/Function1;", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogEntry;", "", "link", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogProjectFilterLink;", "incr", "", "results", "", "", "indexCatalogProjectEntries", "", "ontrack-extension-scm"})
public class SCMCatalogFilterServiceImpl
implements SCMCatalogFilterService {
    @NotNull
    private final SCMCatalog scmCatalog;
    @NotNull
    private final CatalogLinkService catalogLinkService;
    @NotNull
    private final StructureService structureService;
    @NotNull
    private final SecurityService securityService;

    public SCMCatalogFilterServiceImpl(@NotNull SCMCatalog scmCatalog, @NotNull CatalogLinkService catalogLinkService, @NotNull StructureService structureService, @NotNull SecurityService securityService) {
        Intrinsics.checkNotNullParameter((Object)scmCatalog, (String)"scmCatalog");
        Intrinsics.checkNotNullParameter((Object)catalogLinkService, (String)"catalogLinkService");
        Intrinsics.checkNotNullParameter((Object)structureService, (String)"structureService");
        Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
        this.scmCatalog = scmCatalog;
        this.catalogLinkService = catalogLinkService;
        this.structureService = structureService;
        this.securityService = securityService;
    }

    @Override
    @NotNull
    public Map<SCMCatalogProjectFilterLink, Integer> indexCatalogProjectEntries() {
        Map results = new LinkedHashMap();
        Sequence<SCMCatalogEntry> $this$forEach$iv = this.scmCatalog.getCatalogEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SCMCatalogEntry entry = (SCMCatalogEntry)element$iv;
            boolean bl = false;
            this.incr(results, SCMCatalogProjectFilterLink.ALL);
            this.incr(results, SCMCatalogProjectFilterLink.ENTRY);
            boolean linked = this.catalogLinkService.isLinked(entry);
            if (linked) {
                this.incr(results, SCMCatalogProjectFilterLink.LINKED);
                continue;
            }
            this.incr(results, SCMCatalogProjectFilterLink.UNLINKED);
        }
        this.securityService.asAdmin((Function0)new Function0<Unit>(this, (Map<SCMCatalogProjectFilterLink, Integer>)results){
            final /* synthetic */ SCMCatalogFilterServiceImpl this$0;
            final /* synthetic */ Map<SCMCatalogProjectFilterLink, Integer> $results;
            {
                this.this$0 = $receiver;
                this.$results = $results;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                Iterable iterable = SCMCatalogFilterServiceImpl.access$getStructureService$p(this.this$0).getProjectList();
                SCMCatalogFilterServiceImpl sCMCatalogFilterServiceImpl = this.this$0;
                Map<SCMCatalogProjectFilterLink, Integer> map = this.$results;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Project project = (Project)element$iv;
                    boolean bl = false;
                    if (!SCMCatalogFilterServiceImpl.access$getCatalogLinkService$p(sCMCatalogFilterServiceImpl).isOrphan(project)) continue;
                    SCMCatalogFilterServiceImpl.access$incr(sCMCatalogFilterServiceImpl, map, SCMCatalogProjectFilterLink.ALL);
                    SCMCatalogFilterServiceImpl.access$incr(sCMCatalogFilterServiceImpl, map, SCMCatalogProjectFilterLink.ORPHAN);
                }
            }
        });
        return MapsKt.toMap((Map)results);
    }

    private void incr(Map<SCMCatalogProjectFilterLink, Integer> results, SCMCatalogProjectFilterLink link) {
        Map<SCMCatalogProjectFilterLink, Integer> map = results;
        Integer n = results.get((Object)link);
        Integer n2 = n != null ? n + 1 : 1;
        map.put(link, n2);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public List<SCMCatalogEntryOrProject> findCatalogProjectEntries(@NotNull SCMCatalogProjectFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        this.securityService.checkGlobalFunction(SCMCatalogAccessFunction.class);
        var3_2 = filter.getRepository();
        if (var3_2 == null) ** GOTO lbl-1000
        it = var5_3 = var3_2;
        $i$a$-takeIf-SCMCatalogFilterServiceImpl$findCatalogProjectEntries$repositoryRegex$1 = false;
        v0 = var4_9 = !StringsKt.isBlank((CharSequence)it) != false ? var5_3 : null;
        if (var4_9 != null) {
            v1 = new Regex(var4_9);
        } else lbl-1000:
        // 2 sources

        {
            v1 = repositoryRegex = null;
        }
        if ((v2 = filter.getScm()) == null) ** GOTO lbl-1000
        it = it = v2;
        $i$a$-takeIf-SCMCatalogFilterServiceImpl$findCatalogProjectEntries$entryScmFilter$1 = false;
        v2 = !StringsKt.isBlank((CharSequence)it) != false ? it : null;
        if (v2 != null) {
            it = v2;
            $i$a$-let-SCMCatalogFilterServiceImpl$findCatalogProjectEntries$entryScmFilter$2 = false;
            v3 = (Function1)new Function1<SCMCatalogEntry, Boolean>(it){
                final /* synthetic */ String $it;
                {
                    this.$it = $it;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull SCMCatalogEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    return Intrinsics.areEqual((Object)entry.getScm(), (Object)this.$it);
                }
            };
        } else lbl-1000:
        // 2 sources

        {
            v3 = entryScmFilter = (Function1)findCatalogProjectEntries.entryScmFilter.3.INSTANCE;
        }
        if ((v4 = filter.getConfig()) == null) ** GOTO lbl-1000
        it = it = v4;
        $i$a$-takeIf-SCMCatalogFilterServiceImpl$findCatalogProjectEntries$entryConfigFilter$1 = false;
        v4 = !StringsKt.isBlank((CharSequence)it) != false ? it : null;
        if (v4 != null) {
            it = v4;
            $i$a$-let-SCMCatalogFilterServiceImpl$findCatalogProjectEntries$entryConfigFilter$2 = false;
            v5 = (Function1)new Function1<SCMCatalogEntry, Boolean>(it){
                final /* synthetic */ String $it;
                {
                    this.$it = $it;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull SCMCatalogEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    return Intrinsics.areEqual((Object)entry.getConfig(), (Object)this.$it);
                }
            };
        } else lbl-1000:
        // 2 sources

        {
            v5 = findCatalogProjectEntries.entryConfigFilter.3.INSTANCE;
        }
        entryConfigFilter = v5;
        v6 = repositoryRegex;
        if (v6 != null) {
            it = v6;
            $i$a$-let-SCMCatalogFilterServiceImpl$findCatalogProjectEntries$entryRepositoryFilter$1 = false;
            v7 = (Function1)new Function1<SCMCatalogEntry, Boolean>(it){
                final /* synthetic */ Regex $it;
                {
                    this.$it = $it;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull SCMCatalogEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    return this.$it.matches((CharSequence)entry.getRepository());
                }
            };
        } else {
            v7 = findCatalogProjectEntries.entryRepositoryFilter.2.INSTANCE;
        }
        entryRepositoryFilter = v7;
        entryLinkFilter = this.getEntryLinkFilter(filter.getLink());
        v8 = filter.getBeforeLastActivity();
        if (v8 != null) {
            it = v8;
            $i$a$-let-SCMCatalogFilterServiceImpl$findCatalogProjectEntries$entryBeforeLastActivityFilter$1 = false;
            v9 = (Function1)new Function1<SCMCatalogEntry, Boolean>(it){
                final /* synthetic */ LocalDate $it;
                {
                    this.$it = $it;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull SCMCatalogEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    return entry.getLastActivity() != null && entry.getLastActivity().toLocalDate().compareTo(this.$it) <= 0;
                }
            };
        } else {
            v9 = findCatalogProjectEntries.entryBeforeLastActivityFilter.2.INSTANCE;
        }
        entryBeforeLastActivityFilter = v9;
        v10 = filter.getAfterLastActivity();
        if (v10 != null) {
            it = v10;
            $i$a$-let-SCMCatalogFilterServiceImpl$findCatalogProjectEntries$entryAfterLastActivityFilter$1 = false;
            v11 = (Function1)new Function1<SCMCatalogEntry, Boolean>(it){
                final /* synthetic */ LocalDate $it;
                {
                    this.$it = $it;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull SCMCatalogEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    return entry.getLastActivity() != null && entry.getLastActivity().toLocalDate().compareTo(this.$it) >= 0;
                }
            };
        } else {
            v11 = findCatalogProjectEntries.entryAfterLastActivityFilter.2.INSTANCE;
        }
        entryAfterLastActivityFilter = v11;
        v12 = filter.getBeforeCreatedAt();
        if (v12 != null) {
            it = v12;
            $i$a$-let-SCMCatalogFilterServiceImpl$findCatalogProjectEntries$entryBeforeCreatedAtFilter$1 = false;
            v13 = (Function1)new Function1<SCMCatalogEntry, Boolean>(it){
                final /* synthetic */ LocalDate $it;
                {
                    this.$it = $it;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull SCMCatalogEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    return entry.getCreatedAt() != null && entry.getCreatedAt().toLocalDate().compareTo(this.$it) <= 0;
                }
            };
        } else {
            v13 = findCatalogProjectEntries.entryBeforeCreatedAtFilter.2.INSTANCE;
        }
        entryBeforeCreatedAtFilter = v13;
        v14 = filter.getAfterCreatedAt();
        if (v14 != null) {
            it = v14;
            $i$a$-let-SCMCatalogFilterServiceImpl$findCatalogProjectEntries$entryAfterCreatedAtFilter$1 = false;
            v15 = (Function1)new Function1<SCMCatalogEntry, Boolean>(it){
                final /* synthetic */ LocalDate $it;
                {
                    this.$it = $it;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull SCMCatalogEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    return entry.getCreatedAt() != null && entry.getCreatedAt().toLocalDate().compareTo(this.$it) >= 0;
                }
            };
        } else {
            v15 = findCatalogProjectEntries.entryAfterCreatedAtFilter.2.INSTANCE;
        }
        entryAfterCreatedAtFilter = v15;
        entryTeamFilter = (Function1)new Function1<SCMCatalogEntry, Boolean>(filter){
            final /* synthetic */ SCMCatalogProjectFilter $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull SCMCatalogEntry entry) {
                boolean bl;
                void $this$any$iv;
                boolean bl2;
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                Object object = this.$filter.getTeam();
                if (object == null || StringsKt.isBlank((CharSequence)object)) {
                    bl2 = true;
                    return bl2;
                }
                if (Intrinsics.areEqual((Object)this.$filter.getTeam(), (Object)"-")) {
                    object = entry.getTeams();
                    if (object != null && !object.isEmpty()) {
                        bl2 = false;
                        return bl2;
                    }
                    bl2 = true;
                    return bl2;
                }
                List<SCMCatalogTeam> list = entry.getTeams();
                if (list == null) {
                    bl2 = false;
                    return bl2;
                }
                Iterable iterable = list;
                SCMCatalogProjectFilter sCMCatalogProjectFilter = this.$filter;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                    return bl2;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    block11: {
                        block10: {
                            if (!iterator.hasNext()) {
                                bl2 = false;
                                return bl2;
                            }
                            T element$iv = iterator.next();
                            SCMCatalogTeam it = (SCMCatalogTeam)element$iv;
                            boolean bl3 = false;
                            if (StringsKt.contains((CharSequence)it.getId(), (CharSequence)sCMCatalogProjectFilter.getTeam(), (boolean)true)) break block10;
                            String string = it.getName();
                            if (!(string != null ? StringsKt.contains((CharSequence)string, (CharSequence)sCMCatalogProjectFilter.getTeam(), (boolean)true) : false)) break block11;
                        }
                        bl = true;
                        continue;
                    }
                    bl = false;
                } while (!bl);
                bl2 = true;
                return bl2;
            }
        };
        entryFilter = _KTUtilsKt.and((Function1)_KTUtilsKt.and((Function1)_KTUtilsKt.and((Function1)_KTUtilsKt.and((Function1)_KTUtilsKt.and((Function1)_KTUtilsKt.and((Function1)_KTUtilsKt.and((Function1)_KTUtilsKt.and((Function1)entryScmFilter, (Function1)entryConfigFilter), (Function1)entryRepositoryFilter), entryLinkFilter), (Function1)entryBeforeLastActivityFilter), (Function1)entryAfterLastActivityFilter), (Function1)entryBeforeCreatedAtFilter), (Function1)entryAfterCreatedAtFilter), (Function1)entryTeamFilter);
        entries = (Function0)new Function0<Sequence<? extends SCMCatalogEntryOrProject>>(this, (Function1<? super SCMCatalogEntry, Boolean>)entryFilter){
            final /* synthetic */ SCMCatalogFilterServiceImpl this$0;
            final /* synthetic */ Function1<SCMCatalogEntry, Boolean> $entryFilter;
            {
                this.this$0 = $receiver;
                this.$entryFilter = $entryFilter;
                super(0);
            }

            @NotNull
            public final Sequence<SCMCatalogEntryOrProject> invoke() {
                return SequencesKt.map((Sequence)SequencesKt.filter(SCMCatalogFilterServiceImpl.access$getScmCatalog$p(this.this$0).getCatalogEntries(), this.$entryFilter), (Function1)((Function1)new Function1<SCMCatalogEntry, SCMCatalogEntryOrProject>(this.this$0){
                    final /* synthetic */ SCMCatalogFilterServiceImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final SCMCatalogEntryOrProject invoke(@NotNull SCMCatalogEntry entry) {
                        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                        return SCMCatalogEntryOrProject.Companion.entry(entry, SCMCatalogFilterServiceImpl.access$getCatalogLinkService$p(this.this$0).getLinkedProject(entry));
                    }
                }));
            }
        };
        $i$a$-let-SCMCatalogFilterServiceImpl$findCatalogProjectEntries$entryAfterCreatedAtFilter$1 = filter.getProject();
        if ($i$a$-let-SCMCatalogFilterServiceImpl$findCatalogProjectEntries$entryAfterCreatedAtFilter$1 == null) ** GOTO lbl-1000
        it = var17_34 = $i$a$-let-SCMCatalogFilterServiceImpl$findCatalogProjectEntries$entryAfterCreatedAtFilter$1;
        $i$a$-takeIf-SCMCatalogFilterServiceImpl$findCatalogProjectEntries$projectRegex$1 = false;
        v16 = var16_39 = !StringsKt.isBlank((CharSequence)it) != false ? var17_34 : null;
        if (var16_39 != null) {
            v17 = new Regex(var16_39);
        } else lbl-1000:
        // 2 sources

        {
            v17 = null;
        }
        projectRegex = v17;
        projectOrphanProject = (Function1)new Function1<Project, Boolean>(this){
            final /* synthetic */ SCMCatalogFilterServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return SCMCatalogFilterServiceImpl.access$getCatalogLinkService$p(this.this$0).isOrphan(project);
            }
        };
        v18 = projectRegex;
        if (v18 != null) {
            it = v18;
            $i$a$-let-SCMCatalogFilterServiceImpl$findCatalogProjectEntries$projectRegexFilter$1 = false;
            v19 = (Function1)new Function1<Project, Boolean>(it){
                final /* synthetic */ Regex $it;
                {
                    this.$it = $it;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Project project) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    return this.$it.matches((CharSequence)project.getName());
                }
            };
        } else {
            v19 = findCatalogProjectEntries.projectRegexFilter.2.INSTANCE;
        }
        projectRegexFilter = v19;
        projectSecurityFilter = (Function1)new Function1<Project, Boolean>(this){
            final /* synthetic */ SCMCatalogFilterServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return SCMCatalogFilterServiceImpl.access$getSecurityService$p(this.this$0).isProjectFunctionGranted((ProjectEntity)project, ProjectView.class);
            }
        };
        projectFilter = _KTUtilsKt.and((Function1)_KTUtilsKt.and((Function1)projectOrphanProject, (Function1)projectRegexFilter), (Function1)projectSecurityFilter);
        orphanProjects = (Function0)new Function0<Sequence<? extends SCMCatalogEntryOrProject>>(this, (Function1<? super Project, Boolean>)projectFilter){
            final /* synthetic */ SCMCatalogFilterServiceImpl this$0;
            final /* synthetic */ Function1<Project, Boolean> $projectFilter;
            {
                this.this$0 = $receiver;
                this.$projectFilter = $projectFilter;
                super(0);
            }

            @NotNull
            public final Sequence<SCMCatalogEntryOrProject> invoke() {
                return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)SCMCatalogFilterServiceImpl.access$getSecurityService$p(this.this$0).asAdmin((Function0)new Function0<List<? extends Project>>(this.this$0){
                    final /* synthetic */ SCMCatalogFilterServiceImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final List<Project> invoke() {
                        return SCMCatalogFilterServiceImpl.access$getStructureService$p(this.this$0).getProjectList();
                    }
                }))), this.$projectFilter), (Function1)findCatalogProjectEntries.orphanProjects.2.INSTANCE);
            }
        };
        switch (WhenMappings.$EnumSwitchMapping$0[filter.getLink().ordinal()]) {
            case 1: {
                v20 = SequencesKt.plus((Sequence)((Sequence)entries.invoke()), (Sequence)((Sequence)orphanProjects.invoke()));
                break;
            }
            case 2: {
                v20 = (Sequence)entries.invoke();
                break;
            }
            case 3: {
                v20 = (Sequence)entries.invoke();
                break;
            }
            case 4: {
                v20 = (Sequence)entries.invoke();
                break;
            }
            case 5: {
                v20 = (Sequence)orphanProjects.invoke();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        allEntries = v20;
        v21 = filter.getSortOn();
        if (v21 == null) {
            v21 = SCMCatalogProjectFilterSort.REPOSITORY;
        }
        sortOn = v21;
        var23_43 = sortOn.getSortingSelector();
        $this$findCatalogProjectEntries_u24lambda_u2d13 = new Comparator(var23_43){
            final /* synthetic */ Function1 $selector;
            {
                this.$selector = $selector;
            }

            public final int compare(T a, T b) {
                Function1 function1 = this.$selector;
                return ComparisonsKt.compareValues((Comparable)((Comparable)function1.invoke(a)), (Comparable)((Comparable)function1.invoke(b)));
            }
        };
        $i$a$-run-SCMCatalogFilterServiceImpl$findCatalogProjectEntries$comparator$1 = false;
        v22 = filter.getSortAscending() ? $this$findCatalogProjectEntries_u24lambda_u2d13 : $this$findCatalogProjectEntries_u24lambda_u2d13.reversed();
        Intrinsics.checkNotNullExpressionValue(v22, (String)"compareBy(sortOn.sorting\u2026          }\n            }");
        comparator = v22;
        return SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.drop((Sequence)SequencesKt.sortedWith((Sequence)allEntries, comparator), (int)filter.getOffset()), (int)filter.getSize()));
    }

    private Function1<SCMCatalogEntry, Boolean> getEntryLinkFilter(SCMCatalogProjectFilterLink link) {
        return (Function1)new Function1<SCMCatalogEntry, Boolean>(link, this){
            final /* synthetic */ SCMCatalogProjectFilterLink $link;
            final /* synthetic */ SCMCatalogFilterServiceImpl this$0;
            {
                this.$link = $link;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SCMCatalogEntry entry) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                switch (getEntryLinkFilter.WhenMappings.$EnumSwitchMapping$0[this.$link.ordinal()]) {
                    case 1: {
                        bl = true;
                        break;
                    }
                    case 2: {
                        bl = true;
                        break;
                    }
                    case 3: {
                        bl = SCMCatalogFilterServiceImpl.access$getCatalogLinkService$p(this.this$0).isLinked(entry);
                        break;
                    }
                    case 4: {
                        if (!SCMCatalogFilterServiceImpl.access$getCatalogLinkService$p(this.this$0).isLinked(entry)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 5: {
                        bl = false;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return bl;
            }
        };
    }

    public static final /* synthetic */ StructureService access$getStructureService$p(SCMCatalogFilterServiceImpl $this) {
        return $this.structureService;
    }

    public static final /* synthetic */ CatalogLinkService access$getCatalogLinkService$p(SCMCatalogFilterServiceImpl $this) {
        return $this.catalogLinkService;
    }

    public static final /* synthetic */ void access$incr(SCMCatalogFilterServiceImpl $this, Map results, SCMCatalogProjectFilterLink link) {
        $this.incr(results, link);
    }

    public static final /* synthetic */ SCMCatalog access$getScmCatalog$p(SCMCatalogFilterServiceImpl $this) {
        return $this.scmCatalog;
    }

    public static final /* synthetic */ SecurityService access$getSecurityService$p(SCMCatalogFilterServiceImpl $this) {
        return $this.securityService;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SCMCatalogProjectFilterLink.values().length];
            nArray[SCMCatalogProjectFilterLink.ALL.ordinal()] = 1;
            nArray[SCMCatalogProjectFilterLink.ENTRY.ordinal()] = 2;
            nArray[SCMCatalogProjectFilterLink.LINKED.ordinal()] = 3;
            nArray[SCMCatalogProjectFilterLink.UNLINKED.ordinal()] = 4;
            nArray[SCMCatalogProjectFilterLink.ORPHAN.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

