/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm.catalog;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.common._KTUtilsKt;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalog;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogEntry;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogProvider;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogSource;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.support.ApplicationLogEntry;
import net.nemerosa.ontrack.model.support.ApplicationLogService;
import net.nemerosa.ontrack.model.support.StorageService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0013H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogImpl;", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalog;", "storageService", "Lnet/nemerosa/ontrack/model/support/StorageService;", "scmCatalogProviders", "", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogProvider;", "applicationLogService", "Lnet/nemerosa/ontrack/model/support/ApplicationLogService;", "(Lnet/nemerosa/ontrack/model/support/StorageService;Ljava/util/List;Lnet/nemerosa/ontrack/model/support/ApplicationLogService;)V", "catalogEntries", "Lkotlin/sequences/Sequence;", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogEntry;", "getCatalogEntries", "()Lkotlin/sequences/Sequence;", "collectSCMCatalog", "", "logger", "Lkotlin/Function1;", "", "getCatalogEntry", "key", "ontrack-extension-scm"})
public class SCMCatalogImpl
implements SCMCatalog {
    @NotNull
    private final StorageService storageService;
    @NotNull
    private final List<SCMCatalogProvider> scmCatalogProviders;
    @NotNull
    private final ApplicationLogService applicationLogService;

    public SCMCatalogImpl(@NotNull StorageService storageService, @NotNull List<? extends SCMCatalogProvider> scmCatalogProviders, @NotNull ApplicationLogService applicationLogService) {
        Intrinsics.checkNotNullParameter((Object)storageService, (String)"storageService");
        Intrinsics.checkNotNullParameter(scmCatalogProviders, (String)"scmCatalogProviders");
        Intrinsics.checkNotNullParameter((Object)applicationLogService, (String)"applicationLogService");
        this.storageService = storageService;
        this.scmCatalogProviders = scmCatalogProviders;
        this.applicationLogService = applicationLogService;
    }

    @Override
    public void collectSCMCatalog(@NotNull Function1<? super String, Unit> logger) {
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        Set keys = CollectionsKt.toMutableSet((Iterable)this.storageService.getKeys("scm-catalog"));
        Iterable $this$forEach$iv = this.scmCatalogProviders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list;
            SCMCatalogProvider provider = (SCMCatalogProvider)element$iv;
            boolean bl = false;
            logger.invoke((Object)("Collecting SCM Catalog for " + provider.getId()));
            try {
                list = provider.getEntries();
            }
            catch (Exception ex) {
                this.applicationLogService.log(ApplicationLogEntry.error((Throwable)ex, (NameDescription)NameDescription.Companion.nd("scm-provider-access", "Cannot access SCM provider"), (String)("Cannot get SCM entries from " + provider.getId())).withDetail("provider", provider.getId()));
                list = CollectionsKt.emptyList();
            }
            List entries2 = list;
            Iterable $this$forEach$iv2 = entries2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                SCMCatalogSource source = (SCMCatalogSource)element$iv2;
                boolean bl2 = false;
                logger.invoke((Object)("SCM Catalog entry: " + source));
                SCMCatalogEntry entry = new SCMCatalogEntry(provider.getId(), source.getConfig(), source.getRepository(), source.getRepositoryPage(), source.getLastActivity(), source.getCreatedAt(), Time.now(), source.getTeams());
                this.storageService.store("scm-catalog", entry.getKey(), (Object)entry);
                keys.remove(entry.getKey());
            }
        }
        $this$forEach$iv = keys;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.storageService.delete("scm-catalog", it);
        }
    }

    @Override
    @NotNull
    public Sequence<SCMCatalogEntry> getCatalogEntries() {
        return CollectionsKt.asSequence((Iterable)this.storageService.getData("scm-catalog", SCMCatalogEntry.class).values());
    }

    @Override
    @Nullable
    public SCMCatalogEntry getCatalogEntry(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (SCMCatalogEntry)_KTUtilsKt.getOrNull((Optional)this.storageService.retrieve("scm-catalog", key, SCMCatalogEntry.class));
    }
}

