/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm.catalog.api;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalog;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogEntry;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogTeam;
import net.nemerosa.ontrack.extension.scm.catalog.api.GQLTypeSCMCatalogTeamStats;
import net.nemerosa.ontrack.extension.scm.catalog.api.SCMCatalogTeamStats;
import net.nemerosa.ontrack.graphql.schema.GQLRootQuery;
import net.nemerosa.ontrack.graphql.support.GQLFieldUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Component
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/nemerosa/ontrack/extension/scm/catalog/api/GQLRootQuerySCMCatalogTeamStats;", "Lnet/nemerosa/ontrack/graphql/schema/GQLRootQuery;", "scmCatalog", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalog;", "gqlTypeSCMCatalogTeamStats", "Lnet/nemerosa/ontrack/extension/scm/catalog/api/GQLTypeSCMCatalogTeamStats;", "(Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalog;Lnet/nemerosa/ontrack/extension/scm/catalog/api/GQLTypeSCMCatalogTeamStats;)V", "getFieldDefinition", "Lgraphql/schema/GraphQLFieldDefinition;", "ontrack-extension-scm"})
public class GQLRootQuerySCMCatalogTeamStats
implements GQLRootQuery {
    @NotNull
    private final SCMCatalog scmCatalog;
    @NotNull
    private final GQLTypeSCMCatalogTeamStats gqlTypeSCMCatalogTeamStats;

    public GQLRootQuerySCMCatalogTeamStats(@NotNull SCMCatalog scmCatalog, @NotNull GQLTypeSCMCatalogTeamStats gqlTypeSCMCatalogTeamStats) {
        Intrinsics.checkNotNullParameter((Object)scmCatalog, (String)"scmCatalog");
        Intrinsics.checkNotNullParameter((Object)gqlTypeSCMCatalogTeamStats, (String)"gqlTypeSCMCatalogTeamStats");
        this.scmCatalog = scmCatalog;
        this.gqlTypeSCMCatalogTeamStats = gqlTypeSCMCatalogTeamStats;
    }

    @NotNull
    public GraphQLFieldDefinition getFieldDefinition() {
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition().name("scmCatalogTeamStats").description("Counts of SCM catalog entries having N teams");
        GraphQLTypeReference graphQLTypeReference = this.gqlTypeSCMCatalogTeamStats.getTypeRef();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLTypeReference, (String)"gqlTypeSCMCatalogTeamStats.typeRef");
        GraphQLFieldDefinition graphQLFieldDefinition = builder.type(GQLFieldUtilsKt.listType$default((GraphQLOutputType)((GraphQLOutputType)graphQLTypeReference), (boolean)false, (boolean)false, (int)6, null)).dataFetcher(arg_0 -> GQLRootQuerySCMCatalogTeamStats.getFieldDefinition$lambda-3(this, arg_0)).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLFieldDefinition, (String)"newFieldDefinition()\n   \u2026       }\n        .build()");
        return graphQLFieldDefinition;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object getFieldDefinition$lambda-3(GQLRootQuerySCMCatalogTeamStats this$0, DataFetchingEnvironment it) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map teamCounts = new LinkedHashMap();
        Sequence<SCMCatalogEntry> $this$forEach$iv = this$0.scmCatalog.getCatalogEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Integer n;
            SCMCatalogEntry entry = (SCMCatalogEntry)element$iv;
            boolean bl = false;
            List<SCMCatalogTeam> list = entry.getTeams();
            int teamCount = list != null ? list.size() : 0;
            Integer currentCount = (Integer)teamCounts.get(teamCount);
            if (currentCount != null) {
                n = teamCount;
                teamCounts.put(n, currentCount + 1);
                continue;
            }
            n = teamCount;
            teamCounts.put(n, 1);
        }
        Map $this$map$iv = teamCounts;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int teamCount = ((Number)entry.getKey()).intValue();
            int entryCount = ((Number)entry.getValue()).intValue();
            collection.add(new SCMCatalogTeamStats(teamCount, entryCount));
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SCMCatalogTeamStats it = (SCMCatalogTeamStats)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getTeamCount());
                it = (SCMCatalogTeamStats)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getTeamCount()));
            }
        });
    }
}

