/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm.catalog.search;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import net.nemerosa.ontrack.extension.scm.SCMExtensionFeature;
import net.nemerosa.ontrack.extension.scm.catalog.CatalogLinkService;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalog;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogEntry;
import net.nemerosa.ontrack.extension.scm.catalog.search.SCMCatalogSearchIndexer;
import net.nemerosa.ontrack.extension.scm.catalog.search.SCMCatalogSearchItem;
import net.nemerosa.ontrack.extension.scm.catalog.ui.SCMCatalogController;
import net.nemerosa.ontrack.job.Schedule;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.SearchIndexMapping;
import net.nemerosa.ontrack.model.structure.SearchIndexMappingExtensionsKt;
import net.nemerosa.ontrack.model.structure.SearchIndexer;
import net.nemerosa.ontrack.model.structure.SearchResult;
import net.nemerosa.ontrack.model.structure.SearchResultType;
import net.nemerosa.ontrack.ui.controller.EntityURIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@Component
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\"0$H\u0016J\"\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001cR\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lnet/nemerosa/ontrack/extension/scm/catalog/search/SCMCatalogSearchIndexer;", "Lnet/nemerosa/ontrack/model/structure/SearchIndexer;", "Lnet/nemerosa/ontrack/extension/scm/catalog/search/SCMCatalogSearchItem;", "extensionFeature", "Lnet/nemerosa/ontrack/extension/scm/SCMExtensionFeature;", "scmCatalog", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalog;", "catalogLinkService", "Lnet/nemerosa/ontrack/extension/scm/catalog/CatalogLinkService;", "uriBuilder", "Lnet/nemerosa/ontrack/ui/controller/EntityURIBuilder;", "(Lnet/nemerosa/ontrack/extension/scm/SCMExtensionFeature;Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalog;Lnet/nemerosa/ontrack/extension/scm/catalog/CatalogLinkService;Lnet/nemerosa/ontrack/ui/controller/EntityURIBuilder;)V", "indexMapping", "Lnet/nemerosa/ontrack/model/structure/SearchIndexMapping;", "getIndexMapping", "()Lnet/nemerosa/ontrack/model/structure/SearchIndexMapping;", "indexName", "", "getIndexName", "()Ljava/lang/String;", "indexerName", "getIndexerName", "indexerSchedule", "Lnet/nemerosa/ontrack/job/Schedule;", "getIndexerSchedule", "()Lnet/nemerosa/ontrack/job/Schedule;", "isIndexationDisabled", "", "()Z", "searchResultType", "Lnet/nemerosa/ontrack/model/structure/SearchResultType;", "getSearchResultType", "()Lnet/nemerosa/ontrack/model/structure/SearchResultType;", "indexAll", "", "processor", "Lkotlin/Function1;", "toSearchResult", "Lnet/nemerosa/ontrack/model/structure/SearchResult;", "id", "score", "", "source", "Lcom/fasterxml/jackson/databind/JsonNode;", "ontrack-extension-scm"})
public class SCMCatalogSearchIndexer
implements SearchIndexer<SCMCatalogSearchItem> {
    @NotNull
    private final SCMCatalog scmCatalog;
    @NotNull
    private final CatalogLinkService catalogLinkService;
    @NotNull
    private final EntityURIBuilder uriBuilder;
    @NotNull
    private final String indexerName;
    @NotNull
    private final String indexName;
    @NotNull
    private final SearchResultType searchResultType;
    private final boolean isIndexationDisabled;
    @NotNull
    private final Schedule indexerSchedule;
    @NotNull
    private final SearchIndexMapping indexMapping;

    public SCMCatalogSearchIndexer(@NotNull SCMExtensionFeature extensionFeature, @NotNull SCMCatalog scmCatalog, @NotNull CatalogLinkService catalogLinkService, @NotNull EntityURIBuilder uriBuilder) {
        Intrinsics.checkNotNullParameter((Object)((Object)extensionFeature), (String)"extensionFeature");
        Intrinsics.checkNotNullParameter((Object)scmCatalog, (String)"scmCatalog");
        Intrinsics.checkNotNullParameter((Object)catalogLinkService, (String)"catalogLinkService");
        Intrinsics.checkNotNullParameter((Object)uriBuilder, (String)"uriBuilder");
        this.scmCatalog = scmCatalog;
        this.catalogLinkService = catalogLinkService;
        this.uriBuilder = uriBuilder;
        this.indexerName = "SCM Catalog";
        this.indexName = "scm-catalog";
        this.searchResultType = new SearchResultType(extensionFeature.getFeatureDescription(), "scm-catalog", "SCM Catalog", "Indexed SCM repository, which might be associated or not with an Ontrack project");
        this.indexerSchedule = Schedule.EVERY_WEEK;
        this.indexMapping = SearchIndexMappingExtensionsKt.indexMappings((Function1)indexMapping.1.INSTANCE);
    }

    @NotNull
    public String getIndexerName() {
        return this.indexerName;
    }

    @NotNull
    public String getIndexName() {
        return this.indexName;
    }

    @NotNull
    public SearchResultType getSearchResultType() {
        return this.searchResultType;
    }

    public void indexAll(@NotNull Function1<? super SCMCatalogSearchItem, Unit> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Sequence<SCMCatalogEntry> $this$forEach$iv = this.scmCatalog.getCatalogEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SCMCatalogEntry entry = (SCMCatalogEntry)element$iv;
            boolean bl = false;
            SCMCatalogSearchItem item = new SCMCatalogSearchItem(entry);
            processor.invoke((Object)item);
        }
    }

    @Nullable
    public SearchResult toSearchResult(@NotNull String id, double score, @NotNull JsonNode source) {
        SearchResult searchResult;
        SCMCatalogEntry entry;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        SCMCatalogEntry sCMCatalogEntry = entry = this.scmCatalog.getCatalogEntry(id);
        if (sCMCatalogEntry != null) {
            SCMCatalogEntry it = sCMCatalogEntry;
            boolean bl = false;
            Project project = this.catalogLinkService.getLinkedProject(entry);
            Object title = null;
            String description = null;
            URI uri = null;
            URI page = null;
            if (project != null) {
                title = project.getName() + " (" + entry.getRepository() + ")";
                description = "Project " + project.getName() + " associated with SCM " + entry.getRepository() + " (" + entry.getScm() + " @ " + entry.getConfig() + ")";
                URI uRI = this.uriBuilder.getEntityURI((ProjectEntity)project);
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"uriBuilder.getEntityURI(project)");
                uri = uRI;
                URI uRI2 = this.uriBuilder.getEntityPage((ProjectEntity)project);
                Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"uriBuilder.getEntityPage(project)");
                page = uRI2;
            } else {
                title = entry.getRepository();
                description = "SCM " + entry.getRepository() + " (" + entry.getScm() + " @ " + entry.getConfig() + ") not associated with any project";
                URI uRI = this.uriBuilder.build(((SCMCatalogController)((Object)MvcUriComponentsBuilder.on(SCMCatalogController.class))).entries());
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"uriBuilder.build(MvcUriC\u2026r::class.java).entries())");
                uri = uRI;
                URI uRI3 = this.uriBuilder.page("extension/scm/scm-catalog", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)uRI3, (String)"uriBuilder.page(\"extension/scm/scm-catalog\")");
                page = uRI3;
            }
            searchResult = new SearchResult((String)title, description, uri, page, score, this.getSearchResultType(), null, 64, null);
        } else {
            searchResult = null;
        }
        return searchResult;
    }

    public boolean isIndexationDisabled() {
        return this.isIndexationDisabled;
    }

    @NotNull
    public Schedule getIndexerSchedule() {
        return this.indexerSchedule;
    }

    @NotNull
    public SearchIndexMapping getIndexMapping() {
        return this.indexMapping;
    }

    @Nullable
    public Integer getIndexBatch() {
        return SearchIndexer.DefaultImpls.getIndexBatch((SearchIndexer)this);
    }

    @NotNull
    public String getIndexerId() {
        return SearchIndexer.DefaultImpls.getIndexerId((SearchIndexer)this);
    }
}

