/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm.catalog.sync;

import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.nemerosa.ontrack.common._KTUtilsKt;
import net.nemerosa.ontrack.extension.scm.catalog.CatalogLinkService;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogEntryOrProject;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogFilterService;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogProjectFilter;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogProjectFilterLink;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogProjectFilterSort;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogProvider;
import net.nemerosa.ontrack.extension.scm.catalog.sync.SCMCatalogImportService;
import net.nemerosa.ontrack.extension.scm.catalog.sync.SCMCatalogSyncSettings;
import net.nemerosa.ontrack.model.settings.CachedSettingsService;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00120\u0016H\u0012J\u001c\u0010\u0017\u001a\u00020\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00120\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\f0\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/nemerosa/ontrack/extension/scm/catalog/sync/SCMCatalogImportServiceImpl;", "Lnet/nemerosa/ontrack/extension/scm/catalog/sync/SCMCatalogImportService;", "cachedSettingsService", "Lnet/nemerosa/ontrack/model/settings/CachedSettingsService;", "scmCatalogFilterService", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogFilterService;", "structureService", "Lnet/nemerosa/ontrack/model/structure/StructureService;", "catalogLinkService", "Lnet/nemerosa/ontrack/extension/scm/catalog/CatalogLinkService;", "scmCatalogProviders", "", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogProvider;", "(Lnet/nemerosa/ontrack/model/settings/CachedSettingsService;Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogFilterService;Lnet/nemerosa/ontrack/model/structure/StructureService;Lnet/nemerosa/ontrack/extension/scm/catalog/CatalogLinkService;Ljava/util/List;)V", "scmCatalogProvidersIndex", "", "", "createProject", "", "item", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogEntryOrProject;", "logger", "Lkotlin/Function1;", "importCatalog", "ontrack-extension-scm"})
public class SCMCatalogImportServiceImpl
implements SCMCatalogImportService {
    @NotNull
    private final CachedSettingsService cachedSettingsService;
    @NotNull
    private final SCMCatalogFilterService scmCatalogFilterService;
    @NotNull
    private final StructureService structureService;
    @NotNull
    private final CatalogLinkService catalogLinkService;
    @NotNull
    private final Map<String, SCMCatalogProvider> scmCatalogProvidersIndex;

    /*
     * WARNING - void declaration
     */
    public SCMCatalogImportServiceImpl(@NotNull CachedSettingsService cachedSettingsService, @NotNull SCMCatalogFilterService scmCatalogFilterService, @NotNull StructureService structureService, @NotNull CatalogLinkService catalogLinkService, @NotNull List<? extends SCMCatalogProvider> scmCatalogProviders) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)cachedSettingsService, (String)"cachedSettingsService");
        Intrinsics.checkNotNullParameter((Object)scmCatalogFilterService, (String)"scmCatalogFilterService");
        Intrinsics.checkNotNullParameter((Object)structureService, (String)"structureService");
        Intrinsics.checkNotNullParameter((Object)catalogLinkService, (String)"catalogLinkService");
        Intrinsics.checkNotNullParameter(scmCatalogProviders, (String)"scmCatalogProviders");
        this.cachedSettingsService = cachedSettingsService;
        this.scmCatalogFilterService = scmCatalogFilterService;
        this.structureService = structureService;
        this.catalogLinkService = catalogLinkService;
        Iterable iterable = scmCatalogProviders;
        SCMCatalogImportServiceImpl sCMCatalogImportServiceImpl = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var9_10 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            SCMCatalogProvider sCMCatalogProvider = (SCMCatalogProvider)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv);
        }
        sCMCatalogImportServiceImpl.scmCatalogProvidersIndex = destination$iv$iv;
    }

    @Override
    public void importCatalog(@NotNull Function1<? super String, Unit> logger) {
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        SCMCatalogSyncSettings settings = (SCMCatalogSyncSettings)this.cachedSettingsService.getCachedSettings(SCMCatalogSyncSettings.class);
        if (settings.getSyncEnabled()) {
            String string;
            String string2;
            String string3;
            String it;
            int n;
            int n2;
            String string4;
            int n3 = 0;
            int n4 = Integer.MAX_VALUE;
            String string5 = settings.getScm();
            if (string5 != null) {
                String string6 = string4 = string5;
                n2 = n4;
                n = n3;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                n3 = n;
                n4 = n2;
                string3 = bl2 ? string4 : null;
            } else {
                string3 = null;
            }
            String string7 = settings.getConfig();
            if (string7 != null) {
                it = string4 = string7;
                String string8 = string3;
                n2 = n4;
                n = n3;
                boolean bl = false;
                boolean bl3 = !StringsKt.isBlank((CharSequence)it);
                n3 = n;
                n4 = n2;
                string3 = string8;
                string2 = bl3 ? string4 : null;
            } else {
                string2 = null;
            }
            String string9 = settings.getRepository();
            if (string9 != null) {
                it = string4 = string9;
                String string10 = string2;
                String string11 = string3;
                n2 = n4;
                n = n3;
                boolean bl = false;
                boolean bl4 = !StringsKt.isBlank((CharSequence)it);
                n3 = n;
                n4 = n2;
                string3 = string11;
                string2 = string10;
                string = bl4 ? string4 : null;
            } else {
                string = null;
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n5 = 16289;
            boolean bl = false;
            SCMCatalogProjectFilterSort sCMCatalogProjectFilterSort = null;
            String string12 = null;
            LocalDate localDate = null;
            LocalDate localDate2 = null;
            LocalDate localDate3 = null;
            LocalDate localDate4 = null;
            SCMCatalogProjectFilterLink sCMCatalogProjectFilterLink = SCMCatalogProjectFilterLink.UNLINKED;
            String string13 = null;
            String string14 = string;
            String string15 = string2;
            String string16 = string3;
            int n6 = n4;
            int n7 = n3;
            SCMCatalogProjectFilter filter = new SCMCatalogProjectFilter(n7, n6, string16, string15, string14, string13, sCMCatalogProjectFilterLink, localDate4, localDate3, localDate2, localDate, string12, sCMCatalogProjectFilterSort, bl, n5, defaultConstructorMarker);
            logger.invoke((Object)"Getting the list of unlinked SCM catalog entries");
            List<SCMCatalogEntryOrProject> items = this.scmCatalogFilterService.findCatalogProjectEntries(filter);
            logger.invoke((Object)"Count of unlinked SCM catalog entries: $");
            Iterable $this$forEach$iv = items;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SCMCatalogEntryOrProject it2 = (SCMCatalogEntryOrProject)element$iv;
                boolean bl5 = false;
                this.createProject(it2, logger);
            }
        }
    }

    private void createProject(SCMCatalogEntryOrProject item, Function1<? super String, Unit> logger) {
        String name;
        Project project;
        SCMCatalogProvider provider;
        if (item.getProject() == null && item.getEntry() != null && (provider = this.scmCatalogProvidersIndex.get(item.getEntry().getScm())) != null && (project = (Project)_KTUtilsKt.getOrNull((Optional)this.structureService.findProjectByName(name = provider.toProjectName(item.getEntry().getRepository())))) == null) {
            if (name.length() > 80) {
                logger.invoke((Object)("Cannot import " + name + " project because its length is > 80"));
            } else {
                String description = "This project was automatically created from the SCM entry " + item.getEntry().getScm() + "/" + item.getEntry().getConfig() + "/" + item.getEntry().getRepository();
                Project createdProject = this.structureService.newProject(Project.Companion.of(NameDescription.Companion.nd(name, description)));
                provider.linkProjectToSCM(createdProject, item.getEntry());
                this.catalogLinkService.storeLink(createdProject, item.getEntry());
                logger.invoke((Object)("Created project " + name + " (id = " + createdProject.getId() + ") from SCM catalog"));
            }
        }
    }
}

