/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm.catalog.ui;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import net.nemerosa.ontrack.common.Document;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalog;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogEntry;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogExportService;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"extension/scm/catalog"})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/nemerosa/ontrack/extension/scm/catalog/ui/SCMCatalogController;", "Lnet/nemerosa/ontrack/ui/controller/AbstractResourceController;", "scmCatalog", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalog;", "scmCatalogExportService", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogExportService;", "(Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalog;Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogExportService;)V", "entries", "Lnet/nemerosa/ontrack/ui/resource/Resources;", "Lnet/nemerosa/ontrack/extension/scm/catalog/SCMCatalogEntry;", "exportAsCsv", "Lnet/nemerosa/ontrack/common/Document;", "response", "Ljavax/servlet/http/HttpServletResponse;", "ontrack-extension-scm"})
public class SCMCatalogController
extends AbstractResourceController {
    @NotNull
    private final SCMCatalog scmCatalog;
    @NotNull
    private final SCMCatalogExportService scmCatalogExportService;

    public SCMCatalogController(@NotNull SCMCatalog scmCatalog, @NotNull SCMCatalogExportService scmCatalogExportService) {
        Intrinsics.checkNotNullParameter((Object)scmCatalog, (String)"scmCatalog");
        Intrinsics.checkNotNullParameter((Object)scmCatalogExportService, (String)"scmCatalogExportService");
        this.scmCatalog = scmCatalog;
        this.scmCatalogExportService = scmCatalogExportService;
    }

    @GetMapping(value={"entries"})
    @NotNull
    public Resources<SCMCatalogEntry> entries() {
        Resources resources = Resources.of((Collection)SequencesKt.toList(this.scmCatalog.getCatalogEntries()), (URI)this.uri(((SCMCatalogController)((Object)MvcUriComponentsBuilder.on(SCMCatalogController.class))).entries()));
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"of(\n                    \u2026.entries())\n            )");
        return resources;
    }

    @GetMapping(value={"export/csv"})
    @NotNull
    public Document exportAsCsv(@NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        List entries2 = SequencesKt.toList(this.scmCatalog.getCatalogEntries());
        response.addHeader("Content-Disposition", "attachment; filename=ontrack-scm-catalog.csv");
        return this.scmCatalogExportService.exportCatalogAsCSV(entries2);
    }
}

