/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm.catalog.ui;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.extension.scm.catalog.CatalogLinkService;
import net.nemerosa.ontrack.extension.scm.catalog.SCMCatalogEntry;
import net.nemerosa.ontrack.model.labels.LabelForm;
import net.nemerosa.ontrack.model.labels.LabelProvider;
import net.nemerosa.ontrack.model.structure.Project;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lnet/nemerosa/ontrack/extension/scm/catalog/ui/SCMCatalogEntryLabelProvider;", "Lnet/nemerosa/ontrack/model/labels/LabelProvider;", "catalogLinkService", "Lnet/nemerosa/ontrack/extension/scm/catalog/CatalogLinkService;", "(Lnet/nemerosa/ontrack/extension/scm/catalog/CatalogLinkService;)V", "isEnabled", "", "()Z", "name", "", "getName", "()Ljava/lang/String;", "getLabelsForProject", "", "Lnet/nemerosa/ontrack/model/labels/LabelForm;", "project", "Lnet/nemerosa/ontrack/model/structure/Project;", "Companion", "ontrack-extension-scm"})
public class SCMCatalogEntryLabelProvider
implements LabelProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CatalogLinkService catalogLinkService;
    @NotNull
    private final String name;
    private final boolean isEnabled;
    @NotNull
    public static final String LABEL_CATEGORY = "scm-catalog";
    @NotNull
    public static final String LABEL_NAME_ENTRY = "entry";
    @NotNull
    public static final String LABEL_NAME_NO_ENTRY = "no-entry";

    public SCMCatalogEntryLabelProvider(@NotNull CatalogLinkService catalogLinkService) {
        Intrinsics.checkNotNullParameter((Object)catalogLinkService, (String)"catalogLinkService");
        this.catalogLinkService = catalogLinkService;
        this.name = "SCM Catalog Entry";
        this.isEnabled = true;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @NotNull
    public List<LabelForm> getLabelsForProject(@NotNull Project project) {
        LabelForm labelForm;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SCMCatalogEntry sCMCatalogEntry = this.catalogLinkService.getSCMCatalogEntry(project);
        if (sCMCatalogEntry != null) {
            SCMCatalogEntry $this$getLabelsForProject_u24lambda_u2d0 = sCMCatalogEntry;
            boolean bl = false;
            labelForm = new LabelForm(LABEL_CATEGORY, LABEL_NAME_ENTRY, "This project is associated with a SCM catalog entry", "#33cc33");
        } else {
            labelForm = new LabelForm(LABEL_CATEGORY, LABEL_NAME_NO_ENTRY, "This project is NOT associated with a SCM catalog entry", "#a9a9a9");
        }
        return CollectionsKt.listOf((Object)labelForm);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/nemerosa/ontrack/extension/scm/catalog/ui/SCMCatalogEntryLabelProvider$Companion;", "", "()V", "LABEL_CATEGORY", "", "LABEL_NAME_ENTRY", "LABEL_NAME_NO_ENTRY", "ontrack-extension-scm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

