/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm.indicator;

import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.nemerosa.ontrack.common._KTUtilsKt;
import net.nemerosa.ontrack.extension.indicators.computing.ConfigurableIndicatorType;
import net.nemerosa.ontrack.extension.indicators.computing.IndicatorComputedValue;
import net.nemerosa.ontrack.extension.indicators.computing.IndicatorComputer;
import net.nemerosa.ontrack.extension.scm.service.SCMService;
import net.nemerosa.ontrack.extension.scm.service.SCMServiceDetector;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.job.Schedule;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J.\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H&J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lnet/nemerosa/ontrack/extension/scm/indicator/AbstractSCMIndicatorComputer;", "Lnet/nemerosa/ontrack/extension/support/AbstractExtension;", "Lnet/nemerosa/ontrack/extension/indicators/computing/IndicatorComputer;", "extension", "Lnet/nemerosa/ontrack/model/extension/ExtensionFeature;", "scmServiceDetector", "Lnet/nemerosa/ontrack/extension/scm/service/SCMServiceDetector;", "(Lnet/nemerosa/ontrack/model/extension/ExtensionFeature;Lnet/nemerosa/ontrack/extension/scm/service/SCMServiceDetector;)V", "perProject", "", "getPerProject", "()Z", "getScmServiceDetector", "()Lnet/nemerosa/ontrack/extension/scm/service/SCMServiceDetector;", "computeIndicators", "", "Lnet/nemerosa/ontrack/extension/indicators/computing/IndicatorComputedValue;", "project", "Lnet/nemerosa/ontrack/model/structure/Project;", "computeSCMIndicators", "scmService", "Lnet/nemerosa/ontrack/extension/scm/service/SCMService;", "scmBranch", "", "isProjectEligible", "ontrack-extension-scm"})
public abstract class AbstractSCMIndicatorComputer
extends AbstractExtension
implements IndicatorComputer {
    @NotNull
    private final SCMServiceDetector scmServiceDetector;
    private final boolean perProject;

    public AbstractSCMIndicatorComputer(@NotNull ExtensionFeature extension, @NotNull SCMServiceDetector scmServiceDetector) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)scmServiceDetector, (String)"scmServiceDetector");
        super(extension);
        this.scmServiceDetector = scmServiceDetector;
        this.perProject = true;
    }

    @NotNull
    protected final SCMServiceDetector getScmServiceDetector() {
        return this.scmServiceDetector;
    }

    public boolean getPerProject() {
        return this.perProject;
    }

    public boolean isProjectEligible(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Optional<SCMService> optional = this.scmServiceDetector.getScmService(project);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"scmServiceDetector.getScmService(project)");
        SCMService sCMService = (SCMService)_KTUtilsKt.getOrNull(optional);
        if (sCMService == null) {
            return false;
        }
        SCMService scmService = sCMService;
        String scmBranch = scmService.getSCMDefaultBranch(project);
        CharSequence charSequence = scmBranch;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    @NotNull
    public List<IndicatorComputedValue<?, ?>> computeIndicators(@NotNull Project project) {
        SCMService scmService;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Optional<SCMService> optional = this.scmServiceDetector.getScmService(project);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"scmServiceDetector.getScmService(project)");
        SCMService sCMService = scmService = (SCMService)_KTUtilsKt.getOrNull(optional);
        String scmBranch = sCMService != null ? sCMService.getSCMDefaultBranch(project) : null;
        return scmService != null && scmBranch != null ? this.computeSCMIndicators(project, scmService, scmBranch) : CollectionsKt.emptyList();
    }

    @NotNull
    public abstract List<IndicatorComputedValue<?, ?>> computeSCMIndicators(@NotNull Project var1, @NotNull SCMService var2, @NotNull String var3);

    @NotNull
    public List<ConfigurableIndicatorType<?, ?>> getConfigurableIndicators() {
        return IndicatorComputer.DefaultImpls.getConfigurableIndicators((IndicatorComputer)this);
    }

    @NotNull
    public Schedule getSchedule() {
        return IndicatorComputer.DefaultImpls.getSchedule((IndicatorComputer)this);
    }
}

