/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm.service;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.scm.model.SCMChangeLogFile;
import net.nemerosa.ontrack.extension.scm.model.SCMIssueCommitBranchInfo;
import net.nemerosa.ontrack.extension.scm.service.SCMUtilsService;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.BuildView;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCMUtilsServiceImpl
implements SCMUtilsService {
    private final StructureService structureService;

    @Autowired
    public SCMUtilsServiceImpl(StructureService structureService) {
        this.structureService = structureService;
    }

    @Override
    public <T extends SCMChangeLogFile> String diff(List<T> changeLogFiles, List<String> patterns, Function<T, String> diffFn) {
        Predicate<String> pathFilter = this.getPathFilter(patterns);
        return changeLogFiles.stream().filter(changeLogFile -> pathFilter.test(changeLogFile.getPath())).map(diffFn).collect(Collectors.joining("\n"));
    }

    @Override
    public Predicate<String> getPathFilter(List<String> patterns) {
        if (patterns == null || patterns.isEmpty()) {
            return path -> true;
        }
        return path -> patterns.stream().map(pattern -> Pattern.compile("^" + pattern.replace("**", "$MULTI$").replace("*", "$SINGLE$").replace("$SINGLE$", "[^\\/]+").replace("$MULTI$", ".*") + "$")).anyMatch(pattern -> pattern.matcher((CharSequence)path).matches());
    }

    @Override
    public SCMIssueCommitBranchInfo getBranchInfo(@Nullable Build buildAfterCommit, SCMIssueCommitBranchInfo branchInfo) {
        SCMIssueCommitBranchInfo info = branchInfo;
        if (buildAfterCommit != null) {
            BuildView buildView = this.structureService.getBuildView(buildAfterCommit, true);
            info = info.withBuildView(buildView);
            info = info.withBranchStatusView(this.structureService.getEarliestPromotionsAfterBuild(buildAfterCommit));
        }
        return info;
    }
}

