/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm.support;

import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class TagPattern {
    private final String pattern;

    public TagPattern clone(Function<String, String> replacementFunction) {
        return new TagPattern(replacementFunction.apply(this.pattern));
    }

    public boolean isValidTagName(String name) {
        return StringUtils.isBlank((CharSequence)this.pattern) || this.createRegex().matcher(name).matches();
    }

    public Optional<String> getBuildNameFromTagName(String tagName) {
        if (StringUtils.isBlank((CharSequence)this.pattern)) {
            return Optional.of(tagName);
        }
        Matcher matcher = this.createRegex().matcher(tagName);
        if (matcher.matches()) {
            if (matcher.groupCount() > 0) {
                return Optional.of(matcher.group(1));
            }
            return Optional.of(matcher.group(0));
        }
        return Optional.empty();
    }

    public Optional<String> getTagNameFromBuildName(String buildName) {
        if (StringUtils.isBlank((CharSequence)this.pattern)) {
            return Optional.of(buildName);
        }
        String buildPartRegex = "\\((.*\\*/*)\\)";
        Pattern buildPartPattern = Pattern.compile(buildPartRegex);
        Matcher buildPartMatcher = buildPartPattern.matcher(this.pattern);
        if (buildPartMatcher.find()) {
            String buildPart = buildPartMatcher.group(1);
            if (Pattern.matches(buildPart, buildName)) {
                StringBuffer tag = new StringBuffer();
                do {
                    buildPartMatcher.appendReplacement(tag, buildName);
                } while (buildPartMatcher.find());
                buildPartMatcher.appendTail(tag);
                return Optional.of(tag.toString());
            }
            return Optional.empty();
        }
        if (this.createRegex().matcher(buildName).matches()) {
            return Optional.of(buildName);
        }
        return Optional.empty();
    }

    private Pattern createRegex() {
        return Pattern.compile(StringUtils.replace((String)this.pattern, (String)"*", (String)".*"));
    }

    @ConstructorProperties(value={"pattern"})
    public TagPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TagPattern)) {
            return false;
        }
        TagPattern other = (TagPattern)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TagPattern;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        return result;
    }

    public String toString() {
        return "TagPattern(pattern=" + this.getPattern() + ")";
    }
}

