/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.migration.postgresql;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.migration.postgresql.Migration;
import net.nemerosa.ontrack.migration.postgresql.MigrationProperties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Component
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001:\u0001/B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0012J)\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0016\"\u00020\u0014H\u0012\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0011H\u0012J\b\u0010\u0019\u001a\u00020\u0011H\u0012J\b\u0010\u001a\u001a\u00020\u0011H\u0012J\b\u0010\u001b\u001a\u00020\u0011H\u0012J\b\u0010\u001c\u001a\u00020\u0011H\u0012J1\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0016\"\u00020\u0014H\u0012\u00a2\u0006\u0002\u0010\u001fJ!\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#H\u0012\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u0011H\u0016J4\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u00142\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00010*2\u0006\u0010+\u001a\u00020\u0014H\u0012J\u0016\u0010,\u001a\u00020\u00112\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110#H\u0012J\b\u0010.\u001a\u00020\u0011H\u0012R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lnet/nemerosa/ontrack/migration/postgresql/Migration;", "", "h2Datasource", "Ljavax/sql/DataSource;", "postgresqlDatasource", "migrationProperties", "Lnet/nemerosa/ontrack/migration/postgresql/MigrationProperties;", "(Ljavax/sql/DataSource;Ljavax/sql/DataSource;Lnet/nemerosa/ontrack/migration/postgresql/MigrationProperties;)V", "h2", "Lorg/springframework/jdbc/core/namedparam/NamedParameterJdbcTemplate;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "postgresql", "txTemplate", "Lorg/springframework/transaction/support/TransactionTemplate;", "cleanup", "", "copy", "table", "", "columns", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "copyEntityData", "copyEntityDataStore", "copyEntityDataStoreAudit", "copyEvents", "copyProperties", "copyWithTmp", "tmpCreation", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "intx", "T", "supplier", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "run", "simpleMigration", "name", "h2Query", "h2Params", "", "postgresqlUpdate", "tx", "task", "updateSequences", "ColumnMigration", "ontrack-postgresql-migration"})
public class Migration {
    private final Logger logger;
    private final NamedParameterJdbcTemplate h2;
    private final NamedParameterJdbcTemplate postgresql;
    private final TransactionTemplate txTemplate;
    private final MigrationProperties migrationProperties;

    public void run() {
        if (this.migrationProperties.isCleanup()) {
            this.cleanup();
        }
        this.copy("CONFIGURATIONS", new String[]{"ID", "TYPE", "NAME", "CONTENT::JSONB"});
        this.copy("SETTINGS", new String[]{"CATEGORY", "NAME", "VALUE"});
        this.copy("PREDEFINED_PROMOTION_LEVELS", new String[]{"ID", "ORDERNB", "NAME", "DESCRIPTION", "IMAGETYPE", "IMAGEBYTES"});
        this.copy("PREDEFINED_VALIDATION_STAMPS", new String[]{"ID", "NAME", "DESCRIPTION", "IMAGETYPE", "IMAGEBYTES"});
        this.copy("STORAGE", new String[]{"STORE", "NAME", "DATA::JSONB"});
        this.copy("PROJECTS", new String[]{"ID", "NAME", "DESCRIPTION", "DISABLED", "CREATION", "CREATOR"});
        this.copy("BRANCHES", new String[]{"ID", "PROJECTID", "NAME", "DESCRIPTION", "DISABLED", "CREATION", "CREATOR"});
        this.copy("PROMOTION_LEVELS", new String[]{"ID", "BRANCHID", "ORDERNB", "NAME", "DESCRIPTION", "IMAGETYPE", "IMAGEBYTES", "CREATION", "CREATOR"});
        this.copy("VALIDATION_STAMPS", new String[]{"ID", "BRANCHID", "OWNER", "PROMOTION_LEVEL", "ORDERNB", "NAME", "DESCRIPTION", "IMAGETYPE", "IMAGEBYTES", "CREATION", "CREATOR"});
        this.copy("BUILDS", new String[]{"ID", "BRANCHID", "NAME", "DESCRIPTION", "CREATION", "CREATOR"});
        this.copy("PROMOTION_RUNS", new String[]{"ID", "BUILDID", "PROMOTIONLEVELID", "CREATION", "CREATOR", "DESCRIPTION"});
        this.copy("VALIDATION_RUNS", new String[]{"ID", "BUILDID", "VALIDATIONSTAMPID"});
        this.copy("VALIDATION_RUN_STATUSES", new String[]{"ID", "VALIDATIONRUNID", "VALIDATIONRUNSTATUSID", "CREATION", "CREATOR", "DESCRIPTION"});
        this.copy("BRANCH_TEMPLATE_DEFINITIONS", new String[]{"BRANCHID", "ABSENCEPOLICY", "SYNCINTERVAL", "SYNCHRONISATIONSOURCEID", "SYNCHRONISATIONSOURCECONFIG::JSONB"});
        this.copy("BRANCH_TEMPLATE_DEFINITION_PARAMS", new String[]{"BRANCHID", "NAME", "DESCRIPTION", "EXPRESSION"});
        this.copy("BRANCH_TEMPLATE_INSTANCES", new String[]{"BRANCHID", "TEMPLATEBRANCHID"});
        this.copy("BRANCH_TEMPLATE_INSTANCE_PARAMS", new String[]{"BRANCHID", "NAME", "VALUE"});
        this.copyEntityData();
        this.copyEntityDataStore();
        this.copyEntityDataStoreAudit();
        this.copyProperties();
        this.copy("SHARED_BUILD_FILTERS", new String[]{"BRANCHID", "NAME", "TYPE", "DATA::JSONB"});
        this.copy("VALIDATION_STAMP_FILTERS", new String[]{"ID", "NAME", "PROJECT", "BRANCH", "VSNAMES"});
        this.copy("BUILD_LINKS", new String[]{"ID", "BUILDID", "TARGETBUILDID"});
        if (this.migrationProperties.isSkipEvents()) {
            this.logger.warn("Skipping events migration");
        } else {
            this.copyEvents();
        }
        this.copy("ACCOUNTS", new String[]{"ID", "NAME", "FULLNAME", "EMAIL", "MODE", "PASSWORD", "ROLE"});
        this.copy("ACCOUNT_GROUPS", new String[]{"ID", "NAME", "DESCRIPTION"});
        this.copy("ACCOUNT_GROUP_LINK", new String[]{"ACCOUNT", "ACCOUNTGROUP"});
        this.copy("ACCOUNT_GROUP_MAPPING", new String[]{"ID", "GROUPID", "MAPPING", "SOURCE"});
        this.copy("GLOBAL_AUTHORIZATIONS", new String[]{"ACCOUNT", "ROLE"});
        this.copy("GROUP_GLOBAL_AUTHORIZATIONS", new String[]{"ACCOUNTGROUP", "ROLE"});
        this.copy("GROUP_PROJECT_AUTHORIZATIONS", new String[]{"ACCOUNTGROUP", "PROJECT", "ROLE"});
        this.copy("PROJECT_AUTHORIZATIONS", new String[]{"ACCOUNT", "PROJECT", "ROLE"});
        this.copy("PREFERENCES", new String[]{"ACCOUNTID", "TYPE", "CONTENT"});
        this.copy("BUILD_FILTERS", new String[]{"ACCOUNTID", "BRANCHID", "NAME", "TYPE", "DATA::JSONB"});
        this.copy("PROJECT_FAVOURITES", new String[]{"ID", "ACCOUNTID", "PROJECTID"});
        this.updateSequences();
    }

    private void copyEntityData() {
        this.copyWithTmp("ENTITY_DATA", "CREATE TABLE TMP_ENTITY_DATA (\n                  ID               INTEGER     PRIMARY KEY,\n                  NAME             VARCHAR(150)       NOT NULL,\n                  PROJECT          INTEGER,\n                  BRANCH           INTEGER,\n                  PROMOTION_LEVEL  INTEGER,\n                  VALIDATION_STAMP INTEGER,\n                  BUILD            INTEGER,\n                  PROMOTION_RUN    INTEGER,\n                  VALIDATION_RUN   INTEGER,\n                  JSON_VALUE       JSONB NULL\n                );\n                ", new String[]{"ID", "NAME", "PROJECT", "BRANCH", "PROMOTION_LEVEL", "VALIDATION_STAMP", "BUILD", "PROMOTION_RUN", "VALIDATION_RUN", "VALUE->JSON_VALUE::JSONB"});
    }

    private void copyEntityDataStore() {
        this.copyWithTmp("ENTITY_DATA_STORE", "CREATE TABLE TMP_ENTITY_DATA_STORE (\n                  ID         INTEGER     PRIMARY KEY,\n                  PROJECT          INTEGER        NULL,\n                  BRANCH           INTEGER        NULL,\n                  PROMOTION_LEVEL  INTEGER        NULL,\n                  VALIDATION_STAMP INTEGER        NULL,\n                  BUILD            INTEGER        NULL,\n                  PROMOTION_RUN    INTEGER        NULL,\n                  VALIDATION_RUN   INTEGER        NULL,\n                  CREATION         VARCHAR(24)    NOT NULL,\n                  CREATOR          VARCHAR(40)    NOT NULL,\n                  CATEGORY         VARCHAR(150)   NOT NULL,\n                  NAME             VARCHAR(150)   NOT NULL,\n                  GROUPID          VARCHAR(150)   NULL,\n                  JSON             VARCHAR(10000) NOT NULL\n                );\n                ", new String[]{"ID", "PROJECT", "BRANCH", "PROMOTION_LEVEL", "VALIDATION_STAMP", "BUILD", "PROMOTION_RUN", "VALIDATION_RUN", "CREATION", "CREATOR", "CATEGORY", "NAME", "GROUPID", "JSON"});
    }

    private void copyEntityDataStoreAudit() {
        this.copyWithTmp("ENTITY_DATA_STORE_AUDIT", "CREATE TABLE TMP_ENTITY_DATA_STORE_AUDIT (\n                  ID         INTEGER     PRIMARY KEY,\n                  RECORD_ID  INTEGER     NOT NULL,\n                  AUDIT_TYPE VARCHAR(10) NOT NULL,\n                  TIMESTAMP  VARCHAR(24) NOT NULL,\n                  CREATOR    VARCHAR(40) NOT NULL\n                );\n                ", new String[]{"ID", "RECORD_ID", "AUDIT_TYPE", "TIMESTAMP", "USER->CREATOR"});
    }

    private void copyProperties() {
        this.copyWithTmp("PROPERTIES", "CREATE TABLE TMP_PROPERTIES (   ID INTEGER PRIMARY KEY,   TYPE CHARACTER VARYING(150),   PROJECT INTEGER,   BRANCH INTEGER,   PROMOTION_LEVEL INTEGER,   VALIDATION_STAMP INTEGER,   BUILD INTEGER,   PROMOTION_RUN INTEGER,   VALIDATION_RUN INTEGER,   SEARCHKEY CHARACTER VARYING(200),   JSON JSONB );", new String[]{"ID", "PROJECT", "BRANCH", "PROMOTION_LEVEL", "VALIDATION_STAMP", "BUILD", "PROMOTION_RUN", "VALIDATION_RUN", "TYPE", "SEARCHKEY", "JSON::JSONB"});
    }

    private void copyEvents() {
        this.copyWithTmp("EVENTS", "CREATE TABLE TMP_EVENTS (   ID INTEGER PRIMARY KEY,   EVENT_TYPE CHARACTER VARYING(120),   PROJECT INTEGER,   BRANCH INTEGER,   PROMOTION_LEVEL INTEGER,   VALIDATION_STAMP INTEGER,   BUILD INTEGER,   PROMOTION_RUN INTEGER,   VALIDATION_RUN INTEGER,   REF CHARACTER VARYING(20),   EVENT_VALUES CHARACTER VARYING(500),   EVENT_TIME CHARACTER VARYING(24),   EVENT_USER CHARACTER VARYING(40) );", new String[]{"ID", "PROJECT", "BRANCH", "PROMOTION_LEVEL", "VALIDATION_STAMP", "BUILD", "PROMOTION_RUN", "VALIDATION_RUN", "EVENT_TYPE", "REF", "EVENT_VALUES", "EVENT_TIME", "EVENT_USER"});
    }

    /*
     * WARNING - void declaration
     */
    private void copyWithTmp(String table, String tmpCreation, String ... columns) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        String h2Query = String.format("SELECT * FROM %s", table);
        Object[] objectArray = $receiver$iv = (Object[])columns;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        for (void item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            ColumnMigration columnMigration = ColumnMigration.Companion.parse((String)it);
            collection.add(columnMigration);
        }
        List specs = (List)destination$iv$iv;
        String insert2 = CollectionsKt.joinToString$default((Iterable)specs, (CharSequence)",", null, null, (int)0, null, (Function1)((Function1)copyWithTmp.insert.1.INSTANCE), (int)30, null);
        String postgresqlUpdate2 = String.format("INSERT INTO TMP_%s (%s) VALUES (%s)", table, insert2, CollectionsKt.joinToString$default((Iterable)specs, (CharSequence)",", null, null, (int)0, null, (Function1)((Function1)copyWithTmp.postgresqlUpdate.1.INSTANCE), (int)30, null));
        this.tx((Function0)new /* Unavailable Anonymous Inner Class!! */);
        int count2 = ((Number)this.intx((Function0)new /* Unavailable Anonymous Inner Class!! */)).intValue();
        this.tx((Function0)new /* Unavailable Anonymous Inner Class!! */);
        this.logger.info("{} count = {}...", (Object)table, (Object)count2);
    }

    private void updateSequences() {
        this.logger.info("Resetting the sequences...");
        String[] tables = new String[]{"ACCOUNT_GROUP_MAPPING", "ACCOUNT_GROUPS", "ACCOUNTS", "BRANCHES", "BUILDS", "CONFIGURATIONS", "ENTITY_DATA", "ENTITY_DATA_STORE", "ENTITY_DATA_STORE_AUDIT", "EVENTS", "EXT_SVN_REPOSITORY", "PREDEFINED_PROMOTION_LEVELS", "PREDEFINED_VALIDATION_STAMPS", "PROJECTS", "PROMOTION_LEVELS", "PROMOTION_RUNS", "PROPERTIES", "BUILD_LINKS", "VALIDATION_RUN_STATUSES", "VALIDATION_RUNS", "VALIDATION_STAMPS", "VALIDATION_STAMP_FILTERS"};
        this.tx((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void cleanup() {
        this.logger.info("Cleanup of target database...");
        String[] tables = new String[]{"ACCOUNTS", "ACCOUNT_GROUPS", "CONFIGURATIONS", "EXT_SVN_REPOSITORY", "PREDEFINED_PROMOTION_LEVELS", "PREDEFINED_VALIDATION_STAMPS", "PROJECTS", "EVENTS", "SETTINGS", "STORAGE", "VALIDATION_STAMP_FILTERS"};
        this.tx((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void tx(Function0<Unit> task) {
        this.txTemplate.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private <T> T intx(Function0<? extends T> supplier) {
        return (T)this.txTemplate.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void copy(String table, String ... columns) {
        String h2Query = String.format("SELECT * FROM %s", table);
        String insert2 = ArraysKt.joinToString$default((Object[])columns, (CharSequence)",", null, null, (int)0, null, (Function1)((Function1)copy.insert.1.INSTANCE), (int)30, null);
        String values2 = ArraysKt.joinToString$default((Object[])columns, (CharSequence)",", null, null, (int)0, null, (Function1)((Function1)copy.values.1.INSTANCE), (int)30, null);
        String postgresqlUpdate2 = String.format("INSERT INTO %s (%s) VALUES (%s)", table, insert2, values2);
        this.tx((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void simpleMigration(String name, String h2Query, Map<String, ? extends Object> h2Params, String postgresqlUpdate2) {
        Collection $receiver$iv;
        this.logger.info("Migrating {}...", (Object)name);
        List list = this.h2.queryForList(h2Query, h2Params);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"h2.queryForList(h2Query, h2Params)");
        List sources = list;
        int count2 = sources.size();
        Collection collection = $receiver$iv = (Collection)sources;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        Map[] mapArray = thisCollection$iv.toArray(new Map[0]);
        if (mapArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        if (mapArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.collections.Map<kotlin.String, kotlin.Any>>");
        }
        Map[] array = mapArray;
        try {
            this.postgresql.batchUpdate(postgresqlUpdate2, array);
        }
        catch (DataAccessException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof BatchUpdateException) {
                SQLException sqlException = ((BatchUpdateException)cause).getNextException();
                throw (Throwable)new RuntimeException("SQL Error", sqlException);
            }
            throw (Throwable)ex;
        }
        this.logger.info("{} count = {}...", (Object)name, (Object)count2);
    }

    public Migration(@Qualifier(value="h2") @NotNull DataSource h2Datasource, @Qualifier(value="postgresql") @NotNull DataSource postgresqlDatasource, @NotNull MigrationProperties migrationProperties) {
        Intrinsics.checkParameterIsNotNull((Object)h2Datasource, (String)"h2Datasource");
        Intrinsics.checkParameterIsNotNull((Object)postgresqlDatasource, (String)"postgresqlDatasource");
        Intrinsics.checkParameterIsNotNull((Object)migrationProperties, (String)"migrationProperties");
        this.migrationProperties = migrationProperties;
        this.logger = LoggerFactory.getLogger(Migration.class);
        this.h2 = new NamedParameterJdbcTemplate(h2Datasource);
        this.postgresql = new NamedParameterJdbcTemplate(postgresqlDatasource);
        this.txTemplate = new TransactionTemplate((PlatformTransactionManager)new DataSourceTransactionManager(postgresqlDatasource));
    }

    @NotNull
    public static final /* synthetic */ NamedParameterJdbcTemplate access$getPostgresql$p(Migration $this) {
        return $this.postgresql;
    }

    public static final /* synthetic */ Logger access$getLogger$p(Migration $this) {
        return $this.logger;
    }

    @NotNull
    public static final /* synthetic */ NamedParameterJdbcTemplate access$getH2$p(Migration $this) {
        return $this.h2;
    }

    @NotNull
    public static final /* synthetic */ MigrationProperties access$getMigrationProperties$p(Migration $this) {
        return $this.migrationProperties;
    }

    public static final /* synthetic */ void access$simpleMigration(Migration $this, @NotNull String name, @NotNull String h2Query, @NotNull Map h2Params, @NotNull String postgresqlUpdate2) {
        $this.simpleMigration(name, h2Query, h2Params, postgresqlUpdate2);
    }
}

