/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.migration.postgresql;

import java.util.Collections;
import javax.annotation.PostConstruct;
import net.nemerosa.ontrack.migration.postgresql.Migration;
import net.nemerosa.ontrack.migration.postgresql.MigrationProperties;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.flyway.FlywayProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@SpringBootApplication
@ComponentScan(value={"net.nemerosa.ontrack"})
public class MigrationTool {
    private final Logger logger = LoggerFactory.getLogger(MigrationTool.class);
    @Autowired
    private MigrationProperties migrationProperties;
    @Autowired
    private FlywayProperties flywayProperties;

    @PostConstruct
    public void start() {
        this.flywayProperties.setLocations(Collections.singletonList("classpath:/ontrack/sql"));
    }

    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(new Object[]{MigrationTool.class});
        ConfigurableApplicationContext context = application.run(args);
        ((Migration)context.getBeansOfType(Migration.class).get("migration")).run();
    }

    @Bean
    @Primary
    @Qualifier(value="postgresql")
    public javax.sql.DataSource getDataSource() {
        return this.createDataSource("Postgresql", "org.postgresql.Driver", this.migrationProperties.getPostgresql());
    }

    @Bean
    @Qualifier(value="h2")
    public javax.sql.DataSource getH2DataSource() {
        return this.createDataSource("H2", "org.h2.Driver", this.migrationProperties.getH2());
    }

    private javax.sql.DataSource createDataSource(String name, String driver, MigrationProperties.DatabaseProperties databaseProperties) {
        this.logger.info("Using {} database at {}", (Object)name, (Object)databaseProperties.getUrl());
        DataSource pool = new DataSource();
        pool.setDriverClassName(driver);
        pool.setUrl(databaseProperties.getUrl());
        pool.setUsername(databaseProperties.getUsername());
        pool.setPassword(databaseProperties.getPassword());
        pool.setDefaultAutoCommit(Boolean.valueOf(false));
        pool.setInitialSize(10);
        pool.setMaxIdle(10);
        pool.setMaxActive(20);
        return pool;
    }
}

