/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.migration.postgresql;

import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import net.nemerosa.ontrack.migration.postgresql.Migration;
import net.nemerosa.ontrack.migration.postgresql.MigrationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@SpringBootApplication
@ComponentScan(value={"net.nemerosa.ontrack"})
public class MigrationTool {
    private final Logger logger = LoggerFactory.getLogger(MigrationTool.class);
    private final MigrationProperties migrationProperties;

    public MigrationTool(MigrationProperties migrationProperties) {
        this.migrationProperties = migrationProperties;
    }

    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(new Class[]{MigrationTool.class});
        ConfigurableApplicationContext context = application.run(args);
        ((Migration)context.getBeansOfType(Migration.class).get("migration")).run();
    }

    @Bean
    @Primary
    @Qualifier(value="postgresql")
    public DataSource getDataSource() {
        return this.createDataSource("Postgresql", "org.postgresql.Driver", this.migrationProperties.getPostgresql());
    }

    @Bean
    @Qualifier(value="h2")
    public DataSource getH2DataSource() {
        return this.createDataSource("H2", "org.h2.Driver", this.migrationProperties.getH2());
    }

    private DataSource createDataSource(String name, String driver, MigrationProperties.DatabaseProperties databaseProperties) {
        this.logger.info("Using {} database at {}", (Object)name, (Object)databaseProperties.getUrl());
        HikariDataSource pool = new HikariDataSource();
        pool.setDriverClassName(driver);
        pool.setJdbcUrl(databaseProperties.getUrl());
        pool.setUsername(databaseProperties.getUsername());
        pool.setPassword(databaseProperties.getPassword());
        pool.setAutoCommit(false);
        pool.setMaximumPoolSize(20);
        return pool;
    }
}

