/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.nemerosa.ontrack.json.ObjectMapperFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public final class TestUtils {
    private static final ObjectMapper mapper = ObjectMapperFactory.create();
    private static final AtomicLong counter = new AtomicLong();

    private TestUtils() {
    }

    public static List<Integer> range(int from, int to) {
        Validate.isTrue((to >= from ? 1 : 0) != 0, (String)"'to' value must be greater or equal to the 'from' value.", (Object[])new Object[0]);
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = from; i <= to; ++i) {
            l.add(i);
        }
        return l;
    }

    public static String uid(String prefix) {
        return prefix + new SimpleDateFormat("mmssSSS").format(new Date()) + counter.incrementAndGet();
    }

    public static void assertJsonWrite(JsonNode expectedJson, Object objectToWrite) {
        Assert.assertEquals((Object)expectedJson, (Object)mapper.valueToTree(objectToWrite));
    }

    public static void assertJsonWrite(JsonNode expectedJson, Object objectToWrite, Class<?> viewClass) throws JsonProcessingException {
        TestUtils.assertJsonWrite(mapper, expectedJson, objectToWrite, viewClass);
    }

    public static void assertJsonWrite(ObjectMapper mapper, JsonNode expectedJson, Object objectToWrite, Class<?> viewClass) throws JsonProcessingException {
        Assert.assertEquals((Object)mapper.writeValueAsString((Object)expectedJson), (Object)mapper.writerWithView(viewClass).writeValueAsString(objectToWrite));
    }

    public static <T> void assertJsonRead(T expectedResult, JsonNode jsonToRead, Class<T> type) throws JsonProcessingException {
        Assert.assertEquals(expectedResult, (Object)mapper.treeToValue((TreeNode)jsonToRead, type));
    }

    public static void assertJsonEquals(TreeNode o1, TreeNode o2) {
        Assert.assertEquals((Object)o1, (Object)o2);
    }

    public static LocalDateTime dateTime() {
        return LocalDateTime.of(2014, 5, 13, 20, 11);
    }

    public static String dateTimeJson() {
        return "2014-05-13T20:11:00Z";
    }

    @NotNull
    public static byte[] resourceBytes(@NotNull String path) throws IOException {
        return IOUtils.toByteArray((URL)TestUtils.class.getResource(path));
    }

    @NotNull
    public static String resourceString(@NotNull String path) throws IOException {
        return new String(TestUtils.resourceBytes(path), "UTF-8");
    }

    public static JsonNode resourceJson(String path) throws IOException {
        return mapper.readTree(TestUtils.resourceBytes(path));
    }
}

