/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot;

import java.util.Collection;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.SearchResult;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.ui.controller.URIBuilder;
import net.nemerosa.ontrack.ui.support.AbstractSearchProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BranchSearchProvider
extends AbstractSearchProvider {
    private final StructureService structureService;

    @Autowired
    public BranchSearchProvider(URIBuilder uriBuilder, StructureService structureService) {
        super(uriBuilder);
        this.structureService = structureService;
    }

    public boolean isTokenSearchable(String token) {
        return Pattern.matches("[A-Za-z0-9\\.\\-_]+", token);
    }

    public Collection<SearchResult> search(String token) {
        return this.structureService.getProjectList().stream().map(Project::getName).map(project -> this.structureService.findBranchByName(project, token)).filter(Optional::isPresent).map(Optional::get).map(branch -> new SearchResult(branch.getEntityDisplayName(), "", this.uriBuilder.getEntityURI((ProjectEntity)branch), this.uriBuilder.getEntityPage((ProjectEntity)branch), 100)).collect(Collectors.toList());
    }
}

