/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot;

import java.util.Collection;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.SearchResult;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.ui.controller.URIBuilder;
import net.nemerosa.ontrack.ui.support.AbstractSearchProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BuildSearchProvider
extends AbstractSearchProvider {
    private final StructureService structureService;

    @Autowired
    public BuildSearchProvider(URIBuilder uriBuilder, StructureService structureService) {
        super(uriBuilder);
        this.structureService = structureService;
    }

    public boolean isTokenSearchable(String token) {
        return Pattern.matches("[A-Za-z0-9\\.\\-_]+", token);
    }

    public Collection<SearchResult> search(String token) {
        return this.structureService.getProjectList().stream().flatMap(project -> this.structureService.getBranchesForProject(project.getId()).stream()).map(branch -> this.structureService.findBuildByName(branch.getProject().getName(), branch.getName(), token)).filter(Optional::isPresent).map(Optional::get).map(build -> new SearchResult(build.getEntityDisplayName(), "", this.uriBuilder.getEntityURI((ProjectEntity)build), this.uriBuilder.getEntityPage((ProjectEntity)build), 100)).collect(Collectors.toList());
    }
}

