/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Pattern;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.SearchResult;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.ui.controller.URIBuilder;
import net.nemerosa.ontrack.ui.support.AbstractSearchProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectSearchProvider
extends AbstractSearchProvider {
    private final StructureService structureService;

    @Autowired
    public ProjectSearchProvider(URIBuilder uriBuilder, StructureService structureService) {
        super(uriBuilder);
        this.structureService = structureService;
    }

    public boolean isTokenSearchable(String token) {
        return Pattern.matches("[A-Za-z0-9\\.\\-_]+", token);
    }

    public Collection<SearchResult> search(String token) {
        Optional oProject = this.structureService.findProjectByName(token);
        if (oProject.isPresent()) {
            Project project = (Project)oProject.get();
            return Collections.singletonList(new SearchResult(project.getEntityDisplayName(), "", this.uriBuilder.getEntityURI((ProjectEntity)project), this.uriBuilder.getEntityPage((ProjectEntity)project), 100));
        }
        return Collections.emptyList();
    }
}

