/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import net.nemerosa.ontrack.model.metrics.OntrackMetrics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadata;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProviders;
import org.springframework.stereotype.Component;

@Component
public class DataSourceMetrics
implements OntrackMetrics {
    private final Map<String, DataSource> dataSources;
    private final DataSourcePoolMetadataProviders provider;

    @Autowired
    public DataSourceMetrics(Map<String, DataSource> dataSources, Collection<DataSourcePoolMetadataProvider> providers) {
        this.dataSources = dataSources;
        this.provider = new DataSourcePoolMetadataProviders(providers);
    }

    public Collection<Metric<?>> metrics() {
        ArrayList metrics = new ArrayList();
        this.dataSources.entrySet().stream().forEach(entry -> {
            String name = (String)entry.getKey();
            String prefix = String.format("gauge.datasource.%s", name);
            DataSource dataSource = (DataSource)entry.getValue();
            DataSourcePoolMetadata poolMetadata = this.provider.getDataSourcePoolMetadata(dataSource);
            metrics.add(new Metric(prefix + ".active", (Number)poolMetadata.getActive()));
            metrics.add(new Metric(prefix + ".max", (Number)poolMetadata.getMax()));
            metrics.add(new Metric(prefix + ".min", (Number)poolMetadata.getMin()));
            metrics.add(new Metric(prefix + ".usage", (Number)poolMetadata.getUsage()));
        });
        return metrics;
    }
}

