/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.metrics;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import net.nemerosa.ontrack.model.metrics.MetricsSource;
import net.nemerosa.ontrack.model.support.OntrackConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.dropwizard.DropwizardMetricServices;
import org.springframework.boot.actuate.metrics.export.AbstractMetricExporter;
import org.springframework.stereotype.Component;

@Component
public class DefaultMetricsExporter
extends AbstractMetricExporter {
    private final Logger logger = LoggerFactory.getLogger(DefaultMetricsExporter.class);
    private final OntrackConfigProperties config;
    private final DropwizardMetricServices metricWriter;
    private final ScheduledExecutorService executor;
    private final Collection<MetricsSource> metricsSources;

    @Autowired
    public DefaultMetricsExporter(OntrackConfigProperties config, DropwizardMetricServices metricWriter, Collection<MetricsSource> metricsSources) {
        super("");
        this.config = config;
        this.metricWriter = metricWriter;
        this.metricsSources = metricsSources;
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("metrics-exporter-%d").build());
    }

    @PostConstruct
    public void run() {
        this.logger.info("[metrics] Scheduling export of metrics");
        this.metricsSources.forEach(metricsSource -> this.logger.info("[metrics] Source: {}", (Object)metricsSource.getClass().getName()));
        this.executor.scheduleAtFixedRate(() -> {
            try {
                this.logger.trace("[metrics] Exporting...");
                this.export();
            }
            catch (RuntimeException ex) {
                this.logger.error("RuntimeException thrown from {}#export. Exception was suppressed.", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)ex);
            }
        }, this.config.getMetricsPeriod(), this.config.getMetricsPeriod(), TimeUnit.SECONDS);
    }

    protected Iterable<Metric<?>> next(String group) {
        return this.metricsSources.stream().flatMap(MetricsSource::getMetrics).collect(Collectors.toList());
    }

    protected void write(String group, Collection<Metric<?>> values) {
        values.forEach(this::write);
    }

    private void write(Metric<?> metric) {
        this.logger.trace("[metrics] {} -> {}", (Object)metric.getName(), (Object)metric.getValue());
        this.metricWriter.submit(metric.getName(), metric.getValue().doubleValue());
    }
}

