/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.support;

import java.io.File;
import net.nemerosa.ontrack.boot.support.DevSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@Profile(value={"dev"})
public class DevWebConfig
extends WebMvcConfigurerAdapter {
    private final Log log = LogFactory.getLog(DevWebConfig.class);
    @Autowired
    private DevSettings devSettings;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        this.log.warn((Object)"[dev] Running in DEV mode");
        String prod = this.getPath(this.devSettings.getProd());
        this.log.info((Object)("[dev] Compiled prod web resources from: " + prod));
        registry.addResourceHandler(new String[]{"/fonts/**"}).addResourceLocations(new String[]{prod + "/fonts/"});
        String dev = this.getPath(this.devSettings.getDev());
        this.log.info((Object)("[dev] Compiled dev web resources from: " + dev));
        registry.addResourceHandler(new String[]{"/css/**"}).addResourceLocations(new String[]{dev + "/css/"});
        registry.addResourceHandler(new String[]{"/templates/**"}).addResourceLocations(new String[]{dev + "/templates/"});
        registry.addResourceHandler(new String[]{"index.html"}).addResourceLocations(new String[]{dev + "/"});
        String source = this.getPath(this.devSettings.getSrc());
        this.log.info((Object)("[dev] Web sources from: " + source));
        registry.addResourceHandler(new String[]{"/app/**"}).addResourceLocations(new String[]{source + "/app/"});
        registry.addResourceHandler(new String[]{"/assets/**"}).addResourceLocations(new String[]{source + "/assets/"});
        String vendor = this.getPath(this.devSettings.getVendor());
        this.log.info((Object)("[dev] Vendor sources from: " + vendor));
        registry.addResourceHandler(new String[]{"/vendor/**"}).addResourceLocations(new String[]{vendor + "/"});
    }

    private String getPath(String dirName) {
        return "file:" + new File(this.devSettings.getWeb(), dirName).getAbsolutePath();
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/").setViewName("forward:/index.html");
    }
}

