/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.support;

import java.util.List;
import net.nemerosa.ontrack.boot.support.DocumentHttpMessageConverter;
import net.nemerosa.ontrack.boot.support.ResourceHttpMessageConverter;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.ui.controller.URIBuilder;
import net.nemerosa.ontrack.ui.resource.ResourceModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.filter.ShallowEtagHeaderFilter;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class WebConfig
extends WebMvcConfigurerAdapter {
    @Autowired
    private URIBuilder uriBuilder;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private List<ResourceModule> resourceModules;

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(false).favorParameter(false);
    }

    @Bean
    public ShallowEtagHeaderFilter shallowEtagHeaderFilter() {
        return new ShallowEtagHeaderFilter();
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.clear();
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new DocumentHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter(this.uriBuilder, this.securityService, this.resourceModules));
    }
}

