/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.nemerosa.ontrack.boot.support.APIDescription;
import net.nemerosa.ontrack.boot.support.APIInfo;
import net.nemerosa.ontrack.boot.support.APIMethodInfo;
import net.nemerosa.ontrack.model.exceptions.APIMethodInfoNotFoundException;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resources;
import net.nemerosa.ontrack.ui.support.API;
import net.nemerosa.ontrack.ui.support.APIMethod;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@RestController
@RequestMapping(value={"/api"})
@Profile(value={"dev", "acceptance", "prod"})
public class APIController
extends AbstractResourceController {
    private final ApplicationContext applicationContext;
    private final RequestMappingHandlerMapping handlerMapping;

    @Autowired
    public APIController(ApplicationContext applicationContext, @Qualifier(value="requestMappingHandlerMapping") RequestMappingHandlerMapping handlerMapping) {
        this.applicationContext = applicationContext;
        this.handlerMapping = handlerMapping;
    }

    @RequestMapping(value={"/describe"}, method={RequestMethod.GET})
    public APIDescription describe(HttpServletRequest request, final @RequestParam String path) throws Exception {
        HandlerExecutionChain executionChain = this.handlerMapping.getHandler((HttpServletRequest)new HttpServletRequestWrapper(request){

            public String getRequestURI() {
                return path;
            }

            public String getServletPath() {
                return path;
            }
        });
        Object handler = executionChain.getHandler();
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            String type = handlerMethod.getBeanType().getName();
            String method = handlerMethod.getMethod().getName();
            List<APIInfo> apiInfos = this.getApiInfos();
            APIMethodInfo get = apiInfos.stream().flatMap(i -> i.getMethods().stream()).filter(mi -> StringUtils.equals((CharSequence)type, (CharSequence)mi.getApiInfo().getType()) && StringUtils.equals((CharSequence)method, (CharSequence)mi.getMethod())).findFirst().orElseThrow(() -> new APIMethodInfoNotFoundException(path));
            List<APIMethodInfo> methods = apiInfos.stream().flatMap(i -> i.getMethods().stream()).filter(mi -> StringUtils.equals((CharSequence)get.getPath(), (CharSequence)mi.getPath())).collect(Collectors.toList());
            return new APIDescription(path, methods);
        }
        throw new APIMethodInfoNotFoundException(path);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Resources<APIInfo> list() {
        return Resources.of(this.getApiInfos(), (URI)this.uri(((APIController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).list()));
    }

    private List<APIInfo> getApiInfos() {
        ArrayList<APIInfo> apiInfos = new ArrayList<APIInfo>();
        Collection controllers = this.applicationContext.getBeansWithAnnotation(Controller.class).values();
        controllers.forEach(controller -> {
            APIInfo apiInfo = new APIInfo(controller.getClass().getName(), this.getAPIName(controller.getClass()));
            RequestMapping typeAnnotation = (RequestMapping)AnnotationUtils.findAnnotation(controller.getClass(), RequestMapping.class);
            ReflectionUtils.doWithMethods(controller.getClass(), method -> {
                RequestMapping methodAnnotation = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
                if (methodAnnotation != null) {
                    APIMethodInfo apiMethodInfo = this.collectAPIMethodInfo(apiInfo, method, typeAnnotation, methodAnnotation);
                    apiInfo.add(apiMethodInfo);
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
            apiInfos.add(apiInfo);
        });
        return apiInfos;
    }

    private NameDescription getAPIName(Class<?> controllerClass) {
        API api = (API)AnnotationUtils.findAnnotation(controllerClass, API.class);
        return api != null ? NameDescription.nd((String)api.value(), (String)api.description()) : NameDescription.nd((String)StringUtils.capitalize((String)APIController.asDisplayName(StringUtils.removeEnd((String)controllerClass.getSimpleName(), (String)"Controller"))), (String)"");
    }

    private static String asDisplayName(CharSequence name) {
        StringBuilder s = new StringBuilder();
        name.codePoints().forEach(c -> {
            if (s.length() > 0 && !Character.isUpperCase(s.codePointAt(s.length() - 1)) && Character.isUpperCase(c)) {
                s.append(' ').append(Character.toChars(Character.toLowerCase(c)));
            } else {
                s.append(Character.toChars(c));
            }
        });
        return s.toString();
    }

    private NameDescription getAPIMethodName(Method method) {
        APIMethod api = (APIMethod)AnnotationUtils.findAnnotation((Method)method, APIMethod.class);
        return api != null ? NameDescription.nd((String)api.value(), (String)api.description()) : NameDescription.nd((String)StringUtils.capitalize((String)APIController.asDisplayName(method.getName())), (String)"");
    }

    protected APIMethodInfo collectAPIMethodInfo(APIInfo apiInfo, Method method, RequestMapping typeAnnotation, RequestMapping methodAnnotation) {
        StringBuilder path = new StringBuilder();
        this.appendPath(typeAnnotation, path);
        this.appendPath(methodAnnotation, path);
        List<RequestMethod> requestMethods = Arrays.asList(methodAnnotation.method());
        List<String> methods = requestMethods.isEmpty() ? Collections.singletonList("GET") : requestMethods.stream().map(Enum::name).collect(Collectors.toList());
        return APIMethodInfo.of(apiInfo, method.getName(), this.getAPIMethodName(method), path.toString(), methods);
    }

    private void appendPath(RequestMapping requestMapping, StringBuilder builder) {
        String[] paths;
        if (requestMapping != null && (paths = requestMapping.value()) != null && paths.length > 0) {
            String path = paths[0];
            if (builder.length() == 0 && path.startsWith("/")) {
                path = StringUtils.strip((String)path, (String)"/");
            } else if (builder.length() > 0) {
                path = "/" + StringUtils.strip((String)path, (String)"/");
            }
            builder.append(path);
        }
    }
}

