/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import java.util.Collection;
import javax.validation.Valid;
import net.nemerosa.ontrack.extension.api.AccountMgtActionExtension;
import net.nemerosa.ontrack.extension.api.ExtensionManager;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.Email;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.MultiSelection;
import net.nemerosa.ontrack.model.form.Password;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.Account;
import net.nemerosa.ontrack.model.security.AccountGroup;
import net.nemerosa.ontrack.model.security.AccountInput;
import net.nemerosa.ontrack.model.security.AccountService;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.support.Action;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/accounts"})
public class AccountController
extends AbstractResourceController {
    private final AccountService accountService;
    private final ExtensionManager extensionManager;

    @Autowired
    public AccountController(AccountService accountService, ExtensionManager extensionManager) {
        this.accountService = accountService;
        this.extensionManager = extensionManager;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public Resources<Account> getAccounts() {
        return (Resources)((Resources)Resources.of((Collection)this.accountService.getAccounts(), (URI)this.uri(((AccountController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getAccounts())).with("_create", this.uri(((AccountController)((Object)MvcUriComponentsBuilder.on(AccountController.class))).getCreationForm()))).with("_actions", this.uri(((AccountController)((Object)MvcUriComponentsBuilder.on(AccountController.class))).getAccountMgtActions()));
    }

    @RequestMapping(value={"actions"}, method={RequestMethod.GET})
    public Resources<Action> getAccountMgtActions() {
        return Resources.of(this.extensionManager.getExtensions(AccountMgtActionExtension.class).stream().map(arg_0 -> ((AccountController)this).resolveExtensionAction(arg_0)).filter(action -> action != null), (URI)this.uri(((AccountController)((Object)MvcUriComponentsBuilder.on(AccountController.class))).getAccountMgtActions()));
    }

    @RequestMapping(value={"create"}, method={RequestMethod.GET})
    public Form getCreationForm() {
        return Form.create().with((Field)Form.defaultNameField()).with((Field)((Text)((Text)Text.of((String)"fullName").length(100)).label("Full name")).help("Display name for the account")).with((Field)((Email)((Email)Email.of((String)"email").label("Email")).length(200)).help("Contact email for the account")).with((Field)((Password)((Password)Password.of((String)"password").label("Password")).length(40)).help("Password for the account")).with((Field)((MultiSelection)MultiSelection.of((String)"groups").label("Groups")).items(this.accountService.getAccountGroupsForSelection(ID.NONE)));
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public Account create(@RequestBody @Valid AccountInput input) {
        return this.accountService.create(input);
    }

    @RequestMapping(value={"{accountId}"}, method={RequestMethod.GET})
    public Account getAccount(@PathVariable ID accountId) {
        return this.accountService.getAccount(accountId);
    }

    @RequestMapping(value={"{accountId}/update"}, method={RequestMethod.GET})
    public Form getUpdateForm(@PathVariable ID accountId) {
        Account account = this.accountService.getAccount(accountId);
        Form form = this.getCreationForm();
        if (account.isDefaultAdmin()) {
            form = form.with((Field)Form.defaultNameField().readOnly());
        }
        form = form.with((Field)((Password)((Password)((Password)Password.of((String)"password").label("Password")).length(40)).help("Password for the account. Leave blank to keep it unchanged.")).optional());
        form = form.with((Field)((MultiSelection)MultiSelection.of((String)"groups").label("Groups")).items(this.accountService.getAccountGroupsForSelection(accountId)));
        return form.fill("name", (Object)account.getName()).fill("fullName", (Object)account.getFullName()).fill("email", (Object)account.getEmail());
    }

    @RequestMapping(value={"{accountId}/update"}, method={RequestMethod.PUT})
    public Account updateAccount(@PathVariable ID accountId, @RequestBody @Valid AccountInput input) {
        return this.accountService.updateAccount(accountId, input);
    }

    @RequestMapping(value={"{accountId}"}, method={RequestMethod.DELETE})
    public Ack deleteAccount(@PathVariable ID accountId) {
        return this.accountService.deleteAccount(accountId);
    }

    @RequestMapping(value={"groups"}, method={RequestMethod.GET})
    public Resources<AccountGroup> getAccountGroups() {
        return (Resources)Resources.of((Collection)this.accountService.getAccountGroups(), (URI)this.uri(((AccountController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getAccountGroups())).with("_create", this.uri(((AccountController)((Object)MvcUriComponentsBuilder.on(AccountController.class))).getGroupCreationForm()));
    }

    @RequestMapping(value={"groups/create"}, method={RequestMethod.GET})
    public Form getGroupCreationForm() {
        return Form.nameAndDescription();
    }

    @RequestMapping(value={"groups/create"}, method={RequestMethod.POST})
    public AccountGroup create(@RequestBody @Valid NameDescription nameDescription) {
        return this.accountService.createGroup(nameDescription);
    }

    @RequestMapping(value={"groups/{groupId}"}, method={RequestMethod.GET})
    public AccountGroup getGroup(@PathVariable ID groupId) {
        return this.accountService.getAccountGroup(groupId);
    }

    @RequestMapping(value={"groups/{groupId}/update"}, method={RequestMethod.GET})
    public Form getGroupUpdateForm(@PathVariable ID groupId) {
        AccountGroup group = this.accountService.getAccountGroup(groupId);
        return this.getGroupCreationForm().fill("name", (Object)group.getName()).fill("description", (Object)group.getDescription());
    }

    @RequestMapping(value={"groups/{groupId}/update"}, method={RequestMethod.PUT})
    public AccountGroup updateGroup(@PathVariable ID groupId, @RequestBody @Valid NameDescription input) {
        return this.accountService.updateGroup(groupId, input);
    }

    @RequestMapping(value={"groups/{groupId}"}, method={RequestMethod.DELETE})
    public Ack deleteGroup(@PathVariable ID groupId) {
        return this.accountService.deleteGroup(groupId);
    }
}

