/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import net.nemerosa.ontrack.job.JobScheduler;
import net.nemerosa.ontrack.job.JobStatus;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.security.ApplicationManagement;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.support.ApplicationLogEntry;
import net.nemerosa.ontrack.model.support.ApplicationLogService;
import net.nemerosa.ontrack.model.support.Page;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Pagination;
import net.nemerosa.ontrack.ui.resource.Resource;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.actuate.health.Health;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/admin"})
public class AdminController
extends AbstractResourceController {
    private final JobScheduler jobScheduler;
    private final ApplicationLogService applicationLogService;
    private final HealthEndpoint healthEndpoint;
    private final SecurityService securityService;

    @Autowired
    public AdminController(JobScheduler jobScheduler, ApplicationLogService applicationLogService, HealthEndpoint healthEndpoint, SecurityService securityService) {
        this.jobScheduler = jobScheduler;
        this.applicationLogService = applicationLogService;
        this.healthEndpoint = healthEndpoint;
        this.securityService = securityService;
    }

    @RequestMapping(value={"status"}, method={RequestMethod.GET})
    public Resource<Health> getStatus() {
        return Resource.of((Object)this.healthEndpoint.invoke(), (URI)this.uri(((AdminController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getStatus()));
    }

    @RequestMapping(value={"logs"}, method={RequestMethod.GET})
    public Resources<ApplicationLogEntry> getLogEntries(Page page) {
        List entries = this.applicationLogService.getLogEntries(page);
        Resources resources = Resources.of((Collection)entries, (URI)this.uri(((AdminController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getLogEntries(page)));
        int offset = page.getOffset();
        int count = page.getCount();
        int actualCount = entries.size();
        int total = this.applicationLogService.getLogEntriesTotal();
        Pagination pagination = Pagination.of((int)offset, (int)actualCount, (int)total);
        if (offset > 0) {
            pagination = pagination.withPrev(this.uri(((AdminController)((Object)MvcUriComponentsBuilder.on(AdminController.class))).getLogEntries(new Page(Math.max(0, offset - count), count))));
        }
        if (offset + count < total) {
            pagination = pagination.withNext(this.uri(((AdminController)((Object)MvcUriComponentsBuilder.on(AdminController.class))).getLogEntries(new Page(offset + count, count))));
        }
        return resources.withPagination(pagination);
    }

    @RequestMapping(value={"jobs"}, method={RequestMethod.GET})
    public Resources<JobStatus> getJobs() {
        return Resources.of((Collection)this.jobScheduler.getJobStatuses(), (URI)this.uri(((AdminController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getJobs()));
    }

    @RequestMapping(value={"jobs/{id:\\d+}"}, method={RequestMethod.POST})
    public Ack launchJob(@PathVariable long id) {
        this.securityService.checkGlobalFunction(ApplicationManagement.class);
        return this.jobScheduler.getJobKey(id).map(key -> Ack.validate((this.jobScheduler.fireImmediately(key) != null ? 1 : 0) != 0)).orElse(Ack.NOK);
    }

    @RequestMapping(value={"jobs/{id:\\d+}/pause"}, method={RequestMethod.POST})
    public Ack pauseJob(@PathVariable long id) {
        this.securityService.checkGlobalFunction(ApplicationManagement.class);
        return this.jobScheduler.getJobKey(id).map(key -> Ack.validate((boolean)this.jobScheduler.pause(key))).orElse(Ack.NOK);
    }

    @RequestMapping(value={"jobs/{id:\\d+}/resume"}, method={RequestMethod.POST})
    public Ack resumeJob(@PathVariable long id) {
        this.securityService.checkGlobalFunction(ApplicationManagement.class);
        return this.jobScheduler.getJobKey(id).map(key -> Ack.validate((boolean)this.jobScheduler.resume(key))).orElse(Ack.NOK);
    }

    @RequestMapping(value={"jobs/{id:\\d+}"}, method={RequestMethod.DELETE})
    public Ack deleteJob(@PathVariable long id) {
        this.securityService.checkGlobalFunction(ApplicationManagement.class);
        return this.jobScheduler.getJobKey(id).filter(key -> !((JobStatus)this.jobScheduler.getJobStatus(key).get()).isValid()).map(key -> Ack.validate((boolean)this.jobScheduler.unschedule(key))).orElse(Ack.NOK);
    }
}

