/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import net.nemerosa.ontrack.boot.ui.UIUtils;
import net.nemerosa.ontrack.extension.api.BuildDiffExtension;
import net.nemerosa.ontrack.extension.api.ExtensionManager;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.buildfilter.BuildFilter;
import net.nemerosa.ontrack.model.buildfilter.BuildFilterService;
import net.nemerosa.ontrack.model.exceptions.BranchNotTemplateDefinitionException;
import net.nemerosa.ontrack.model.exceptions.BranchNotTemplateInstanceException;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Int;
import net.nemerosa.ontrack.model.form.MultiForm;
import net.nemerosa.ontrack.model.form.Replacements;
import net.nemerosa.ontrack.model.form.Selection;
import net.nemerosa.ontrack.model.form.ServiceConfigurator;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.BranchCreate;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.BranchBuildView;
import net.nemerosa.ontrack.model.structure.BranchBulkUpdateRequest;
import net.nemerosa.ontrack.model.structure.BranchCloneRequest;
import net.nemerosa.ontrack.model.structure.BranchCopyRequest;
import net.nemerosa.ontrack.model.structure.BranchStatusView;
import net.nemerosa.ontrack.model.structure.BranchTemplateInstanceConnectRequest;
import net.nemerosa.ontrack.model.structure.BranchTemplateInstanceSingleRequest;
import net.nemerosa.ontrack.model.structure.BranchTemplateService;
import net.nemerosa.ontrack.model.structure.BranchTemplateSyncResults;
import net.nemerosa.ontrack.model.structure.CopyService;
import net.nemerosa.ontrack.model.structure.Describable;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescriptionState;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ServiceConfigurationSource;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.structure.TemplateDefinition;
import net.nemerosa.ontrack.model.structure.TemplateInstance;
import net.nemerosa.ontrack.model.structure.TemplateSynchronisationAbsencePolicy;
import net.nemerosa.ontrack.model.structure.TemplateSynchronisationService;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/structure"})
public class BranchController
extends AbstractResourceController {
    private final StructureService structureService;
    private final BranchTemplateService branchTemplateService;
    private final TemplateSynchronisationService templateSynchronisationService;
    private final CopyService copyService;
    private final BuildFilterService buildFilterService;
    private final ExtensionManager extensionManager;
    private final SecurityService securityService;

    @Autowired
    public BranchController(StructureService structureService, BranchTemplateService branchTemplateService, TemplateSynchronisationService templateSynchronisationService, CopyService copyService, BuildFilterService buildFilterService, ExtensionManager extensionManager, SecurityService securityService) {
        this.structureService = structureService;
        this.branchTemplateService = branchTemplateService;
        this.templateSynchronisationService = templateSynchronisationService;
        this.copyService = copyService;
        this.buildFilterService = buildFilterService;
        this.extensionManager = extensionManager;
        this.securityService = securityService;
    }

    @RequestMapping(value={"projects/{projectId}/branches"}, method={RequestMethod.GET})
    public Resources<Branch> getBranchListForProject(@PathVariable ID projectId) {
        return (Resources)Resources.of((Collection)this.structureService.getBranchesForProject(projectId), (URI)this.uri(((BranchController)((Object)MvcUriComponentsBuilder.on(BranchController.class))).getBranchListForProject(projectId))).with("_create", this.uri(((BranchController)((Object)MvcUriComponentsBuilder.on(BranchController.class))).newBranch(projectId, null)), this.securityService.isProjectFunctionGranted(projectId.getValue(), BranchCreate.class));
    }

    @RequestMapping(value={"projects/{projectId}/branches/create"}, method={RequestMethod.GET})
    public Form newBranchForm(@PathVariable ID projectId) {
        this.structureService.getProject(projectId);
        return Branch.form();
    }

    @RequestMapping(value={"projects/{projectId}/branches/create"}, method={RequestMethod.POST})
    public Branch newBranch(@PathVariable ID projectId, @RequestBody @Valid NameDescriptionState nameDescription) {
        Project project = this.structureService.getProject(projectId);
        Branch branch = Branch.of((Project)project, (NameDescriptionState)nameDescription);
        branch = this.structureService.newBranch(branch);
        return branch;
    }

    @RequestMapping(value={"branches/{branchId}"}, method={RequestMethod.GET})
    public Branch getBranch(@PathVariable ID branchId) {
        return this.structureService.getBranch(branchId);
    }

    @RequestMapping(value={"branches/{branchId}"}, method={RequestMethod.DELETE})
    public Ack deleteBranch(@PathVariable ID branchId) {
        return this.structureService.deleteBranch(branchId);
    }

    @RequestMapping(value={"branches/{branchId}/update"}, method={RequestMethod.GET})
    public Form getUpdateForm(@PathVariable ID branchId) {
        return this.structureService.getBranch(branchId).toForm();
    }

    @RequestMapping(value={"branches/{branchId}/update"}, method={RequestMethod.PUT})
    public Branch updateBranch(@PathVariable ID branchId, @RequestBody @Valid NameDescriptionState form) {
        Branch branch = this.structureService.getBranch(branchId).update(form);
        this.structureService.saveBranch(branch);
        return branch;
    }

    @RequestMapping(value={"branches/{branchId}/enable"}, method={RequestMethod.PUT})
    public Branch enableBranch(@PathVariable ID branchId) {
        Branch branch = this.structureService.getBranch(branchId).withDisabled(false);
        this.structureService.saveBranch(branch);
        return branch;
    }

    @RequestMapping(value={"branches/{branchId}/disable"}, method={RequestMethod.PUT})
    public Branch disableBranch(@PathVariable ID branchId) {
        Branch branch = this.structureService.getBranch(branchId).withDisabled(true);
        this.structureService.saveBranch(branch);
        return branch;
    }

    @RequestMapping(value={"branches/{branchId}/status"}, method={RequestMethod.GET})
    public BranchStatusView getBranchStatusView(@PathVariable ID branchId) {
        return this.structureService.getBranchStatusView(this.structureService.getBranch(branchId));
    }

    @RequestMapping(value={"branches/{branchId}/view"}, method={RequestMethod.GET})
    public BranchBuildView buildView(@PathVariable ID branchId) {
        BuildFilter buildFilter = this.buildFilterService.defaultFilter();
        return this.buildViewWithFilter(branchId, buildFilter);
    }

    @RequestMapping(value={"branches/{branchId}/view/{filterType:.*}"}, method={RequestMethod.GET})
    public BranchBuildView buildViewWithFilter(@PathVariable ID branchId, @PathVariable String filterType, WebRequest request) {
        JsonNode jsonParameters = UIUtils.requestParametersToJson(request);
        BuildFilter buildFilter = this.buildFilterService.computeFilter(branchId, filterType, jsonParameters);
        return this.buildViewWithFilter(branchId, buildFilter);
    }

    @RequestMapping(value={"branches/{branchId}/copy"}, method={RequestMethod.GET})
    public Form copy(@PathVariable ID branchId) {
        return Form.create().with((Field)((Selection)((Selection)Selection.of((String)"sourceBranch").label("Source branch")).help("Branch to copy configuration from")).items(this.structureService.getProjectList().stream().flatMap(project -> this.structureService.getBranchesForProject(project.getId()).stream()).filter(branch -> !branchId.equals((Object)branch.getId())).collect(Collectors.toList()))).with((Field)Replacements.of((String)"replacements").label("Replacements"));
    }

    @RequestMapping(value={"branches/{branchId}/copy"}, method={RequestMethod.PUT})
    public Branch copy(@PathVariable ID branchId, @RequestBody BranchCopyRequest request) {
        Branch branch = this.structureService.getBranch(branchId);
        return this.copyService.copy(branch, request);
    }

    @RequestMapping(value={"branches/{branchId}/update/bulk"}, method={RequestMethod.GET})
    public Form bulkUpdate(@PathVariable ID branchId) {
        return Form.create().with((Field)Replacements.of((String)"replacements").label("Replacements"));
    }

    @RequestMapping(value={"branches/{branchId}/update/bulk"}, method={RequestMethod.PUT})
    public Branch bulkUpdate(@PathVariable ID branchId, @RequestBody BranchBulkUpdateRequest request) {
        Branch branch = this.structureService.getBranch(branchId);
        return this.copyService.update(branch, request);
    }

    @RequestMapping(value={"branches/{branchId}/clone"}, method={RequestMethod.GET})
    public Form clone(@PathVariable ID branchId) {
        return Form.create().with((Field)((Text)Text.of((String)"name").label("Target branch")).help("Name of the branch to create")).with((Field)Replacements.of((String)"replacements").label("Replacements"));
    }

    @RequestMapping(value={"branches/{branchId}/clone"}, method={RequestMethod.POST})
    public Branch clone(@PathVariable ID branchId, @RequestBody BranchCloneRequest request) {
        Branch branch = this.structureService.getBranch(branchId);
        return this.copyService.cloneBranch(branch, request);
    }

    @RequestMapping(value={"branches/{branchId}/template/definition"}, method={RequestMethod.GET})
    public Form getTemplateDefinition(@PathVariable ID branchId) {
        Branch branch = this.getBranch(branchId);
        Optional templateDefinition = this.branchTemplateService.getTemplateDefinition(branchId);
        return Form.create().with((Field)((MultiForm)((MultiForm)MultiForm.of((String)"parameters", (Form)Form.create().with((Field)((Text)Text.of((String)"name").label("Name")).help("Parameter name")).with((Field)((Text)((Text)Text.of((String)"description").optional()).label("Description")).help("Parameter description")).with((Field)((Text)((Text)Text.of((String)"expression").label("Expression")).optional()).help("Those expressions are defined for the synchronisation between template definitions and template instances. They bind a parameter name and a source name to an actual parameter value. A template expression is a string that contains references to the source name using the ${...} construct where the content is a Groovy expression where the `sourceName` variable is bound to the source name."))).label("Parameters")).help("List of parameters that define the template")).value(templateDefinition.map(TemplateDefinition::getParameters).orElse(Collections.emptyList()))).with((Field)((ServiceConfigurator)((ServiceConfigurator)((ServiceConfigurator)ServiceConfigurator.of((String)"synchronisationSourceConfig").label("Sync. source")).optional()).help("Source names when synchronising")).sources(this.templateSynchronisationService.getSynchronisationSources().stream().filter(source -> source.isApplicable(branch)).map(source -> new ServiceConfigurationSource(source.getId(), source.getName(), source.getForm(branch))).collect(Collectors.toList())).value(templateDefinition.map(TemplateDefinition::getSynchronisationSourceConfig).orElse(null))).with((Field)((Int)((Int)Int.of((String)"interval").label("Interval")).help("Interval between each synchronisation in minutes. If set to zero, no automated synchronisation is performed and it must be done manually.")).min(0).value((Object)templateDefinition.map(TemplateDefinition::getInterval).orElse(0))).with((Field)((Selection)((Selection)Selection.of((String)"absencePolicy").label("Absence policy")).help("Defines what to do with a branch template instance when the corresponding name is not defined any longer.")).items(Arrays.asList(TemplateSynchronisationAbsencePolicy.values()).stream().map(Describable::toDescription).collect(Collectors.toList())).itemId("id").itemName("name").value((Object)templateDefinition.map(td -> td.getAbsencePolicy().getId()).orElse(TemplateSynchronisationAbsencePolicy.DISABLE.getId())));
    }

    @RequestMapping(value={"branches/{branchId}/template/definition"}, method={RequestMethod.PUT})
    public Branch setTemplateDefinition(@PathVariable ID branchId, @RequestBody @Valid TemplateDefinition templateDefinition) {
        return this.branchTemplateService.setTemplateDefinition(branchId, templateDefinition);
    }

    @RequestMapping(value={"branches/{branchId}/template/sync"}, method={RequestMethod.POST})
    public BranchTemplateSyncResults syncTemplateDefinition(@PathVariable ID branchId) {
        return this.branchTemplateService.sync(branchId);
    }

    @RequestMapping(value={"branches/{branchId}/sync"}, method={RequestMethod.POST})
    public Ack syncTemplateInstance(@PathVariable ID branchId) {
        return this.branchTemplateService.syncInstance(branchId);
    }

    @RequestMapping(value={"branches/{branchId}/template"}, method={RequestMethod.GET})
    public Form singleTemplateInstanceForm(@PathVariable ID branchId) {
        Optional templateDefinition = this.branchTemplateService.getTemplateDefinition(branchId);
        if (!templateDefinition.isPresent()) {
            throw new BranchNotTemplateDefinitionException(branchId);
        }
        Form form = Form.create().with((Field)((Text)Form.defaultNameField().label("Source name")).help("Name used to create the branch from."));
        form.append(((TemplateDefinition)templateDefinition.get()).getForm());
        return form;
    }

    @RequestMapping(value={"branches/{branchId}/template"}, method={RequestMethod.PUT})
    public Branch createTemplateInstance(@PathVariable ID branchId, @RequestBody @Valid BranchTemplateInstanceSingleRequest request) {
        return this.branchTemplateService.createTemplateInstance(branchId, request);
    }

    @RequestMapping(value={"branches/{branchId}/template/instance"}, method={RequestMethod.GET})
    public TemplateInstance getTemplateInstance(@PathVariable ID branchId) {
        return (TemplateInstance)this.branchTemplateService.getTemplateInstance(branchId).orElseThrow(() -> new BranchNotTemplateInstanceException(branchId));
    }

    @RequestMapping(value={"branches/{branchId}/template/instance"}, method={RequestMethod.DELETE})
    public Branch disconnectTemplateInstance(@PathVariable ID branchId) {
        return this.branchTemplateService.disconnectTemplateInstance(branchId);
    }

    @RequestMapping(value={"branches/{branchId}/template/connect"}, method={RequestMethod.GET})
    public Form connectTemplateInstance(@PathVariable ID branchId) {
        Branch branch = this.structureService.getBranch(branchId);
        Collection templateDefinitions = this.branchTemplateService.getTemplateDefinitions(branch.getProject());
        return Form.create().with((Field)((ServiceConfigurator)((ServiceConfigurator)ServiceConfigurator.of((String)"connectionRequest").label("Template")).help("Template to connect to")).sources(templateDefinitions.stream().map(lbtd -> new ServiceConfigurationSource(lbtd.getBranch().getId().toString(), lbtd.getBranch().getName(), lbtd.getForm())).collect(Collectors.toList())));
    }

    @RequestMapping(value={"branches/{branchId}/template/connect"}, method={RequestMethod.POST})
    public Branch connectTemplateInstance(@PathVariable ID branchId, @RequestBody BranchTemplateInstanceConnectRequest request) {
        return this.branchTemplateService.connectTemplateInstance(branchId, request);
    }

    private BranchBuildView buildViewWithFilter(ID branchId, BuildFilter buildFilter) {
        Branch branch = this.getBranch(branchId);
        List builds = this.structureService.getFilteredBuilds(branchId, buildFilter);
        List buildDiffActions = this.extensionManager.getExtensions(BuildDiffExtension.class).stream().filter(extension -> extension.apply(branch.getProject())).map(arg_0 -> ((BranchController)this).resolveExtensionAction(arg_0)).collect(Collectors.toList());
        return new BranchBuildView(builds.stream().map(build -> this.structureService.getBuildView(build, true)).collect(Collectors.toList()), buildDiffActions);
    }
}

