/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import java.util.Collection;
import javax.validation.Valid;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.buildfilter.BuildFilterForm;
import net.nemerosa.ontrack.model.buildfilter.BuildFilterInput;
import net.nemerosa.ontrack.model.buildfilter.BuildFilterResource;
import net.nemerosa.ontrack.model.buildfilter.BuildFilterService;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resource;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
public class BuildFilterController
extends AbstractResourceController {
    private final BuildFilterService buildFilterService;

    @Autowired
    public BuildFilterController(BuildFilterService buildFilterService) {
        this.buildFilterService = buildFilterService;
    }

    @RequestMapping(value={"branches/{branchId}/filters"}, method={RequestMethod.GET})
    public Resources<BuildFilterResource<?>> buildFilters(@PathVariable ID branchId) {
        return Resources.of((Collection)this.buildFilterService.getBuildFilters(branchId), (URI)this.uri(((BuildFilterController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).buildFilters(branchId)));
    }

    @RequestMapping(value={"branches/{branchId}/filters/forms"}, method={RequestMethod.GET})
    public Resources<BuildFilterForm> buildFilterForms(@PathVariable ID branchId) {
        return Resources.of((Collection)this.buildFilterService.getBuildFilterForms(branchId), (URI)this.uri(((BuildFilterController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).buildFilterForms(branchId)));
    }

    @RequestMapping(value={"branches/{branchId}/filters/{name}"}, method={RequestMethod.GET})
    public Resource<BuildFilterForm> getEditionForm(@PathVariable ID branchId, @PathVariable String name) {
        BuildFilterForm editionForm = this.buildFilterService.getEditionForm(branchId, name);
        return (Resource)Resource.of((Object)editionForm, (URI)this.uri(((BuildFilterController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getEditionForm(branchId, name))).with("_update", this.uri(((BuildFilterController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).saveFilter(branchId, name, null)));
    }

    @RequestMapping(value={"branches/{branchId}/filters"}, method={RequestMethod.POST})
    public Ack createFilter(@PathVariable ID branchId, @RequestBody @Valid BuildFilterInput input) {
        return this.buildFilterService.saveFilter(branchId, input.isShared(), input.getName(), input.getType(), input.getData());
    }

    @RequestMapping(value={"branches/{branchId}/filters/{name}"}, method={RequestMethod.PUT})
    public Ack saveFilter(@PathVariable ID branchId, @PathVariable String name, @RequestBody @Valid BuildFilterInput input) {
        if (!StringUtils.equals((CharSequence)name, (CharSequence)input.getName())) {
            throw new IllegalArgumentException("The input name must be identical to the one in the URI.");
        }
        return this.buildFilterService.saveFilter(branchId, input.isShared(), name, input.getType(), input.getData());
    }

    @RequestMapping(value={"branches/{branchId}/filters/{name}"}, method={RequestMethod.DELETE})
    public Ack deleteFilter(@PathVariable ID branchId, @PathVariable String name) {
        return this.buildFilterService.deleteFilter(branchId, name);
    }
}

