/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import java.util.Collection;
import java.util.concurrent.Callable;
import net.nemerosa.ontrack.boot.ui.AbstractProjectEntityController;
import net.nemerosa.ontrack.model.structure.Decoration;
import net.nemerosa.ontrack.model.structure.DecorationService;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/decorations"})
public class DecorationsController
extends AbstractProjectEntityController {
    private final DecorationService decorationService;

    @Autowired
    public DecorationsController(StructureService structureService, DecorationService decorationService) {
        super(structureService);
        this.decorationService = decorationService;
    }

    @RequestMapping(value={"{entityType}/{id}"}, method={RequestMethod.GET})
    public Callable<Resources<Decoration<?>>> getDecorations(@PathVariable ProjectEntityType entityType, @PathVariable ID id) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        return () -> {
            RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
            try {
                Resources resources = Resources.of((Collection)this.decorationService.getDecorations(this.getEntity(entityType, id)), (URI)this.uri(((DecorationsController)((Object)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass())))).getDecorations(entityType, id))).forView(Decoration.class);
                return resources;
            }
            finally {
                RequestContextHolder.resetRequestAttributes();
            }
        };
    }
}

