/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import net.nemerosa.ontrack.boot.ui.BranchController;
import net.nemerosa.ontrack.boot.ui.BuildController;
import net.nemerosa.ontrack.boot.ui.ProjectController;
import net.nemerosa.ontrack.boot.ui.PromotionLevelController;
import net.nemerosa.ontrack.boot.ui.PromotionRunController;
import net.nemerosa.ontrack.boot.ui.ValidationRunController;
import net.nemerosa.ontrack.boot.ui.ValidationStampController;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.ui.controller.URIBuilder;
import org.springframework.context.annotation.Profile;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@Profile(value={"dev", "acceptance", "prod"})
public class DefaultURIBuilder
implements URIBuilder {
    public URI build(Object methodInvocation) {
        UriComponentsBuilder builder = MvcUriComponentsBuilder.fromMethodCall((Object)methodInvocation);
        UriComponents uriComponents = builder.build();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        ServletServerHttpRequest httpRequest = new ServletServerHttpRequest(request);
        String portHeader = httpRequest.getHeaders().getFirst("X-Forwarded-Port");
        if (StringUtils.hasText((String)portHeader)) {
            int port = Integer.parseInt(portHeader);
            String scheme = uriComponents.getScheme();
            if ("https".equals(scheme) && port == 443 || "http".equals(scheme) && port == 80) {
                port = -1;
            }
            builder.port(port);
        }
        return builder.build().toUri();
    }

    public URI page(String path, Object ... arguments) {
        String pagePath = String.format("/#/%s", String.format(path, arguments));
        return URI.create(ServletUriComponentsBuilder.fromCurrentServletMapping().build().toUriString() + pagePath);
    }

    public URI getEntityURI(ProjectEntity entity) {
        ProjectEntityType projectEntityType = entity.getProjectEntityType();
        switch (projectEntityType) {
            case PROJECT: {
                return this.build(((ProjectController)((Object)MvcUriComponentsBuilder.on(ProjectController.class))).getProject(entity.getId()));
            }
            case BRANCH: {
                return this.build(((BranchController)((Object)MvcUriComponentsBuilder.on(BranchController.class))).getBranch(entity.getId()));
            }
            case PROMOTION_LEVEL: {
                return this.build(((PromotionLevelController)((Object)MvcUriComponentsBuilder.on(PromotionLevelController.class))).getPromotionLevel(entity.getId()));
            }
            case VALIDATION_STAMP: {
                return this.build(((ValidationStampController)((Object)MvcUriComponentsBuilder.on(ValidationStampController.class))).getValidationStamp(entity.getId()));
            }
            case BUILD: {
                return this.build(((BuildController)((Object)MvcUriComponentsBuilder.on(BuildController.class))).getBuild(entity.getId()));
            }
            case PROMOTION_RUN: {
                return this.build(((PromotionRunController)((Object)MvcUriComponentsBuilder.on(PromotionRunController.class))).getPromotionRun(entity.getId()));
            }
            case VALIDATION_RUN: {
                return this.build(((ValidationRunController)((Object)MvcUriComponentsBuilder.on(ValidationRunController.class))).getValidationRun(entity.getId()));
            }
        }
        throw new IllegalStateException("Unknown entity type: " + projectEntityType);
    }

    public URI getEntityPage(ProjectEntity entity) {
        return this.page("%s/%d", entity.getProjectEntityType().name().toLowerCase(), entity.id());
    }
}

