/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.boot.ui.UIEvent;
import net.nemerosa.ontrack.model.events.Event;
import net.nemerosa.ontrack.model.events.EventQueryService;
import net.nemerosa.ontrack.model.exceptions.PropertyTypeNotFoundException;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.PropertyType;
import net.nemerosa.ontrack.model.structure.PropertyTypeDescriptor;
import net.nemerosa.ontrack.model.support.NameValue;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Pagination;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/events"})
public class EventController
extends AbstractResourceController {
    private final Logger logger = LoggerFactory.getLogger(EventController.class);
    private final EventQueryService eventQueryService;
    private final PropertyService propertyService;

    @Autowired
    public EventController(EventQueryService eventQueryService, PropertyService propertyService) {
        this.eventQueryService = eventQueryService;
        this.propertyService = propertyService;
    }

    @RequestMapping(value={"root"}, method={RequestMethod.GET})
    public Resources<UIEvent> getEvents(@RequestParam(required=false, defaultValue="0") int offset, @RequestParam(required=false, defaultValue="20") int count) {
        Resources resources = Resources.of((Collection)this.eventQueryService.getEvents(offset, count).stream().map(this::toUIEvent).collect(Collectors.toList()), (URI)this.uri(((EventController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getEvents(offset, count))).forView(UIEvent.class);
        Pagination pagination = Pagination.of((int)offset, (int)count, (int)-1);
        if (offset > 0) {
            pagination = pagination.withPrev(this.uri(((EventController)((Object)MvcUriComponentsBuilder.on(EventController.class))).getEvents(Math.max(0, offset - count), count)));
        }
        pagination = pagination.withNext(this.uri(((EventController)((Object)MvcUriComponentsBuilder.on(EventController.class))).getEvents(offset + count, count)));
        return resources.withPagination(pagination);
    }

    @RequestMapping(value={"{entityType}/{entityId}"}, method={RequestMethod.GET})
    public Resources<UIEvent> getEvents(@PathVariable ProjectEntityType entityType, @PathVariable ID entityId, @RequestParam(required=false, defaultValue="0") int offset, @RequestParam(required=false, defaultValue="10") int count) {
        Resources resources = Resources.of((Collection)this.eventQueryService.getEvents(entityType, entityId, offset, count).stream().map(this::toUIEvent).collect(Collectors.toList()), (URI)this.uri(((EventController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getEvents(entityType, entityId, offset, count))).forView(UIEvent.class);
        Pagination pagination = Pagination.of((int)offset, (int)count, (int)-1);
        if (offset > 0) {
            pagination = pagination.withPrev(this.uri(((EventController)((Object)MvcUriComponentsBuilder.on(EventController.class))).getEvents(entityType, entityId, Math.max(0, offset - count), count)));
        }
        pagination = pagination.withNext(this.uri(((EventController)((Object)MvcUriComponentsBuilder.on(EventController.class))).getEvents(entityType, entityId, offset + count, count)));
        return resources.withPagination(pagination);
    }

    protected UIEvent toUIEvent(Event event) {
        return new UIEvent(event.getEventType().getId(), event.getEventType().getTemplate(), event.getSignature(), event.getEntities(), event.getRef(), event.getValues(), this.computeData(event));
    }

    protected Map<String, ?> computeData(Event event) {
        HashMap<String, PropertyTypeDescriptor> result = new HashMap<String, PropertyTypeDescriptor>();
        NameValue property = (NameValue)event.getValues().get("property");
        if (property != null) {
            String propertyName = property.getName();
            try {
                PropertyType propertyType = this.propertyService.getPropertyTypeByName(propertyName);
                result.put("property", PropertyTypeDescriptor.of((PropertyType)propertyType));
            }
            catch (PropertyTypeNotFoundException ignored) {
                this.logger.warn("[event] Could not find property type for {}", (Object)propertyName);
            }
        }
        return result;
    }
}

