/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import java.util.Collection;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.security.AccountService;
import net.nemerosa.ontrack.model.security.GlobalPermission;
import net.nemerosa.ontrack.model.security.GlobalRole;
import net.nemerosa.ontrack.model.security.PermissionInput;
import net.nemerosa.ontrack.model.security.PermissionTarget;
import net.nemerosa.ontrack.model.security.PermissionTargetType;
import net.nemerosa.ontrack.model.security.ProjectPermission;
import net.nemerosa.ontrack.model.security.ProjectRole;
import net.nemerosa.ontrack.model.security.RolesService;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/accounts/permissions"})
public class PermissionController
extends AbstractResourceController {
    private final AccountService accountService;
    private final RolesService rolesService;

    @Autowired
    public PermissionController(AccountService accountService, RolesService rolesService) {
        this.accountService = accountService;
        this.rolesService = rolesService;
    }

    @RequestMapping(value={"search/{token:.*}"}, method={RequestMethod.GET})
    public Resources<PermissionTarget> searchPermissionTargets(@PathVariable String token) {
        return Resources.of((Collection)this.accountService.searchPermissionTargets(token), (URI)this.uri(((PermissionController)((Object)MvcUriComponentsBuilder.on(PermissionController.class))).searchPermissionTargets(token)));
    }

    @RequestMapping(value={"globals"}, method={RequestMethod.GET})
    public Resources<GlobalPermission> getGlobalPermissions() {
        return (Resources)Resources.of((Collection)this.accountService.getGlobalPermissions(), (URI)this.uri(((PermissionController)((Object)MvcUriComponentsBuilder.on(PermissionController.class))).getGlobalPermissions())).with("_globalRoles", this.uri(((PermissionController)((Object)MvcUriComponentsBuilder.on(PermissionController.class))).getGlobalRoles()));
    }

    @RequestMapping(value={"globals/roles"}, method={RequestMethod.GET})
    public Resources<GlobalRole> getGlobalRoles() {
        return Resources.of((Collection)this.rolesService.getGlobalRoles(), (URI)this.uri(((PermissionController)((Object)MvcUriComponentsBuilder.on(PermissionController.class))).getGlobalRoles()));
    }

    @RequestMapping(value={"globals/{type}/{id}"}, method={RequestMethod.PUT})
    public Ack saveGlobalPermission(@PathVariable PermissionTargetType type, @PathVariable int id, @RequestBody PermissionInput input) {
        return this.accountService.saveGlobalPermission(type, id, input);
    }

    @RequestMapping(value={"globals/{type}/{id}"}, method={RequestMethod.DELETE})
    public Ack deleteGlobalPermission(@PathVariable PermissionTargetType type, @PathVariable int id) {
        return this.accountService.deleteGlobalPermission(type, id);
    }

    @RequestMapping(value={"projects/roles"}, method={RequestMethod.GET})
    public Resources<ProjectRole> getProjectRoles() {
        return Resources.of((Collection)this.rolesService.getProjectRoles(), (URI)this.uri(((PermissionController)((Object)MvcUriComponentsBuilder.on(PermissionController.class))).getProjectRoles()));
    }

    @RequestMapping(value={"projects/{projectId}"}, method={RequestMethod.GET})
    public Resources<ProjectPermission> getProjectPermissions(@PathVariable ID projectId) {
        return (Resources)Resources.of((Collection)this.accountService.getProjectPermissions(projectId), (URI)this.uri(((PermissionController)((Object)MvcUriComponentsBuilder.on(PermissionController.class))).getProjectPermissions(projectId))).with("_projectRoles", this.uri(((PermissionController)((Object)MvcUriComponentsBuilder.on(PermissionController.class))).getProjectRoles()));
    }

    @RequestMapping(value={"projects/{projectId}/{type}/{id}"}, method={RequestMethod.PUT})
    public Ack saveProjectPermission(@PathVariable ID projectId, @PathVariable PermissionTargetType type, @PathVariable int id, @RequestBody PermissionInput input) {
        return this.accountService.saveProjectPermission(projectId, type, id, input);
    }

    @RequestMapping(value={"projects/{projectId}/{type}/{id}"}, method={RequestMethod.DELETE})
    public Ack deleteProjectPermission(@PathVariable ID projectId, @PathVariable PermissionTargetType type, @PathVariable int id) {
        return this.accountService.deleteProjectPermission(projectId, type, id);
    }
}

