/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import javax.validation.Valid;
import net.nemerosa.ontrack.common.Document;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.settings.PredefinedValidationStampService;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.PredefinedValidationStamp;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/admin"})
public class PredefinedValidationStampController
extends AbstractResourceController {
    private final PredefinedValidationStampService predefinedValidationStampService;

    @Autowired
    public PredefinedValidationStampController(PredefinedValidationStampService predefinedValidationStampService) {
        this.predefinedValidationStampService = predefinedValidationStampService;
    }

    @RequestMapping(value={"predefinedValidationStamps"}, method={RequestMethod.GET})
    public Resources<PredefinedValidationStamp> getPredefinedValidationStampList() {
        return (Resources)Resources.of((Collection)this.predefinedValidationStampService.getPredefinedValidationStamps(), (URI)this.uri(((PredefinedValidationStampController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getPredefinedValidationStampList())).with("_create", this.uri(((PredefinedValidationStampController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getPredefinedValidationStampCreationForm()));
    }

    @RequestMapping(value={"predefinedValidationStamps/create"}, method={RequestMethod.GET})
    public Form getPredefinedValidationStampCreationForm() {
        return PredefinedValidationStamp.form();
    }

    @RequestMapping(value={"predefinedValidationStamps/create"}, method={RequestMethod.POST})
    public PredefinedValidationStamp newPredefinedValidationStamp(@RequestBody @Valid NameDescription nameDescription) {
        return this.predefinedValidationStampService.newPredefinedValidationStamp(PredefinedValidationStamp.of((NameDescription)nameDescription));
    }

    @RequestMapping(value={"predefinedValidationStamps/{predefinedValidationStampId}"}, method={RequestMethod.GET})
    public PredefinedValidationStamp getValidationStamp(@PathVariable ID predefinedValidationStampId) {
        return this.predefinedValidationStampService.getPredefinedValidationStamp(predefinedValidationStampId);
    }

    @RequestMapping(value={"predefinedValidationStamps/{predefinedValidationStampId}/update"}, method={RequestMethod.GET})
    public Form updateValidationStampForm(@PathVariable ID predefinedValidationStampId) {
        return this.predefinedValidationStampService.getPredefinedValidationStamp(predefinedValidationStampId).asForm();
    }

    @RequestMapping(value={"predefinedValidationStamps/{predefinedValidationStampId}/update"}, method={RequestMethod.PUT})
    public PredefinedValidationStamp updateValidationStamp(@PathVariable ID predefinedValidationStampId, @RequestBody @Valid NameDescription nameDescription) {
        PredefinedValidationStamp validationStamp = this.predefinedValidationStampService.getPredefinedValidationStamp(predefinedValidationStampId);
        validationStamp = validationStamp.update(nameDescription);
        this.predefinedValidationStampService.savePredefinedValidationStamp(validationStamp);
        return validationStamp;
    }

    @RequestMapping(value={"predefinedValidationStamps/{predefinedValidationStampId}"}, method={RequestMethod.DELETE})
    public Ack deleteValidationStamp(@PathVariable ID predefinedValidationStampId) {
        return this.predefinedValidationStampService.deletePredefinedValidationStamp(predefinedValidationStampId);
    }

    @RequestMapping(value={"predefinedValidationStamps/{predefinedValidationStampId}/image"}, method={RequestMethod.GET})
    public Document getValidationStampImage(@PathVariable ID predefinedValidationStampId) {
        return this.predefinedValidationStampService.getPredefinedValidationStampImage(predefinedValidationStampId);
    }

    @RequestMapping(value={"predefinedValidationStamps/{predefinedValidationStampId}/image"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void setValidationStampImage(@PathVariable ID predefinedValidationStampId, @RequestParam MultipartFile file) throws IOException {
        this.predefinedValidationStampService.setPredefinedValidationStampImage(predefinedValidationStampId, new Document(file.getContentType(), file.getBytes()));
    }
}

