/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import java.util.Collection;
import javax.validation.Valid;
import net.nemerosa.ontrack.boot.ui.BranchController;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Replacements;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.BranchCreate;
import net.nemerosa.ontrack.model.security.ProjectCreation;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.BranchStatusView;
import net.nemerosa.ontrack.model.structure.CopyService;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescriptionState;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectCloneRequest;
import net.nemerosa.ontrack.model.structure.ProjectStatusView;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resources;
import net.nemerosa.ontrack.ui.support.API;
import net.nemerosa.ontrack.ui.support.APIMethod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/structure/projects"})
@API(value="Management of projects")
public class ProjectController
extends AbstractResourceController {
    private final StructureService structureService;
    private final CopyService copyService;
    private final SecurityService securityService;

    @Autowired
    public ProjectController(StructureService structureService, CopyService copyService, SecurityService securityService) {
        this.structureService = structureService;
        this.copyService = copyService;
        this.securityService = securityService;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public Resources<Project> getProjectList() {
        return (Resources)Resources.of((Collection)this.structureService.getProjectList(), (URI)this.uri(((ProjectController)((Object)MvcUriComponentsBuilder.on(ProjectController.class))).getProjectList())).with("_create", this.uri(((ProjectController)((Object)MvcUriComponentsBuilder.on(ProjectController.class))).newProject(null)), this.securityService.isGlobalFunctionGranted(ProjectCreation.class));
    }

    @RequestMapping(value={"view"}, method={RequestMethod.GET})
    public Resources<ProjectStatusView> getProjectStatusViews() {
        return (Resources)Resources.of((Collection)this.structureService.getProjectStatusViews(), (URI)this.uri(((ProjectController)((Object)MvcUriComponentsBuilder.on(ProjectController.class))).getProjectStatusViews())).with("_create", this.uri(((ProjectController)((Object)MvcUriComponentsBuilder.on(ProjectController.class))).newProject(null)), this.securityService.isGlobalFunctionGranted(ProjectCreation.class));
    }

    @RequestMapping(value={"create"}, method={RequestMethod.GET})
    public Form newProjectForm() {
        return Project.form();
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Project newProject(@RequestBody @Valid NameDescriptionState nameDescription) {
        Project project = Project.of((NameDescriptionState)nameDescription);
        project = this.structureService.newProject(project);
        return project;
    }

    @RequestMapping(value={"{projectId}/view"}, method={RequestMethod.GET})
    public Resources<BranchStatusView> getBranchStatusViews(@PathVariable ID projectId) {
        return (Resources)Resources.of((Collection)this.structureService.getBranchStatusViews(projectId), (URI)this.uri(((ProjectController)((Object)MvcUriComponentsBuilder.on(ProjectController.class))).getBranchStatusViews(projectId))).forView(BranchStatusView.class).with("_create", this.uri(((BranchController)((Object)MvcUriComponentsBuilder.on(BranchController.class))).newBranch(projectId, null)), this.securityService.isProjectFunctionGranted(projectId.get(), BranchCreate.class));
    }

    @RequestMapping(value={"{projectId}"}, method={RequestMethod.GET})
    public Project getProject(@PathVariable ID projectId) {
        return this.structureService.getProject(projectId);
    }

    @RequestMapping(value={"{projectId}"}, method={RequestMethod.DELETE})
    public Ack deleteProject(@PathVariable ID projectId) {
        return this.structureService.deleteProject(projectId);
    }

    @RequestMapping(value={"{projectId}/update"}, method={RequestMethod.GET})
    @APIMethod(value="Project update form", description="Get the form for the project update")
    public Form saveProjectForm(@PathVariable ID projectId) {
        return this.structureService.getProject(projectId).asForm();
    }

    @RequestMapping(value={"{projectId}/update"}, method={RequestMethod.PUT})
    @APIMethod(value="Updates project")
    public Project saveProject(@PathVariable ID projectId, @RequestBody @Valid NameDescriptionState nameDescription) {
        Project project = this.structureService.getProject(projectId);
        project = project.update(nameDescription);
        this.structureService.saveProject(project);
        return project;
    }

    @RequestMapping(value={"{projectId}/enable"}, method={RequestMethod.PUT})
    public Project enableProject(@PathVariable ID projectId) {
        Project project = this.structureService.getProject(projectId);
        project = project.withDisabled(false);
        this.structureService.saveProject(project);
        return project;
    }

    @RequestMapping(value={"{projectId}/disable"}, method={RequestMethod.PUT})
    public Project disableProject(@PathVariable ID projectId) {
        Project project = this.structureService.getProject(projectId);
        project = project.withDisabled(true);
        this.structureService.saveProject(project);
        return project;
    }

    @RequestMapping(value={"{projectId}/clone"}, method={RequestMethod.GET})
    public Form clone(@PathVariable ID projectId) {
        return Form.create().with((Field)((Text)Text.of((String)"name").label("Target project")).help("Name of the project to create")).with((Field)Replacements.of((String)"replacements").label("Replacements"));
    }

    @RequestMapping(value={"{projectId}/clone"}, method={RequestMethod.POST})
    public Project clone(@PathVariable ID projectId, @RequestBody ProjectCloneRequest request) {
        Project project = this.structureService.getProject(projectId);
        return this.copyService.cloneProject(project, request);
    }
}

