/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.boot.ui.AbstractProjectEntityController;
import net.nemerosa.ontrack.extension.api.EntityInformationExtension;
import net.nemerosa.ontrack.extension.api.ExtensionManager;
import net.nemerosa.ontrack.extension.api.ProjectEntityActionExtension;
import net.nemerosa.ontrack.extension.api.model.EntityInformation;
import net.nemerosa.ontrack.model.extension.Extension;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.support.Action;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/extensions/entity"})
public class ProjectEntityExtensionController
extends AbstractProjectEntityController {
    private final ExtensionManager extensionManager;

    @Autowired
    public ProjectEntityExtensionController(StructureService structureService, ExtensionManager extensionManager) {
        super(structureService);
        this.extensionManager = extensionManager;
    }

    @RequestMapping(value={"actions/{entityType}/{id}"}, method={RequestMethod.GET})
    public Resources<Action> getActions(@PathVariable ProjectEntityType entityType, @PathVariable ID id) {
        return Resources.of((Collection)this.extensionManager.getExtensions(ProjectEntityActionExtension.class).stream().map(x -> x.getAction(this.getEntity(entityType, id)).map(action -> this.resolveExtensionAction((Extension)x, (Action)action))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()), (URI)this.uri(((ProjectEntityExtensionController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getActions(entityType, id)));
    }

    @RequestMapping(value={"information/{entityType}/{id}"}, method={RequestMethod.GET})
    public Resources<EntityInformation> getInformation(@PathVariable ProjectEntityType entityType, @PathVariable ID id) {
        ProjectEntity entity = this.getEntity(entityType, id);
        List informations = this.extensionManager.getExtensions(EntityInformationExtension.class).stream().map(x -> x.getInformation(entity)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return Resources.of(informations, (URI)this.uri(((ProjectEntityExtensionController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getInformation(entityType, id)));
    }
}

