/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.nemerosa.ontrack.boot.ui.UIUtils;
import net.nemerosa.ontrack.common.Document;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.security.PromotionLevelCreate;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.PromotionRunView;
import net.nemerosa.ontrack.model.structure.Reordering;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resource;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/structure"})
public class PromotionLevelController
extends AbstractResourceController {
    private final StructureService structureService;
    private final SecurityService securityService;

    @Autowired
    public PromotionLevelController(StructureService structureService, SecurityService securityService) {
        this.structureService = structureService;
        this.securityService = securityService;
    }

    @RequestMapping(value={"branches/{branchId}/promotionLevels"}, method={RequestMethod.GET})
    public Resources<PromotionLevel> getPromotionLevelListForBranch(@PathVariable ID branchId) {
        Branch branch = this.structureService.getBranch(branchId);
        return (Resources)Resources.of((Collection)this.structureService.getPromotionLevelListForBranch(branchId), (URI)this.uri(((PromotionLevelController)((Object)MvcUriComponentsBuilder.on(PromotionLevelController.class))).getPromotionLevelListForBranch(branchId))).with("_create", this.uri(((PromotionLevelController)((Object)MvcUriComponentsBuilder.on(PromotionLevelController.class))).newPromotionLevelForm(branchId)), this.securityService.isProjectFunctionGranted(branch.getProject().id(), PromotionLevelCreate.class));
    }

    @RequestMapping(value={"branches/{branchId}/promotionLevels/reorder"}, method={RequestMethod.PUT})
    public Resources<PromotionLevel> reorderPromotionLevelListForBranch(@PathVariable ID branchId, @RequestBody Reordering reordering) {
        this.structureService.reorderPromotionLevels(branchId, reordering);
        return this.getPromotionLevelListForBranch(branchId);
    }

    @RequestMapping(value={"branches/{branchId}/promotionLevels/create"}, method={RequestMethod.GET})
    public Form newPromotionLevelForm(@PathVariable ID branchId) {
        this.structureService.getBranch(branchId);
        return PromotionLevel.form();
    }

    @RequestMapping(value={"branches/{branchId}/promotionLevels/create"}, method={RequestMethod.POST})
    public PromotionLevel newPromotionLevel(@PathVariable ID branchId, @RequestBody @Valid NameDescription nameDescription) {
        Branch branch = this.structureService.getBranch(branchId);
        PromotionLevel promotionLevel = PromotionLevel.of((Branch)branch, (NameDescription)nameDescription);
        promotionLevel = this.structureService.newPromotionLevel(promotionLevel);
        return promotionLevel;
    }

    @RequestMapping(value={"promotionLevels/{promotionLevelId}"}, method={RequestMethod.GET})
    public PromotionLevel getPromotionLevel(@PathVariable ID promotionLevelId) {
        return this.structureService.getPromotionLevel(promotionLevelId);
    }

    @RequestMapping(value={"promotionLevels/{promotionLevelId}/update"}, method={RequestMethod.GET})
    public Form updatePromotionLevelForm(@PathVariable ID promotionLevelId) {
        return this.structureService.getPromotionLevel(promotionLevelId).asForm();
    }

    @RequestMapping(value={"promotionLevels/{promotionLevelId}/update"}, method={RequestMethod.PUT})
    public PromotionLevel updatePromotionLevel(@PathVariable ID promotionLevelId, @RequestBody @Valid NameDescription nameDescription) {
        PromotionLevel promotionLevel = this.structureService.getPromotionLevel(promotionLevelId);
        promotionLevel = promotionLevel.update(nameDescription);
        this.structureService.savePromotionLevel(promotionLevel);
        return promotionLevel;
    }

    @RequestMapping(value={"promotionLevels/{promotionLevelId}"}, method={RequestMethod.DELETE})
    public Ack deletePromotionLevel(@PathVariable ID promotionLevelId) {
        return this.structureService.deletePromotionLevel(promotionLevelId);
    }

    @RequestMapping(value={"promotionLevels/{promotionLevelId}/image"}, method={RequestMethod.GET})
    public Document getPromotionLevelImage_(HttpServletResponse response, @PathVariable ID promotionLevelId) {
        Document document = this.structureService.getPromotionLevelImage(promotionLevelId);
        UIUtils.setupDefaultImageCache(response, document);
        return document;
    }

    @RequestMapping(value={"promotionLevels/{promotionLevelId}/image"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void setPromotionLevelImage(@PathVariable ID promotionLevelId, @RequestParam MultipartFile file) throws IOException {
        this.structureService.setPromotionLevelImage(promotionLevelId, new Document(file.getContentType(), file.getBytes()));
    }

    @RequestMapping(value={"promotionLevels/{promotionLevelId}/runs"}, method={RequestMethod.GET})
    public Resource<PromotionRunView> getPromotionRunView(@PathVariable ID promotionLevelId) {
        return Resource.of((Object)this.structureService.getPromotionRunView(this.getPromotionLevel(promotionLevelId)), (URI)this.uri(((PromotionLevelController)((Object)MvcUriComponentsBuilder.on(PromotionLevelController.class))).getPromotionRunView(promotionLevelId)));
    }
}

