/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.json.ObjectMapperFactory;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.DescribedForm;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.settings.SettingsManager;
import net.nemerosa.ontrack.model.settings.SettingsManagerNotFoundException;
import net.nemerosa.ontrack.model.settings.SettingsValidationException;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/settings"})
public class SettingsController
extends AbstractResourceController {
    private final Collection<SettingsManager<?>> settingsManagers;
    private final ObjectMapper objectMapper = ObjectMapperFactory.create();

    @Autowired
    public SettingsController(Collection<SettingsManager<?>> settingsManagers) {
        this.settingsManagers = settingsManagers;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public Resources<DescribedForm> configuration() {
        List forms = this.settingsManagers.stream().sorted((o1, o2) -> o1.getTitle().compareTo(o2.getTitle())).map(this::getSettingsForm).collect(Collectors.toList());
        return Resources.of(forms, (URI)this.uri(((SettingsController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).configuration()));
    }

    @RequestMapping(value={"/{type:.*}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public <T> Ack updateSettings(@PathVariable String type, @RequestBody JsonNode settingsNode) {
        Object settings;
        SettingsManager settingsManager = this.settingsManagers.stream().filter(candidate -> StringUtils.equals((CharSequence)type, (CharSequence)this.getSettingsManagerName((SettingsManager<?>)candidate))).findFirst().orElseThrow(() -> new SettingsManagerNotFoundException(type));
        try {
            settings = this.objectMapper.treeToValue((TreeNode)settingsNode, settingsManager.getSettingsClass());
        }
        catch (JsonProcessingException e) {
            throw new SettingsValidationException((Exception)((Object)e));
        }
        settingsManager.saveSettings(settings);
        return Ack.OK;
    }

    private String getSettingsManagerName(SettingsManager<?> settingsManager) {
        return settingsManager.getId();
    }

    private <T> DescribedForm getSettingsForm(SettingsManager<T> settingsManager) {
        return DescribedForm.create((String)this.getSettingsManagerName(settingsManager), (Form)settingsManager.getSettingsForm()).title(settingsManager.getTitle()).uri(this.uri(((SettingsController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).updateSettings(this.getSettingsManagerName(settingsManager), null)));
    }
}

