/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import net.nemerosa.ontrack.common.Document;
import net.nemerosa.ontrack.json.JsonUtils;
import org.springframework.http.CacheControl;
import org.springframework.web.context.request.WebRequest;

public final class UIUtils {
    private UIUtils() {
    }

    public static JsonNode requestParametersToJson(WebRequest request) {
        Map requestParameters = request.getParameterMap();
        Map parameters = Maps.transformValues((Map)requestParameters, array -> {
            if (array == null || ((String[])array).length == 0) {
                return null;
            }
            if (((String[])array).length == 1) {
                return array[0];
            }
            throw new IllegalArgumentException("Cannot accept several identical parameters");
        });
        return JsonUtils.mapToJson((Map)parameters);
    }

    public static void setupDefaultImageCache(HttpServletResponse response, Document document) {
        UIUtils.setupImageCache(response, document, 1);
    }

    public static void setupImageCache(HttpServletResponse response, Document document, int maxDays) {
        if (!document.isEmpty()) {
            String cacheControl = CacheControl.maxAge((long)maxDays, (TimeUnit)TimeUnit.DAYS).cachePublic().getHeaderValue();
            response.setHeader("Cache-Control", cacheControl);
        }
    }
}

