/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import java.util.Collection;
import javax.validation.Valid;
import net.nemerosa.ontrack.extension.api.ActionExtension;
import net.nemerosa.ontrack.extension.api.ExtensionManager;
import net.nemerosa.ontrack.extension.api.UserMenuExtension;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Password;
import net.nemerosa.ontrack.model.security.Account;
import net.nemerosa.ontrack.model.security.AccountManagement;
import net.nemerosa.ontrack.model.security.ApplicationManagement;
import net.nemerosa.ontrack.model.security.ConnectedAccount;
import net.nemerosa.ontrack.model.security.GlobalSettings;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.security.UserService;
import net.nemerosa.ontrack.model.support.Action;
import net.nemerosa.ontrack.model.support.PasswordChange;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/user"})
public class UserController
extends AbstractResourceController {
    private final SecurityService securityService;
    private final UserService userService;
    private final ExtensionManager extensionManager;

    @Autowired
    public UserController(SecurityService securityService, UserService userService, ExtensionManager extensionManager) {
        this.securityService = securityService;
        this.userService = userService;
        this.extensionManager = extensionManager;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public ConnectedAccount getCurrentUser() {
        Account account = this.securityService.getCurrentAccount();
        if (account != null) {
            return this.toLoggedAccount(account);
        }
        return this.toAnonymousAccount();
    }

    @RequestMapping(value={"login"}, method={RequestMethod.GET})
    public Form loginForm() {
        return Form.create().name().password();
    }

    @RequestMapping(value={"login"}, method={RequestMethod.POST})
    public ConnectedAccount login() {
        Account account = this.securityService.getCurrentAccount();
        if (account == null) {
            throw new AccessDeniedException("Login required.");
        }
        return this.toLoggedAccount(account);
    }

    @RequestMapping(value={"logged-out"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void loggedOut() {
    }

    @RequestMapping(value={"password"}, method={RequestMethod.GET})
    public Form getChangePasswordForm() {
        return Form.create().with((Field)((Password)Password.of((String)"oldPassword").label("Old password")).help("You need your old password in order to change it. If you do not remember it, you'll have to contact an administrator who can change it for you.")).with((Field)((Password)Password.of((String)"newPassword").label("New password")).withConfirmation());
    }

    @RequestMapping(value={"password"}, method={RequestMethod.POST})
    public Ack changePassword(@RequestBody @Valid PasswordChange input) {
        return this.userService.changePassword(input);
    }

    private ConnectedAccount toAnonymousAccount() {
        return ConnectedAccount.none();
    }

    private ConnectedAccount toLoggedAccount(Account account) {
        return this.userMenu(ConnectedAccount.of((Account)account));
    }

    private ConnectedAccount userMenu(ConnectedAccount user) {
        if (this.securityService.isGlobalFunctionGranted(GlobalSettings.class)) {
            user.add(Action.of((String)"settings", (String)"Settings", (String)"settings", (Object[])new Object[0]));
        }
        if (user.getAccount().getAuthenticationSource().isAllowingPasswordChange()) {
            user.add(Action.form((String)"user-password", (String)"Change password", (URI)this.uri(((UserController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getChangePasswordForm())));
        }
        if (this.securityService.isGlobalFunctionGranted(AccountManagement.class)) {
            user.add(Action.of((String)"admin-accounts", (String)"Account management", (String)"admin-accounts", (Object[])new Object[0]));
        }
        if (this.securityService.isGlobalFunctionGranted(GlobalSettings.class)) {
            user.add(Action.of((String)"admin-predefined-validation-stamps", (String)"Predefined validation stamps", (String)"admin-predefined-validation-stamps", (Object[])new Object[0]));
            user.add(Action.of((String)"admin-predefined-promotion-levels", (String)"Predefined promotion levels", (String)"admin-predefined-promotion-levels", (Object[])new Object[0]));
        }
        user = this.userMenuExtensions(user);
        if (this.securityService.isGlobalFunctionGranted(ApplicationManagement.class)) {
            user.add(Action.of((String)"admin-console", (String)"Admin console", (String)"admin-console", (Object[])new Object[0]));
        }
        return user;
    }

    private ConnectedAccount userMenuExtensions(ConnectedAccount user) {
        Collection extensions = this.extensionManager.getExtensions(UserMenuExtension.class);
        for (UserMenuExtension extension : extensions) {
            Class fn = extension.getGlobalFunction();
            if (fn != null && !this.securityService.isGlobalFunctionGranted(fn)) continue;
            user.add(this.resolveExtensionAction((ActionExtension)extension));
        }
        return user;
    }
}

