/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Selection;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PropertyCreationRequest;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.structure.ValidationRun;
import net.nemerosa.ontrack.model.structure.ValidationRunRequest;
import net.nemerosa.ontrack.model.structure.ValidationRunStatus;
import net.nemerosa.ontrack.model.structure.ValidationRunStatusChangeRequest;
import net.nemerosa.ontrack.model.structure.ValidationRunStatusID;
import net.nemerosa.ontrack.model.structure.ValidationRunStatusService;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import net.nemerosa.ontrack.model.structure.ValidationStampRunView;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Pagination;
import net.nemerosa.ontrack.ui.resource.PaginationCountException;
import net.nemerosa.ontrack.ui.resource.PaginationOffsetException;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/structure"})
public class ValidationRunController
extends AbstractResourceController {
    private final StructureService structureService;
    private final ValidationRunStatusService validationRunStatusService;
    private final PropertyService propertyService;
    private final SecurityService securityService;

    @Autowired
    public ValidationRunController(StructureService structureService, ValidationRunStatusService validationRunStatusService, PropertyService propertyService, SecurityService securityService) {
        this.structureService = structureService;
        this.validationRunStatusService = validationRunStatusService;
        this.propertyService = propertyService;
        this.securityService = securityService;
    }

    @RequestMapping(value={"builds/{buildId}/validationRuns/view"}, method={RequestMethod.GET})
    public Resources<ValidationStampRunView> getValidationStampRunViews(@PathVariable ID buildId) {
        Build build = this.structureService.getBuild(buildId);
        List views = this.structureService.getValidationStampRunViewsForBuild(build);
        URI uri = this.uri(((ValidationRunController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getValidationStampRunViews(buildId));
        return Resources.of((Collection)views, (URI)uri).forView(ValidationStampRunView.class);
    }

    @RequestMapping(value={"builds/{buildId}/validationRuns"}, method={RequestMethod.GET})
    public Resources<ValidationRun> getValidationRuns(@PathVariable ID buildId) {
        return Resources.of((Collection)this.structureService.getValidationRunsForBuild(buildId), (URI)this.uri(((ValidationRunController)((Object)MvcUriComponentsBuilder.on(ValidationRunController.class))).getValidationRuns(buildId))).forView(Build.class);
    }

    @RequestMapping(value={"builds/{buildId}/validationRuns/create"}, method={RequestMethod.GET})
    public Form newValidationRunForm(@PathVariable ID buildId) {
        Build build = this.structureService.getBuild(buildId);
        return Form.create().with((Field)((Selection)Selection.of((String)"validationStampId").label("Validation stamp")).items(this.structureService.getValidationStampListForBranch(build.getBranch().getId()))).with((Field)((Selection)Selection.of((String)"validationRunStatusId").label("Status")).items(this.validationRunStatusService.getValidationRunStatusRoots())).description();
    }

    @RequestMapping(value={"builds/{buildId}/validationRuns/create"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ValidationRun newValidationRun(@PathVariable ID buildId, @RequestBody ValidationRunRequest validationRunRequest) {
        Build build = this.structureService.getBuild(buildId);
        ValidationStamp validationStamp = this.getValidationStamp(build.getBranch(), validationRunRequest.getValidationStampId(), validationRunRequest.getValidationStampName());
        ValidationRunStatusID validationRunStatusID = this.validationRunStatusService.getValidationRunStatus(validationRunRequest.getValidationRunStatusId());
        ValidationRun validationRun = ValidationRun.of((Build)build, (ValidationStamp)validationStamp, (int)0, (Signature)this.securityService.getCurrentSignature(), (ValidationRunStatusID)validationRunStatusID, (String)validationRunRequest.getDescription());
        validationRun = this.structureService.newValidationRun(validationRun);
        for (PropertyCreationRequest propertyCreationRequest : validationRunRequest.getProperties()) {
            this.propertyService.editProperty((ProjectEntity)validationRun, propertyCreationRequest.getPropertyTypeName(), propertyCreationRequest.getPropertyData());
        }
        return validationRun;
    }

    protected ValidationStamp getValidationStamp(Branch branch, Integer validationStampId, String validationStampName) {
        return this.structureService.getOrCreateValidationStamp(branch, validationStampId, validationStampName);
    }

    @RequestMapping(value={"validationRuns/{validationRunId}"}, method={RequestMethod.GET})
    public ValidationRun getValidationRun(@PathVariable ID validationRunId) {
        return this.structureService.getValidationRun(validationRunId);
    }

    @RequestMapping(value={"validationRuns/{validationRunId}/status/change"}, method={RequestMethod.GET})
    public Form getValidationRunStatusChangeForm(@PathVariable ID validationRunId) {
        ValidationRun validationRun = this.structureService.getValidationRun(validationRunId);
        return Form.create().with((Field)((Selection)Selection.of((String)"validationRunStatusId").label("Status")).items(this.validationRunStatusService.getNextValidationRunStatusList(validationRun.getLastStatus().getStatusID().getId()))).description();
    }

    @RequestMapping(value={"validationRuns/{validationRunId}/status/change"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ValidationRun validationRunStatusChange(@PathVariable ID validationRunId, @RequestBody ValidationRunStatusChangeRequest request) {
        ValidationRun run = this.structureService.getValidationRun(validationRunId);
        ValidationRunStatus runStatus = ValidationRunStatus.of((Signature)this.securityService.getCurrentSignature(), (ValidationRunStatusID)this.validationRunStatusService.getValidationRunStatus(request.getValidationRunStatusId()), (String)request.getDescription());
        return this.structureService.newValidationRunStatus(run, runStatus);
    }

    @RequestMapping(value={"validationStamps/{validationStampId}/validationRuns"}, method={RequestMethod.GET})
    public Resources<ValidationRun> getValidationRunsForValidationStamp(@PathVariable ID validationStampId, @RequestParam(required=false, defaultValue="0") int offset, @RequestParam(required=false, defaultValue="10") int count) {
        List runs = this.structureService.getValidationRunsForValidationStamp(validationStampId, 0, Integer.MAX_VALUE);
        int total = runs.size();
        if (offset < 0) {
            throw new PaginationOffsetException(offset);
        }
        if (offset > 0 && offset >= total) {
            throw new PaginationOffsetException(offset);
        }
        if (count <= 0) {
            throw new PaginationCountException(count);
        }
        Resources resources = Resources.of(runs.subList(offset, Math.min(offset + count, runs.size())), (URI)this.uri(((ValidationRunController)((Object)MvcUriComponentsBuilder.on(ValidationRunController.class))).getValidationRunsForValidationStamp(validationStampId, offset, count)));
        Pagination pagination = Pagination.of((int)offset, (int)count, (int)total);
        if (offset > 0) {
            pagination = pagination.withPrev(this.uri(((ValidationRunController)((Object)MvcUriComponentsBuilder.on(ValidationRunController.class))).getValidationRunsForValidationStamp(validationStampId, Math.max(0, offset - count), count)));
        }
        if (offset + count < total) {
            pagination = pagination.withNext(this.uri(((ValidationRunController)((Object)MvcUriComponentsBuilder.on(ValidationRunController.class))).getValidationRunsForValidationStamp(validationStampId, offset + count, count)));
        }
        return resources.withPagination(pagination).forView(ValidationStampRunView.class);
    }
}

