/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.nemerosa.ontrack.boot.ui.UIUtils;
import net.nemerosa.ontrack.common.Document;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.security.ValidationStampCreate;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.DecorationService;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.Reordering;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import net.nemerosa.ontrack.model.structure.ValidationStampView;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/structure"})
public class ValidationStampController
extends AbstractResourceController {
    private final StructureService structureService;
    private final SecurityService securityService;
    private final DecorationService decorationService;

    @Autowired
    public ValidationStampController(StructureService structureService, SecurityService securityService, DecorationService decorationService) {
        this.structureService = structureService;
        this.securityService = securityService;
        this.decorationService = decorationService;
    }

    @RequestMapping(value={"branches/{branchId}/validationStamps"}, method={RequestMethod.GET})
    public Resources<ValidationStamp> getValidationStampListForBranch(@PathVariable ID branchId) {
        Branch branch = this.structureService.getBranch(branchId);
        return (Resources)Resources.of((Collection)this.structureService.getValidationStampListForBranch(branchId), (URI)this.uri(((ValidationStampController)((Object)MvcUriComponentsBuilder.on(ValidationStampController.class))).getValidationStampListForBranch(branchId))).with("_create", this.uri(((ValidationStampController)((Object)MvcUriComponentsBuilder.on(ValidationStampController.class))).newValidationStampForm(branchId)), this.securityService.isProjectFunctionGranted(branch.getProject().id(), ValidationStampCreate.class));
    }

    @RequestMapping(value={"branches/{branchId}/validationStamps/view"}, method={RequestMethod.GET})
    @Transactional
    public Resources<ValidationStampView> getValidationStampViewListForBranch(@PathVariable ID branchId) {
        return this.getValidationStampListForBranch(branchId).transform(validationStamp -> ValidationStampView.of((ValidationStamp)validationStamp, (List)this.decorationService.getDecorations((ProjectEntity)validationStamp)));
    }

    @RequestMapping(value={"branches/{branchId}/validationStamps/reorder"}, method={RequestMethod.PUT})
    public Resources<ValidationStamp> reorderValidationStampListForBranch(@PathVariable ID branchId, @RequestBody Reordering reordering) {
        this.structureService.reorderValidationStamps(branchId, reordering);
        return this.getValidationStampListForBranch(branchId);
    }

    @RequestMapping(value={"branches/{branchId}/validationStamps/create"}, method={RequestMethod.GET})
    public Form newValidationStampForm(@PathVariable ID branchId) {
        this.structureService.getBranch(branchId);
        return ValidationStamp.form();
    }

    @RequestMapping(value={"branches/{branchId}/validationStamps/create"}, method={RequestMethod.POST})
    public ValidationStamp newValidationStamp(@PathVariable ID branchId, @RequestBody @Valid NameDescription nameDescription) {
        Branch branch = this.structureService.getBranch(branchId);
        ValidationStamp validationStamp = ValidationStamp.of((Branch)branch, (NameDescription)nameDescription);
        return this.structureService.newValidationStamp(validationStamp);
    }

    @RequestMapping(value={"validationStamps/{validationStampId}"}, method={RequestMethod.GET})
    public ValidationStamp getValidationStamp(@PathVariable ID validationStampId) {
        return this.structureService.getValidationStamp(validationStampId);
    }

    @RequestMapping(value={"validationStamps/{validationStampId}/update"}, method={RequestMethod.GET})
    public Form updateValidationStampForm(@PathVariable ID validationStampId) {
        return this.structureService.getValidationStamp(validationStampId).asForm();
    }

    @RequestMapping(value={"validationStamps/{validationStampId}/update"}, method={RequestMethod.PUT})
    public ValidationStamp updateValidationStamp(@PathVariable ID validationStampId, @RequestBody @Valid NameDescription nameDescription) {
        ValidationStamp validationStamp = this.structureService.getValidationStamp(validationStampId);
        validationStamp = validationStamp.update(nameDescription);
        this.structureService.saveValidationStamp(validationStamp);
        return validationStamp;
    }

    @RequestMapping(value={"validationStamps/{validationStampId}"}, method={RequestMethod.DELETE})
    public Ack deleteValidationStamp(@PathVariable ID validationStampId) {
        return this.structureService.deleteValidationStamp(validationStampId);
    }

    @RequestMapping(value={"validationStamps/{validationStampId}/image"}, method={RequestMethod.GET})
    public Document getValidationStampImage_(HttpServletResponse response, @PathVariable ID validationStampId) {
        Document image = this.structureService.getValidationStampImage(validationStampId);
        UIUtils.setupDefaultImageCache(response, image);
        return image;
    }

    @RequestMapping(value={"validationStamps/{validationStampId}/image"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void setValidationStampImage(@PathVariable ID validationStampId, @RequestParam MultipartFile file) throws IOException {
        this.structureService.setValidationStampImage(validationStampId, new Document(file.getContentType(), file.getBytes()));
    }
}

